/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.floatmatrix.impl;

import org.ujmp.core.Matrix;
import org.ujmp.core.enums.ValueType;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.floatmatrix.FloatMatrix;
import org.ujmp.core.genericmatrix.impl.DefaultSparseGenericMatrix;
import org.ujmp.core.util.MathUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSparseFloatMatrix
extends DefaultSparseGenericMatrix<Float>
implements FloatMatrix {
    private static final long serialVersionUID = -3321607593194609473L;

    public DefaultSparseFloatMatrix(Matrix m) throws MatrixException {
        super(m, -1);
    }

    public DefaultSparseFloatMatrix(Matrix m, int maximumNumberOfEntries) throws MatrixException {
        super(m, maximumNumberOfEntries);
    }

    public DefaultSparseFloatMatrix(long ... size) {
        super(size);
    }

    public DefaultSparseFloatMatrix(int maximumNumberOfEntries, long ... size) {
        super(maximumNumberOfEntries, size);
    }

    @Override
    public final ValueType getValueType() {
        return ValueType.FLOAT;
    }

    @Override
    public float getFloat(long ... coordinates) throws MatrixException {
        return MathUtil.getFloat(this.getObject(coordinates));
    }

    @Override
    public void setFloat(float value, long ... coordinates) throws MatrixException {
        this.setObject(Float.valueOf(value), coordinates);
    }
}

