/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.gui.panels;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.ujmp.core.Coordinates;
import org.ujmp.core.interfaces.HasToolTip;
import org.ujmp.gui.MatrixGUIObject;
import org.ujmp.gui.actions.MatrixActions;
import org.ujmp.gui.interfaces.CanBeRepainted;
import org.ujmp.gui.io.ExportJPEG;
import org.ujmp.gui.io.ExportPDF;
import org.ujmp.gui.io.ExportPNG;
import org.ujmp.gui.menu.MatrixPopupMenu;
import org.ujmp.gui.renderer.MatrixRenderer;
import org.ujmp.gui.util.GraphicsExecutor;
import org.ujmp.gui.util.TooltipUtil;

public class MatrixPaintPanel
extends JPanel
implements ComponentListener,
TableModelListener,
MouseListener,
MouseMotionListener,
CanBeRepainted,
HasToolTip,
ListSelectionListener {
    private static final long serialVersionUID = 843653796010276950L;
    private MatrixGUIObject matrix = null;
    private final MatrixRenderer renderer = new MatrixRenderer();
    private BufferedImage bufferedImage = null;
    private static int PADDINGX = UIManager.getInt("Table.paddingX");
    private static int PADDINGY = UIManager.getInt("Table.paddingY");
    private int startRow = 0;
    private int startCol = 0;
    private String oldToolTip = "";

    public MatrixPaintPanel(MatrixGUIObject matrix, boolean showBorder) {
        if (showBorder) {
            this.setBorder(BorderFactory.createTitledBorder("Matrix Visualization"));
        }
        this.addComponentListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setPreferredSize(new Dimension(600, 400));
        this.setMatrix(matrix);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.registerKeyboardActions();
    }

    private void registerKeyboardActions() {
        for (JComponent c : new MatrixActions(this, this.matrix, null)) {
            if (!(c instanceof JMenuItem)) continue;
            this.registerKeyboardAction(((JMenuItem)c).getAction());
        }
    }

    private void registerKeyboardAction(Action a) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        this.renderer.setSize(this.getSize());
        GraphicsExecutor.scheduleUpdate(this);
    }

    public void componentShown(ComponentEvent e) {
    }

    public void tableChanged(TableModelEvent e) {
        GraphicsExecutor.scheduleUpdate(this);
    }

    public void mouseClicked(MouseEvent e) {
        if (this.matrix != null && e.getButton() == 3) {
            int newRow = this.getRowPos(e.getY());
            int newCol = this.getColPos(e.getX());
            newRow = newRow < 0 ? 0 : newRow;
            newCol = newCol < 0 ? 0 : newCol;
            newRow = newRow >= this.matrix.getRowCount() ? this.matrix.getRowCount() - 1 : newRow;
            newCol = newCol >= this.matrix.getColumnCount() ? this.matrix.getColumnCount() - 1 : newCol;
            MatrixPopupMenu popup = new MatrixPopupMenu(this, this.matrix, newRow, newCol);
            popup.show(this, e.getX(), e.getY());
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (this.matrix != null) {
            if (e.getButton() == 1) {
                this.startRow = this.getRowPos(e.getY());
                this.startCol = this.getColPos(e.getX());
                this.startRow = this.startRow < 0 ? 0 : this.startRow;
                this.startCol = this.startCol < 0 ? 0 : this.startCol;
                this.startRow = this.startRow >= this.matrix.getRowCount() ? this.matrix.getRowCount() - 1 : this.startRow;
                this.startCol = this.startCol >= this.matrix.getColumnCount() ? this.matrix.getColumnCount() - 1 : this.startCol;
                this.matrix.getRowSelectionModel().setValueIsAdjusting(true);
                this.matrix.getColumnSelectionModel().setValueIsAdjusting(true);
                this.matrix.getRowSelectionModel().setSelectionInterval(this.startRow, this.startRow);
                this.matrix.getColumnSelectionModel().setSelectionInterval(this.startCol, this.startCol);
            }
            this.repaint(100L);
        }
    }

    private int getRowPos(int y) {
        return (int)Math.floor((double)this.matrix.getRowCount() * (double)y / (double)this.getHeight());
    }

    private int getColPos(int x) {
        return (int)Math.floor((double)this.matrix.getColumnCount() * (double)x / (double)this.getWidth());
    }

    public void mouseReleased(MouseEvent e) {
        if (this.matrix != null && e.getButton() == 1) {
            int newRow = this.getRowPos(e.getY());
            int newCol = this.getColPos(e.getX());
            newRow = newRow < 0 ? 0 : newRow;
            newCol = newCol < 0 ? 0 : newCol;
            newRow = newRow >= this.matrix.getRowCount() ? this.matrix.getRowCount() - 1 : newRow;
            newCol = newCol >= this.matrix.getColumnCount() ? this.matrix.getColumnCount() - 1 : newCol;
            this.matrix.getRowSelectionModel().setValueIsAdjusting(false);
            this.matrix.getColumnSelectionModel().setValueIsAdjusting(false);
            this.matrix.getRowSelectionModel().setSelectionInterval(this.startRow, newRow);
            this.matrix.getColumnSelectionModel().setSelectionInterval(this.startCol, newCol);
            this.repaint(100L);
        }
    }

    public MatrixGUIObject getMatrix() {
        return this.matrix;
    }

    public String getToolTipText(MouseEvent e) {
        if (this.matrix != null && Coordinates.product(this.matrix.getSize()) != 0L) {
            int r = this.getRowPos(e.getY());
            int c = this.getColPos(e.getX());
            r = r < 0 ? 0 : r;
            c = c < 0 ? 0 : c;
            String toolTip = TooltipUtil.getTooltip(this.matrix, r = r >= this.matrix.getRowCount() ? this.matrix.getRowCount() - 1 : r, c = c >= this.matrix.getColumnCount() ? this.matrix.getColumnCount() - 1 : c);
            if (toolTip.length() == this.oldToolTip.length()) {
                toolTip = String.valueOf(toolTip) + "\n";
            }
            this.oldToolTip = toolTip;
            return toolTip;
        }
        return null;
    }

    public void setMatrix(MatrixGUIObject m) {
        if (this.matrix != null) {
            this.matrix.removeTableModelListener(this);
            this.matrix.getRowSelectionModel().removeListSelectionListener(this);
            this.matrix.getColumnSelectionModel().removeListSelectionListener(this);
        }
        if (m != null) {
            this.matrix = m;
            this.renderer.setMatrix(m);
        } else {
            this.matrix = null;
        }
        if (this.matrix != null) {
            this.matrix.addTableModelListener(this);
            this.matrix.getRowSelectionModel().addListSelectionListener(this);
            this.matrix.getColumnSelectionModel().addListSelectionListener(this);
        }
        GraphicsExecutor.scheduleUpdate(this);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.matrix != null) {
            this.matrix.removeTableModelListener(this);
        }
        ToolTipManager.sharedInstance().unregisterComponent(this);
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        if (this.matrix != null && this.bufferedImage != null) {
            g2d.drawImage(this.bufferedImage, 0, 0, this.getWidth(), this.getHeight(), null);
            if (!this.matrix.getRowSelectionModel().isSelectionEmpty()) {
                g2d.setColor(Color.BLUE);
                int x1 = this.matrix.getColumnSelectionModel().getMinSelectionIndex();
                int x2 = this.matrix.getColumnSelectionModel().getMaxSelectionIndex();
                int y1 = this.matrix.getRowSelectionModel().getMinSelectionIndex();
                int y2 = this.matrix.getRowSelectionModel().getMaxSelectionIndex();
                double sx = (double)(this.getWidth() - PADDINGX - PADDINGX) / (double)this.matrix.getColumnCount();
                double sy = (double)(this.getHeight() - PADDINGY - PADDINGY) / (double)this.matrix.getRowCount();
                g2d.setStroke(new BasicStroke(2.0f));
                g2d.drawRect((int)Math.floor((double)PADDINGX + (double)x1 * sx), (int)Math.floor((double)PADDINGY + (double)y1 * sy), (int)Math.ceil(sx + (double)(x2 - x1) * sx), (int)Math.ceil(sy + (double)(y2 - y1) * sy));
                g2d.setComposite(AlphaComposite.getInstance(10, 0.3f));
                g2d.fillRect((int)Math.floor((double)PADDINGX + (double)x1 * sx), (int)Math.floor((double)PADDINGY + (double)y1 * sy), (int)Math.ceil(sx + (double)(x2 - x1) * sx), (int)Math.ceil(sy + (double)(y2 - y1) * sy));
            }
        } else {
            g2d.setColor(Color.GRAY);
            g2d.drawLine(0, 0, this.getWidth(), this.getHeight());
            g2d.drawLine(0, this.getHeight(), this.getWidth(), 0);
        }
    }

    public void repaintUI() {
        if (this.matrix != null && this.getWidth() > 0 && this.getHeight() > 0) {
            BufferedImage tempBufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 1);
            this.renderer.setSize(this.getWidth(), this.getHeight());
            Graphics2D g2d = (Graphics2D)tempBufferedImage.getGraphics();
            this.renderer.paintComponent(g2d);
            g2d.dispose();
            this.bufferedImage = tempBufferedImage;
        }
    }

    public void exportToPDF(File file) {
        ExportPDF.save(file, this);
    }

    public void exportToJPEG(File file) {
        ExportJPEG.save(file, (Component)this);
    }

    public void exportToPNG(File file) {
        ExportPNG.save(file, (Component)this);
    }

    public void mouseDragged(MouseEvent e) {
        if (this.matrix != null && this.matrix.getRowSelectionModel().getValueIsAdjusting()) {
            int newRow = this.getRowPos(e.getY());
            int newCol = this.getColPos(e.getX());
            newRow = newRow < 0 ? 0 : newRow;
            newCol = newCol < 0 ? 0 : newCol;
            newRow = newRow >= this.matrix.getRowCount() ? this.matrix.getRowCount() - 1 : newRow;
            newCol = newCol >= this.matrix.getColumnCount() ? this.matrix.getColumnCount() - 1 : newCol;
            this.matrix.getRowSelectionModel().setSelectionInterval(this.startRow, newRow);
            this.matrix.getColumnSelectionModel().setSelectionInterval(this.startCol, newCol);
            this.repaint(100L);
        }
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void valueChanged(ListSelectionEvent e) {
        this.repaint(100L);
    }
}

