/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.gui.menu;

import java.awt.Color;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.Calculation;
import org.ujmp.gui.MatrixGUIObject;
import org.ujmp.gui.actions.MatrixActions;

public class MatrixPopupMenu
extends JPopupMenu {
    private static final long serialVersionUID = -5501347047922058729L;

    public MatrixPopupMenu(JComponent c, MatrixGUIObject matrix, int row, int column) {
        JLabel label = new JLabel();
        label.setForeground(new Color(0, 0, 255));
        MatrixActions actions = null;
        if (matrix.getRowSelectionModel().isSelectedIndex(row) && matrix.getColumnSelectionModel().isSelectedIndex(column)) {
            int startX = matrix.getColumnSelectionModel().getMinSelectionIndex();
            int endX = matrix.getColumnSelectionModel().getMaxSelectionIndex();
            int startY = matrix.getRowSelectionModel().getMinSelectionIndex();
            int endY = matrix.getRowSelectionModel().getMaxSelectionIndex();
            Matrix subMatrix = matrix.getMatrix().subMatrix(Calculation.Ret.LINK, startY, startX, endY, endX);
            actions = new MatrixActions(c, (MatrixGUIObject)subMatrix.getGUIObject(), null);
            label.setText(" Selection " + Coordinates.toString(subMatrix.getSize()).replaceAll(",", "x"));
        } else {
            actions = new MatrixActions(c, matrix, null);
            label.setText(" Matrix [" + Coordinates.toString(matrix.getSize()).replaceAll(",", "x") + "]");
        }
        this.add(label);
        this.add(new JSeparator());
        for (JComponent jc : actions) {
            this.add(jc);
        }
    }
}

