/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.gui.clipboard;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.Serializable;
import org.ujmp.core.Matrix;
import org.ujmp.core.enums.FileFormat;
import org.ujmp.core.exceptions.MatrixException;

public class MatrixSelection
implements Transferable,
ClipboardOwner,
Serializable {
    private static final long serialVersionUID = -8462961141636462510L;
    public static final int STRING = 0;
    public static final int IMAGE = 1;
    public static final int MATRIX = 2;
    private static final DataFlavor[] flavors = new DataFlavor[]{DataFlavor.stringFlavor};
    private String stringData = null;

    public MatrixSelection(Matrix matrix) throws MatrixException, IOException {
        this.stringData = matrix.exportToString(FileFormat.CSV, new Object[0]);
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.equals(flavors[0])) {
            return this.stringData;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    public DataFlavor[] getTransferDataFlavors() {
        return (DataFlavor[])flavors.clone();
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        int i = 0;
        while (i < flavors.length) {
            if (flavor.equals(flavors[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }
}

