/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.gui.actions;

import java.io.File;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import org.ujmp.core.enums.FileFormat;
import org.ujmp.core.interfaces.GUIObject;
import org.ujmp.core.util.io.UJMPFileFilter;
import org.ujmp.gui.MatrixGUIObject;
import org.ujmp.gui.actions.ObjectAction;

public class SaveMatrixAction
extends ObjectAction {
    private static final long serialVersionUID = -212812956173346428L;

    public SaveMatrixAction(JComponent c, GUIObject o) {
        super(c, o);
        this.putValue("Name", "Save...");
        this.putValue("ShortDescription", "Save this Matrix");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, 128));
    }

    public Object call() {
        File file;
        block11: {
            int result;
            block10: {
                try {
                    file = null;
                    JFileChooser chooser = new JFileChooser();
                    FileFormat[] fileFormatArray = FileFormat.values();
                    int n = fileFormatArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        FileFormat f = fileFormatArray[n2];
                        chooser.addChoosableFileFilter(f.getFileFilter());
                        ++n2;
                    }
                    chooser.setFileFilter(FileFormat.CSV.getFileFilter());
                    chooser.setAcceptAllFileFilterUsed(false);
                    chooser.setDialogTitle("Save");
                    int returnVal = chooser.showSaveDialog(null);
                    if (returnVal == 0) {
                        file = chooser.getSelectedFile();
                        FileFilter filter = chooser.getFileFilter();
                        String suffix = ((UJMPFileFilter)filter).getSuffix()[0];
                        if (!file.getAbsolutePath().toLowerCase().endsWith(suffix)) {
                            file = new File(String.valueOf(file.getAbsolutePath()) + "." + suffix);
                        }
                    }
                    if (file != null) break block10;
                    return null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
            if (!file.exists() || (result = JOptionPane.showConfirmDialog(null, "File already exists. Overwrite?", "Warning", 0)) == 0) break block11;
            return null;
        }
        GUIObject o = this.getGUIObject();
        if (o instanceof MatrixGUIObject) {
            MatrixGUIObject m = (MatrixGUIObject)o;
            try {
                m.getMatrix().exportToFile(file, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

