/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.util.io;

import java.io.IOException;
import java.io.OutputStream;

public class RingBufferOutputStream
extends OutputStream {
    private int start = -1;
    private int end = -1;
    private final byte[] values;

    public RingBufferOutputStream() {
        this(10);
    }

    public RingBufferOutputStream(int maximumSize) {
        this.values = new byte[maximumSize];
    }

    public int maxSize() {
        return this.values.length;
    }

    public boolean add(byte a) {
        if (this.end >= 0) {
            ++this.end;
            if (this.end >= this.values.length) {
                this.end = 0;
            }
            if (this.end == this.start) {
                ++this.start;
            }
            if (this.start >= this.values.length) {
                this.start = 0;
            }
        } else {
            this.start = 0;
            this.end = 0;
        }
        this.values[this.end] = a;
        return true;
    }

    public int size() {
        if (this.end < 0) {
            return 0;
        }
        return this.end < this.start ? this.values.length : this.end - this.start + 1;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        int i = 0;
        while (i < this.size()) {
            s.append((char)this.get(i));
            ++i;
        }
        return s.toString();
    }

    public byte get(int index) {
        return this.values[(this.start + index) % this.values.length];
    }

    public byte set(int index, byte a) {
        byte old = this.values[(this.start + index) % this.values.length];
        this.values[(this.start + index) % this.values.length] = a;
        return old;
    }

    public void clear() {
        this.start = -1;
        this.end = -1;
    }

    public void add(int index, char element) {
        new Exception("not implemented").printStackTrace();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public void write(int b) throws IOException {
        this.add((byte)b);
    }
}

