/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.util.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import org.ujmp.core.util.UJMPSettings;
import org.ujmp.core.util.concurrent.UJMPThreadPoolExecutor;

public abstract class PFor {
    private final Object[] objects;

    public PFor(int threads, int first, int last, Object ... objects) {
        this.objects = objects;
        if (threads < 2) {
            int i = first;
            while (i <= last) {
                this.step(i);
                ++i;
            }
        } else {
            ThreadPoolExecutor es = UJMPThreadPoolExecutor.getInstance(threads);
            Future[] list = new Future[threads];
            double stepsize = (double)(last + 1 - first) / (double)threads;
            int i = 0;
            while (i < threads) {
                int starti = (int)Math.ceil((double)first + (double)i * stepsize);
                int endi = (int)Math.ceil((double)first + (double)(i + 1) * stepsize);
                list[i] = es.submit(new StepCallable(starti, endi));
                ++i;
            }
            Future[] futureArray = list;
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                Future f = futureArray[n2];
                try {
                    f.get();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++n2;
            }
        }
    }

    public PFor(int first, int last, Object ... objects) {
        this(UJMPSettings.getNumberOfThreads(), first, last, objects);
    }

    public abstract void step(int var1);

    public final Object getObject(int i) {
        return this.objects[i];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class StepCallable
    implements Callable<Object> {
        private final int first;
        private final int last;

        public StepCallable(int first, int last) {
            this.first = first;
            this.last = last;
        }

        @Override
        public final Void call() throws Exception {
            try {
                int i = this.first;
                while (i < this.last) {
                    PFor.this.step(i);
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }
    }
}

