/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.ujmp.core.Matrix;
import org.ujmp.core.enums.ValueType;

public class ExportMatrixSER {
    public static final void toFile(File file, Matrix m, Object ... parameters) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        ExportMatrixSER.toStream(out, m, parameters);
        out.close();
    }

    public static final void toStream(OutputStream stream, Matrix m, Object ... parameters) throws IOException {
        ObjectOutputStream s = new ObjectOutputStream(new BufferedOutputStream(stream));
        long[] size = m.getSize();
        int sizeLength = size.length;
        ValueType valueType = m.getValueType();
        s.writeObject((Object)valueType);
        s.writeBoolean(m.isSparse());
        s.writeInt(sizeLength);
        int i = 0;
        while (i < sizeLength) {
            s.writeLong(size[i]);
            ++i;
        }
        for (long[] c : m.availableCoordinates()) {
            s.writeBoolean(true);
            int i2 = 0;
            while (i2 < sizeLength) {
                s.writeLong(c[i2]);
                ++i2;
            }
            switch (valueType) {
                case DOUBLE: {
                    s.writeDouble(m.getAsDouble(c));
                    break;
                }
                case INT: {
                    s.writeInt(m.getAsInt(c));
                    break;
                }
                default: {
                    s.writeObject(m.getAsObject(c));
                }
            }
        }
        s.writeBoolean(false);
        s.close();
    }
}

