/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.io;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.ujmp.core.Matrix;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.util.StringUtil;
import org.ujmp.core.util.io.IntelligentFileWriter;

public class ExportMatrixHTML {
    public static void toFile(File file, Matrix matrix, Object ... parameters) throws IOException, MatrixException {
        IntelligentFileWriter writer = new IntelligentFileWriter(file);
        ExportMatrixHTML.toWriter(writer, matrix, parameters);
        writer.close();
    }

    public static void toStream(OutputStream outputStream, Matrix matrix, Object ... parameters) throws IOException, MatrixException {
        OutputStreamWriter writer = new OutputStreamWriter(outputStream);
        ExportMatrixHTML.toWriter(writer, matrix, parameters);
        writer.close();
    }

    public static void toWriter(Writer out, Matrix m, Object ... parameters) throws IOException, MatrixException {
        String EOL = System.getProperty("line.separator");
        long rowCount = m.getRowCount();
        long colCount = m.getColumnCount();
        out.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" ");
        out.append("\"http://www.w3.org/TR/html4/strict.dtd\">" + EOL);
        out.append("<body>" + EOL);
        out.append("<html>" + EOL + EOL);
        out.append("<table>" + EOL);
        int row = 0;
        while ((long)row < rowCount) {
            out.append("<tr>" + EOL);
            int col = 0;
            while ((long)col < colCount) {
                out.append("<td>");
                out.append(StringUtil.convert(m.getAsObject(row, col)));
                out.append("</td>" + EOL);
                ++col;
            }
            out.append("</tr>" + EOL);
            ++row;
        }
        out.append("</table>" + EOL);
        out.append("</body>" + EOL);
        out.append("</html>" + EOL);
    }
}

