/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.genericmatrix.impl;

import org.ujmp.core.Matrix;
import org.ujmp.core.enums.ValueType;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.genericmatrix.stub.AbstractDenseGenericMatrix2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDenseGenericMatrix2D<A>
extends AbstractDenseGenericMatrix2D<A> {
    private static final long serialVersionUID = 3132491298449205914L;
    private Object[][] values = null;

    public DefaultDenseGenericMatrix2D(Matrix m) throws MatrixException {
        this.values = new Object[(int)m.getRowCount()][(int)m.getColumnCount()];
        for (long[] c : m.allCoordinates()) {
            this.setAsObject(m.getAsObject(c), c);
        }
    }

    public DefaultDenseGenericMatrix2D(A[][] values) throws MatrixException {
        this.values = values;
    }

    public DefaultDenseGenericMatrix2D(long ... size) {
        this.values = new Object[(int)size[0]][(int)size[1]];
    }

    @Override
    public long[] getSize() {
        return new long[]{this.values.length, this.values.length == 0 ? 0 : this.values[0].length};
    }

    @Override
    public long getRowCount() {
        return this.values.length;
    }

    @Override
    public long getColumnCount() {
        return this.values.length == 0 ? 0 : this.values[0].length;
    }

    @Override
    public A getObject(long row, long column) {
        return (A)this.values[(int)row][(int)column];
    }

    @Override
    public void setObject(Object value, long row, long column) {
        this.values[(int)row][(int)column] = value;
    }

    @Override
    public A getObject(int row, int column) {
        return (A)this.values[row][column];
    }

    @Override
    public void setObject(A value, int row, int column) {
        this.values[row][column] = value;
    }

    @Override
    public ValueType getValueType() {
        return ValueType.OBJECT;
    }
}

