/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.impl;

import java.io.Serializable;
import java.util.Arrays;
import org.ujmp.core.doublematrix.impl.BlockDenseDoubleMatrix2D;

public final class BlockMatrixLayout
implements Serializable {
    private static final long serialVersionUID = 2726685238884065594L;
    protected final int blockArea;
    public final int blockStripe;
    public final int columns;
    public final BlockOrder blockOrder;
    final int numberOfBlocks;
    private final boolean rowMajor;
    public final int rows;
    private final int sqbColThreshold;
    private final int sqbRowThreshold;

    BlockMatrixLayout(int rows, int columns, int blockStripe, BlockOrder blockOrder) {
        this.blockStripe = blockStripe;
        if (rows <= 0 || columns <= 0 || blockStripe <= 0) {
            throw new IllegalArgumentException(String.format("One or more invalid values: rows=%s, columns=%s, blockSize=%s", rows, columns, blockStripe));
        }
        this.blockArea = blockStripe * blockStripe;
        this.rows = rows;
        this.columns = columns;
        this.sqbColThreshold = columns / blockStripe * blockStripe;
        this.sqbRowThreshold = rows / blockStripe * blockStripe;
        this.blockOrder = blockOrder;
        this.rowMajor = blockOrder == BlockOrder.ROWMAJOR;
        this.numberOfBlocks = (rows / blockStripe + (rows % blockStripe > 0 ? 1 : 0)) * (columns / blockStripe + (columns % blockStripe > 0 ? 1 : 0));
    }

    final double[] getBlock(BlockDenseDoubleMatrix2D matrix, int row, int column) {
        return matrix.getBlockData(row, column);
    }

    final int getBlockIndexByColumn(int lrow, int lcol, int numRows, int numCols) {
        return this.rowMajor ? lcol * numRows + lrow : lrow * numCols + lcol;
    }

    final int getBlockIndexByRow(int lrow, int lcol, int numRows, int numCols) {
        return this.rowMajor ? lrow * numCols + lcol : lcol * numRows + lrow;
    }

    final int getBlockNumber(int row, int col) {
        return col / this.blockStripe + row / this.blockStripe * (this.columns / this.blockStripe + (this.columns % this.blockStripe > 0 ? 1 : 0));
    }

    final int getIndexInBlock(int row, int col) {
        int lrows = this.getRowsInBlock(row);
        int lcols = this.getColumnsInBlock(col);
        return this.getBlockIndexByRow(row % this.blockStripe, col % this.blockStripe, lrows, lcols);
    }

    final int getBlockSize(int row, int col) {
        int lrows = this.getRowsInBlock(row);
        int lcols = this.getColumnsInBlock(col);
        return lrows * lcols;
    }

    final double[] toColMajorBlock(BlockDenseDoubleMatrix2D matrix, int rowStart, int colStart) {
        double[] block = this.getBlock(matrix, rowStart, colStart);
        if (!this.rowMajor) {
            return block;
        }
        return this.toColMajorBlock(block, rowStart, colStart);
    }

    final double[] toColMajorBlock(double[] block, int rowStart, int colStart) {
        double[] targetBlock = new double[block.length];
        int lrows = this.getRowsInBlock(rowStart);
        int lcols = this.getColumnsInBlock(colStart);
        int i = 0;
        while (i < lcols) {
            int ilrows = i * lrows;
            int j = 0;
            while (j < lrows) {
                targetBlock[ilrows + j] = block[j * lcols + i];
                ++j;
            }
            ++i;
        }
        return targetBlock;
    }

    int getColumnsInBlock(int col) {
        return col >= this.sqbColThreshold ? this.columns - this.sqbColThreshold : this.blockStripe;
    }

    int getRowsInBlock(int row) {
        return row >= this.sqbRowThreshold ? this.rows - this.sqbRowThreshold : this.blockStripe;
    }

    final double[] toRowMajorBlock(BlockDenseDoubleMatrix2D matrix, int rowStart, int colStart) {
        double[] block = this.getBlock(matrix, rowStart, colStart);
        if (this.rowMajor) {
            return block;
        }
        return this.toRowMajorBlock(block, rowStart, colStart);
    }

    final double[] toRowMajorBlock(double[] block, int rowStart, int colStart) {
        double[] targetBlock = new double[block.length];
        int lrows = this.getRowsInBlock(rowStart);
        int lcols = this.getColumnsInBlock(colStart);
        int i = 0;
        while (i < lrows) {
            int ilcols = i * lcols;
            int j = 0;
            while (j < lcols) {
                targetBlock[ilcols + j] = block[j * lrows + i];
                ++j;
            }
            ++i;
        }
        return targetBlock;
    }

    public String toString() {
        int[] rowLayout = new int[this.blockStripe];
        StringBuilder b = new StringBuilder(this.blockArea * 4 + 40);
        String msg = "\n(rows=%s, columns=%s, blockSize=%s):\n";
        b.append(String.format(msg, this.rows, this.columns, this.blockStripe));
        int rows = this.blockStripe;
        int cols = this.blockStripe;
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < cols) {
                rowLayout[j] = this.getBlockIndexByRow(i, j, rows, cols);
                ++j;
            }
            b.append(Arrays.toString(rowLayout)).append("\n");
            ++i;
        }
        return b.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BlockOrder {
        ROWMAJOR,
        COLUMNMAJOR;


        public BlockOrder transpose() {
            return this == ROWMAJOR ? COLUMNMAJOR : ROWMAJOR;
        }
    }
}

