/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation.general.statistical;

import org.ujmp.core.Matrix;
import org.ujmp.core.annotation.Annotation;
import org.ujmp.core.annotation.DefaultAnnotation;
import org.ujmp.core.doublematrix.calculation.AbstractDoubleCalculation;
import org.ujmp.core.doublematrix.calculation.general.statistical.Var;
import org.ujmp.core.exceptions.MatrixException;

public class Std
extends AbstractDoubleCalculation {
    private static final long serialVersionUID = 6318655294298955306L;
    private Matrix variance = null;
    private boolean ignoreNaN = false;

    public Std(int dimension, boolean ignoreNaN, Matrix matrix) {
        super(dimension, matrix);
        this.ignoreNaN = ignoreNaN;
        Annotation aold = matrix.getAnnotation();
        if (aold != null) {
            DefaultAnnotation a = new DefaultAnnotation(this.getSize());
            a.setMatrixAnnotation(aold.getMatrixAnnotation());
            if (dimension == 0) {
                a.setDimensionMatrix(0, aold.getDimensionMatrix(0));
            } else if (dimension == 1) {
                a.setDimensionMatrix(1, aold.getDimensionMatrix(1));
            }
            this.setAnnotation(a);
        }
    }

    public double getDouble(long ... coordinates) throws MatrixException {
        if (this.variance == null) {
            this.variance = new Var(this.getDimension(), this.ignoreNaN, this.getSource()).calcNew();
        }
        return Math.sqrt(this.variance.getAsDouble(coordinates));
    }

    public long[] getSize() {
        switch (this.getDimension()) {
            case 0: {
                return new long[]{1L, this.getSource().getSize()[1]};
            }
            case 1: {
                return new long[]{this.getSource().getSize()[0], 1L};
            }
            case 0x7FFFFFFF: {
                return new long[]{1L, 1L};
            }
        }
        return null;
    }
}

