/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation.general.missingvalues;

import java.lang.reflect.Constructor;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.Calculation;
import org.ujmp.core.doublematrix.calculation.AbstractDoubleCalculation;
import org.ujmp.core.doublematrix.calculation.DoubleCalculation;
import org.ujmp.core.doublematrix.calculation.general.missingvalues.Impute;
import org.ujmp.core.exceptions.MatrixException;

public class ImputeLS
extends AbstractDoubleCalculation {
    private static final long serialVersionUID = 6803633047911888483L;
    private Matrix imp = null;
    private Impute.ImputationMethod method = null;

    public ImputeLS(Matrix matrix, Impute.ImputationMethod method) {
        super(matrix);
        this.method = method;
    }

    public static boolean isAvailable() {
        try {
            Class.forName("Impute");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }

    public double getDouble(long ... coordinates) throws MatrixException {
        if (this.imp == null) {
            try {
                Calculation calc = null;
                try {
                    if (calc == null) {
                        Class<?> c = Class.forName("org.ujmp.lsimpute.LSImpute");
                        Constructor<?> con = c.getConstructor(Matrix.class, Impute.ImputationMethod.class);
                        calc = (DoubleCalculation)con.newInstance(new Object[]{this.getSource(), this.method});
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (calc == null) {
                    throw new MatrixException("could not find LSimpute.jar in your classpath");
                }
                this.imp = calc.calcNew();
            }
            catch (Exception e) {
                throw new MatrixException(e);
            }
        }
        return this.imp.getAsDouble(coordinates);
    }
}

