/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation;

import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.MatrixFactory;
import org.ujmp.core.calculation.AbstractCalculation;
import org.ujmp.core.doublematrix.DoubleMatrix;
import org.ujmp.core.doublematrix.calculation.DoubleCalculation;
import org.ujmp.core.doublematrix.impl.DoubleCalculationMatrix;
import org.ujmp.core.enums.ValueType;
import org.ujmp.core.exceptions.MatrixException;

public abstract class AbstractDoubleCalculation
extends AbstractCalculation
implements DoubleCalculation {
    private static final long serialVersionUID = -7509806754731040687L;

    public AbstractDoubleCalculation(Matrix ... sources) {
        super(sources);
    }

    public AbstractDoubleCalculation(int dimension, Matrix ... sources) {
        super(dimension, sources);
    }

    public DoubleMatrix calcLink() throws MatrixException {
        return new DoubleCalculationMatrix(this);
    }

    public DoubleMatrix calcNew() throws MatrixException {
        DoubleMatrix result = (DoubleMatrix)MatrixFactory.zeros(ValueType.DOUBLE, this.getSize());
        for (long[] c : result.allCoordinates()) {
            result.setAsDouble(this.getDouble(c), c);
        }
        if (this.getAnnotation() != null) {
            result.setAnnotation(this.getAnnotation().clone());
        }
        return result;
    }

    public Matrix calcOrig() throws MatrixException {
        if (!Coordinates.equals(this.getSource().getSize(), this.getSize())) {
            throw new MatrixException("Cannot change Matrix size. Use calc(Ret.NEW) or calc(Ret.LINK) instead.");
        }
        for (long[] c : this.getSource().allCoordinates()) {
            this.getSource().setAsDouble(this.getDouble(c), c);
        }
        this.getSource().notifyGUIObject();
        return this.getSource();
    }

    public void setDouble(double value, long ... coordinates) throws MatrixException {
    }

    public final ValueType getValueType() {
        return ValueType.DOUBLE;
    }
}

