/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.calculation;

import java.math.BigDecimal;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.PlusScalar;
import org.ujmp.core.calculation.PlusScalarCalculation;
import org.ujmp.core.doublematrix.DenseDoubleMatrix2D;
import org.ujmp.core.matrix.DenseMatrix2D;
import org.ujmp.core.util.MathUtil;
import org.ujmp.core.util.VerifyUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PlusScalarDenseMatrix2D
implements PlusScalarCalculation<DenseMatrix2D, DenseMatrix2D> {
    PlusScalarDenseMatrix2D() {
    }

    @Override
    public final void calc(DenseMatrix2D source, BigDecimal value, DenseMatrix2D target) {
        if (source instanceof DenseDoubleMatrix2D && target instanceof DenseDoubleMatrix2D) {
            PlusScalar.DENSEDOUBLEMATRIX2D.calc((DenseDoubleMatrix2D)source, value, (DenseDoubleMatrix2D)target);
        } else {
            VerifyUtil.assertSameSize((Matrix)source, (Matrix)target);
            int r = (int)source.getRowCount();
            while (--r != -1) {
                int c = (int)source.getColumnCount();
                while (--c != -1) {
                    BigDecimal svalue = source.getAsBigDecimal(r, c);
                    BigDecimal result = MathUtil.plus(svalue, value);
                    target.setAsBigDecimal(result, r, c);
                }
            }
        }
    }

    @Override
    public final void calc(DenseMatrix2D source, double value, DenseMatrix2D target) {
        if (source instanceof DenseDoubleMatrix2D && target instanceof DenseDoubleMatrix2D) {
            PlusScalar.DENSEDOUBLEMATRIX2D.calc((DenseDoubleMatrix2D)source, value, (DenseDoubleMatrix2D)target);
        } else {
            this.calc(source, new BigDecimal(value, MathUtil.getDefaultMathContext()), target);
        }
    }
}

