/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.calculation;

import java.math.BigDecimal;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.DivideScalar;
import org.ujmp.core.calculation.DivideScalarCalculation;
import org.ujmp.core.matrix.DenseMatrix;
import org.ujmp.core.matrix.SparseMatrix;
import org.ujmp.core.util.MathUtil;
import org.ujmp.core.util.VerifyUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DivideScalarMatrix
implements DivideScalarCalculation<Matrix, Matrix> {
    DivideScalarMatrix() {
    }

    @Override
    public final void calc(Matrix source, BigDecimal divisor, Matrix target) {
        if (source instanceof DenseMatrix && target instanceof DenseMatrix) {
            DivideScalar.DENSEMATRIX.calc((DenseMatrix)source, divisor, (DenseMatrix)target);
        } else if (source instanceof SparseMatrix && target instanceof SparseMatrix) {
            DivideScalar.SPARSEMATRIX.calc((SparseMatrix)source, divisor, (SparseMatrix)target);
        } else {
            VerifyUtil.assertSameSize(source, target);
            for (long[] c : source.allCoordinates()) {
                BigDecimal value = source.getAsBigDecimal(c);
                BigDecimal result = MathUtil.divide(value, divisor);
                target.setAsBigDecimal(result, c);
            }
        }
    }

    @Override
    public final void calc(Matrix source, double divisor, Matrix target) {
        if (source instanceof DenseMatrix && target instanceof DenseMatrix) {
            DivideScalar.DENSEMATRIX.calc((DenseMatrix)source, divisor, (DenseMatrix)target);
        } else if (source instanceof SparseMatrix && target instanceof SparseMatrix) {
            DivideScalar.SPARSEMATRIX.calc((SparseMatrix)source, divisor, (SparseMatrix)target);
        } else {
            this.calc(source, new BigDecimal(divisor, MathUtil.getDefaultMathContext()), target);
        }
    }
}

