/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.bytematrix.calculation;

import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.MatrixFactory;
import org.ujmp.core.bytematrix.ByteMatrix;
import org.ujmp.core.bytematrix.calculation.ByteCalculation;
import org.ujmp.core.bytematrix.impl.ByteCalculationMatrix;
import org.ujmp.core.calculation.AbstractCalculation;
import org.ujmp.core.enums.ValueType;
import org.ujmp.core.exceptions.MatrixException;

public abstract class AbstractByteCalculation
extends AbstractCalculation
implements ByteCalculation {
    private static final long serialVersionUID = -6732603786169729218L;

    public AbstractByteCalculation(Matrix ... sources) {
        super(sources);
    }

    public AbstractByteCalculation(int dimension, Matrix ... sources) {
        super(dimension, sources);
    }

    public final ByteMatrix calcNew() throws MatrixException {
        ByteMatrix result = (ByteMatrix)MatrixFactory.zeros(ValueType.BYTE, this.getSize());
        for (long[] c : result.allCoordinates()) {
            result.setByte(this.getByte(c), c);
        }
        if (this.getAnnotation() != null) {
            result.setAnnotation(this.getAnnotation().clone());
        }
        return result;
    }

    public final ByteMatrix calcLink() throws MatrixException {
        return new ByteCalculationMatrix(this);
    }

    public final Matrix calcOrig() throws MatrixException {
        if (!Coordinates.equals(this.getSource().getSize(), this.getSize())) {
            throw new MatrixException("Cannot change Matrix size. Use calc(Ret.NEW) or calc(Ret.LINK) instead.");
        }
        for (long[] c : this.getSource().allCoordinates()) {
            this.getSource().setAsByte(this.getByte(c), c);
        }
        this.getSource().notifyGUIObject();
        return this.getSource();
    }

    public void setByte(byte value, long ... coordinates) throws MatrixException {
    }

    public final ValueType getValueType() {
        return ValueType.BYTE;
    }
}

