/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.benchmark;

import java.math.BigDecimal;
import java.net.Inet4Address;
import java.util.Random;
import org.ujmp.core.Matrix;
import org.ujmp.core.benchmark.BenchmarkConfig;
import org.ujmp.core.doublematrix.DenseDoubleMatrix2D;
import org.ujmp.core.doublematrix.DoubleMatrix2D;
import org.ujmp.core.doublematrix.impl.DefaultDenseDoubleMatrix2D;
import org.ujmp.core.util.GCUtil;
import org.ujmp.core.util.MathUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BenchmarkUtil {
    public static String getResultDir(BenchmarkConfig config) {
        String name = config.getName();
        if (name == null) {
            return "results/" + BenchmarkUtil.getHostName() + "/" + System.getProperty("os.name") + "/Java" + System.getProperty("java.version") + "/";
        }
        return "results/" + name + "/";
    }

    public static String getHostName() {
        try {
            return Inet4Address.getLocalHost().getHostName();
        }
        catch (Exception e) {
            return "localhost";
        }
    }

    public static void rand(long benchmarkSeed, int run, int id, DoubleMatrix2D matrix) {
        Random random = new Random(benchmarkSeed + (long)((run + 2) * 31 * 31) + (long)((id + 1) * 31));
        int rows = (int)matrix.getRowCount();
        int cols = (int)matrix.getColumnCount();
        int r = 0;
        while (r < rows) {
            int c = 0;
            while (c < cols) {
                matrix.setDouble(random.nextDouble() - 0.5, r, c);
                ++c;
            }
            ++r;
        }
    }

    public static void randSymm(long benchmarkSeed, int run, int id, DoubleMatrix2D matrix) {
        Random random = new Random(benchmarkSeed + (long)((run + 2) * 31 * 31) + (long)((id + 1) * 31));
        int rows = (int)matrix.getRowCount();
        int cols = (int)matrix.getColumnCount();
        int r = 0;
        while (r < rows) {
            int c = 0;
            while (c < cols && c <= r) {
                double f = random.nextDouble() - 0.5;
                matrix.setDouble(f, r, c);
                matrix.setDouble(f, c, r);
                ++c;
            }
            ++r;
        }
    }

    public static void randPositiveDefinite(long benchmarkSeed, int run, int id, Matrix matrix) {
        Random random = new Random(benchmarkSeed + (long)((run + 2) * 31 * 31) + (long)((id + 1) * 31));
        DefaultDenseDoubleMatrix2D temp = new DefaultDenseDoubleMatrix2D(matrix.getSize());
        int rows = (int)temp.getRowCount();
        int cols = (int)temp.getColumnCount();
        int r = 0;
        while (r < rows) {
            int c = 0;
            while (c < cols) {
                temp.setDouble(random.nextDouble(), r, c);
                ++c;
            }
            ++r;
        }
        DenseDoubleMatrix2D result = (DenseDoubleMatrix2D)temp.mtimes(temp.transpose());
        int r2 = 0;
        while (r2 < rows) {
            int c = 0;
            while (c < cols) {
                matrix.setAsDouble(result.getDouble(r2, c), r2, c);
                ++c;
            }
            ++r2;
        }
    }

    public static DoubleMatrix2D createMatrix(Class<? extends Matrix> matrixClass, long ... size) {
        try {
            return (DoubleMatrix2D)matrixClass.getConstructor(long[].class).newInstance(new Object[]{size});
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static DoubleMatrix2D createMatrix(Class<? extends Matrix> matrixClass, Matrix source) {
        try {
            return (DoubleMatrix2D)matrixClass.getConstructor(Matrix.class).newInstance(source);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static double difference(Matrix m1, Matrix m2) {
        Matrix d = m1.minus(m2);
        return d.normF();
    }

    public static BigDecimal normF(Matrix m) {
        long rows = m.getRowCount();
        long cols = m.getColumnCount();
        BigDecimal result = BigDecimal.ZERO;
        long ro = 0L;
        while (ro < rows) {
            long c = 0L;
            while (c < cols) {
                BigDecimal b = m.getAsBigDecimal(ro, c);
                BigDecimal temp = BigDecimal.ZERO;
                if (MathUtil.isGreater(result.abs(), b.abs())) {
                    temp = MathUtil.divide(b, result);
                    temp = MathUtil.times(result.abs(), MathUtil.sqrt(MathUtil.plus(BigDecimal.ONE, MathUtil.times(temp, temp))));
                } else if (!MathUtil.isEqual(BigDecimal.ZERO, b)) {
                    temp = MathUtil.divide(result, b);
                    temp = MathUtil.times(b.abs(), MathUtil.sqrt(MathUtil.plus(BigDecimal.ONE, MathUtil.times(temp, temp))));
                } else {
                    temp = BigDecimal.ZERO;
                }
                result = temp;
                ++c;
            }
            ++ro;
        }
        return result;
    }

    public static void purgeMemory(BenchmarkConfig config) {
        if (config.isPurgeMemory()) {
            GCUtil.purgeMemory();
        } else if (config.isGCMemory()) {
            GCUtil.gc();
        }
    }
}

