/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.util.Properties;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import weka.core.Utils;

public class LookAndFeel {
    public static String PROPERTY_FILE = "weka/gui/LookAndFeel.props";
    protected static Properties LOOKANDFEEL_PROPERTIES;

    public static boolean setLookAndFeel(String string) {
        boolean bl;
        try {
            UIManager.setLookAndFeel(string);
            bl = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = false;
        }
        return bl;
    }

    public static boolean setLookAndFeel() {
        String string = LOOKANDFEEL_PROPERTIES.getProperty("Theme", "");
        if (string.equals("")) {
            if (System.getProperty("os.name").equalsIgnoreCase("linux")) {
                return true;
            }
            string = LookAndFeel.getSystemLookAndFeel();
        }
        return LookAndFeel.setLookAndFeel(string);
    }

    public static String getSystemLookAndFeel() {
        return UIManager.getSystemLookAndFeelClassName();
    }

    public static String[] getInstalledLookAndFeels() {
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        String[] stringArray = new String[lookAndFeelInfoArray.length];
        for (int i = 0; i < lookAndFeelInfoArray.length; ++i) {
            stringArray[i] = lookAndFeelInfoArray[i].getClassName();
        }
        return stringArray;
    }

    public static void main(String[] stringArray) {
        System.out.println("\nInstalled Look and Feel themes:");
        String[] stringArray2 = LookAndFeel.getInstalledLookAndFeels();
        for (int i = 0; i < stringArray2.length; ++i) {
            System.out.println(i + 1 + ". " + stringArray2[i]);
        }
        System.out.println("\nNote: a theme can be set in '" + PROPERTY_FILE + "'.");
    }

    static {
        try {
            LOOKANDFEEL_PROPERTIES = Utils.readProperties(PROPERTY_FILE);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "LookAndFeel: Could not read a LookAndFeel configuration file.\nAn example file is included in the Weka distribution.\nThis file should be named \"" + PROPERTY_FILE + "\"  and\n" + "should be placed either in your user home (which is set\n" + "to \"" + System.getProperties().getProperty("user.home") + "\")\n" + "or the directory that java was started from\n", "LookAndFeel", 0);
        }
    }
}

