/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.alignment;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.Symbol;

public class SubstitutionMatrix {
    protected Map rowSymbols;
    protected Map colSymbols;
    protected int[][] matrix;
    protected int min;
    protected int max;
    protected FiniteAlphabet alphabet;
    protected String description;
    protected String name;

    public SubstitutionMatrix(FiniteAlphabet alpha, File matrixFile) throws IOException, BioException {
        this.alphabet = alpha;
        this.description = "";
        this.name = matrixFile.getName();
        this.rowSymbols = new HashMap();
        this.colSymbols = new HashMap();
        String matString = "";
        BufferedReader br = new BufferedReader(new FileReader(matrixFile));
        while (br.ready()) {
            matString = matString + br.readLine() + "\n";
        }
        this.matrix = this.parseMatrix(matString);
    }

    public SubstitutionMatrix(FiniteAlphabet alpha, String matrixString, String name) throws BioException {
        this.alphabet = alpha;
        this.description = "";
        this.name = name;
        this.rowSymbols = new HashMap();
        this.colSymbols = new HashMap();
        this.matrix = this.parseMatrix(matrixString);
    }

    public SubstitutionMatrix(FiniteAlphabet alpha, int match, int replace) {
        int i = 0;
        int j = 0;
        this.alphabet = alpha;
        this.description = "Identity matrix. All replaces and all matches are treated equally.";
        this.name = "IDENTITY_" + match + "_" + replace;
        this.rowSymbols = new HashMap();
        this.colSymbols = new HashMap();
        this.matrix = new int[alpha.size()][alpha.size()];
        Symbol[] sym = new Symbol[alpha.size()];
        Iterator iter = alpha.iterator();
        i = 0;
        while (iter.hasNext()) {
            sym[i] = (Symbol)iter.next();
            this.rowSymbols.put(sym[i], new Integer(i));
            this.colSymbols.put(sym[i], new Integer(i));
            ++i;
        }
        for (i = 0; i < this.alphabet.size(); ++i) {
            for (j = 0; j < this.alphabet.size(); ++j) {
                this.matrix[i][j] = sym[i].getMatches().contains(sym[j]) ? match : replace;
            }
        }
    }

    protected int[][] parseMatrix(String matString) throws BioException {
        StringTokenizer st;
        int j = 0;
        int rows = 0;
        int cols = 0;
        SymbolTokenization symtok = this.alphabet.getTokenization("token");
        this.min = Integer.MAX_VALUE;
        this.max = Integer.MIN_VALUE;
        StringTokenizer br = new StringTokenizer(matString, "\n");
        while (br.hasMoreElements()) {
            String line = br.nextElement().toString();
            if (line.startsWith("#")) {
                this.description = this.description + line.substring(1);
                continue;
            }
            if (line.startsWith(" ")) {
                st = new StringTokenizer(line, " ");
                j = 0;
                while (st.hasMoreElements()) {
                    this.colSymbols.put(symtok.parseToken(st.nextElement().toString()), new Integer(j));
                    ++j;
                }
                cols = j;
                continue;
            }
            if (line.startsWith("\n") || !(st = new StringTokenizer(line, " ")).hasMoreElements()) continue;
            this.rowSymbols.put(symtok.parseToken(st.nextElement().toString()), new Integer(rows++));
        }
        int[][] matrix = new int[rows][cols];
        rows = 0;
        br = new StringTokenizer(matString, "\n");
        while (br.hasMoreElements()) {
            String line = br.nextElement().toString();
            if (line.startsWith("#") || line.startsWith(" ") || line.startsWith("\n")) continue;
            st = new StringTokenizer(line, " ");
            if (st.hasMoreElements()) {
                st.nextElement();
            }
            j = 0;
            while (st.hasMoreElements()) {
                matrix[rows][j] = Integer.parseInt(st.nextElement().toString());
                if (matrix[rows][j] > this.max) {
                    this.max = matrix[rows][j];
                }
                if (matrix[rows][j] < this.min) {
                    this.min = matrix[rows][j];
                }
                ++j;
            }
            ++rows;
        }
        return matrix;
    }

    public int getValueAt(Symbol row, Symbol col) throws BioException {
        if (!this.rowSymbols.containsKey(row) || !this.colSymbols.containsKey(col)) {
            throw new BioException("No entry for the sybols " + row.getName() + " and " + col.getName());
        }
        return this.matrix[(Integer)this.rowSymbols.get(row)][(Integer)this.colSymbols.get(col)];
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public FiniteAlphabet getAlphabet() {
        return this.alphabet;
    }

    public String stringnifyMatrix() {
        int i = 0;
        String matrixString = "";
        Symbol[] colSyms = new Symbol[this.colSymbols.keySet().size()];
        try {
            SymbolTokenization symtok = this.alphabet.getTokenization("default");
            matrixString = matrixString + "  ";
            Iterator colKeys = this.colSymbols.keySet().iterator();
            while (colKeys.hasNext()) {
                colSyms[i] = (Symbol)colKeys.next();
                matrixString = matrixString + symtok.tokenizeSymbol(colSyms[i++]).toUpperCase() + " ";
            }
            matrixString = matrixString + "\n";
            Iterator rowKeys = this.rowSymbols.keySet().iterator();
            while (rowKeys.hasNext()) {
                Symbol rowSym = (Symbol)rowKeys.next();
                matrixString = matrixString + symtok.tokenizeSymbol(rowSym).toUpperCase() + " ";
                for (i = 0; i < colSyms.length; ++i) {
                    matrixString = matrixString + this.getValueAt(rowSym, colSyms[i]) + " ";
                }
                matrixString = matrixString + "\n";
            }
        }
        catch (BioException exc) {
            exc.printStackTrace();
        }
        return matrixString;
    }

    public String stringnifyDescription() {
        String desc = "";
        String line = "# ";
        StringTokenizer st = new StringTokenizer(this.description, " ");
        while (st.hasMoreElements()) {
            if ((line = line + st.nextElement().toString() + " ").length() >= 60) {
                desc = desc + line + "\n";
                if (!st.hasMoreElements()) continue;
                line = "# ";
                continue;
            }
            if (st.hasMoreElements()) continue;
            desc = desc + line + "\n";
        }
        return desc;
    }

    public String toString() {
        String desc = "";
        String line = "# ";
        StringTokenizer st = new StringTokenizer(this.description, " ");
        while (st.hasMoreElements()) {
            if ((line = line + st.nextElement().toString() + " ").length() >= 60) {
                desc = desc + line + "\n";
                if (!st.hasMoreElements()) continue;
                line = "# ";
                continue;
            }
            if (st.hasMoreElements()) continue;
            desc = desc + line + "\n";
        }
        return desc + this.stringnifyMatrix();
    }

    public void printMatrix() {
        Iterator rowKeys = this.rowSymbols.keySet().iterator();
        while (rowKeys.hasNext()) {
            Iterator colKeys = this.colSymbols.keySet().iterator();
            Symbol rowSym = (Symbol)rowKeys.next();
            System.out.print(rowSym.getName() + "\t");
            while (colKeys.hasNext()) {
                Symbol colSym = (Symbol)colKeys.next();
                int x = (Integer)this.rowSymbols.get(rowSym);
                int y = (Integer)this.colSymbols.get(colSym);
                System.out.print(colSym.getName() + " " + " " + x + " " + y + " " + this.matrix[x][y] + "\t");
            }
            System.out.println("\n");
        }
        System.out.println(this.toString());
    }

    public SubstitutionMatrix normalizeMatrix() {
        try {
            int j;
            int i;
            int min = this.getMin();
            int newMax = Integer.MIN_VALUE;
            int[][] mat = new int[this.matrix.length][this.matrix[this.matrix.length - 1].length];
            String name = this.getName() + "_normalized";
            String matString = this.stringnifyDescription() + "  ";
            FiniteAlphabet alphabet = this.getAlphabet();
            Map rowMap = this.rowSymbols;
            Map colMap = this.colSymbols;
            SymbolTokenization symtok = alphabet.getTokenization("default");
            for (i = 0; i < this.matrix.length; ++i) {
                for (j = 0; j < this.matrix[this.matrix.length - 1].length; ++j) {
                    mat[i][j] = this.matrix[i][j] - min;
                    if (mat[i][j] <= newMax) continue;
                    newMax = mat[i][j];
                }
            }
            for (i = 0; i < mat.length; ++i) {
                for (j = 0; j < mat[mat.length - 1].length; ++j) {
                    mat[i][j] = mat[i][j] * 10 / newMax;
                }
            }
            Object[] rows = this.rowSymbols.keySet().toArray();
            Object[] cols = this.colSymbols.keySet().toArray();
            for (i = 0; i < cols.length; ++i) {
                matString = matString + symtok.tokenizeSymbol((Symbol)cols[i]) + " ";
            }
            for (i = 0; i < rows.length; ++i) {
                matString = matString + "\n" + symtok.tokenizeSymbol((Symbol)rows[i]) + " ";
                for (j = 0; j < cols.length; ++j) {
                    matString = matString + mat[(Integer)rowMap.get((Symbol)rows[i])][(Integer)colMap.get((Symbol)cols[j])] + " ";
                }
            }
            matString = matString + "\n";
            return new SubstitutionMatrix(alphabet, matString, name);
        }
        catch (BioException exc) {
            exc.printStackTrace();
            return null;
        }
    }
}

