/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.brain;

import java.awt.Color;
import java.awt.Paint;
import org.jfree.chart.renderer.GrayPaintScale;

public class ColorPaintScale
extends GrayPaintScale {
    private Color lowerColor;
    private Color upperColor;
    private int gradientResolution = 10000;

    public ColorPaintScale(double lowerBound, double upperBound, Color lowerColor, Color upperColor) {
        super(lowerBound, upperBound);
        this.lowerColor = lowerColor;
        this.upperColor = upperColor;
    }

    public Paint getPaint(double value) {
        double lowerBound = super.getLowerBound();
        double upperBound = super.getUpperBound();
        double v = Math.max(value, lowerBound);
        v = Math.min(v, upperBound);
        int g = (int)((v - lowerBound) / (upperBound - lowerBound) * (double)this.gradientResolution);
        float ratio = (float)g / (float)this.gradientResolution;
        int red = (int)((float)this.upperColor.getRed() * ratio + (float)this.lowerColor.getRed() * (1.0f - ratio));
        int green = (int)((float)this.upperColor.getGreen() * ratio + (float)this.lowerColor.getGreen() * (1.0f - ratio));
        int blue = (int)((float)this.upperColor.getBlue() * ratio + (float)this.lowerColor.getBlue() * (1.0f - ratio));
        return new Color(red, green, blue);
    }
}

