/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.ga.impl;

import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeVetoException;
import org.biojavax.ga.GeneticAlgorithm;
import org.biojavax.ga.Population;
import org.biojavax.ga.functions.CrossOverFunction;
import org.biojavax.ga.functions.MutationFunction;
import org.biojavax.ga.functions.SelectionFunction;
import org.biojavax.ga.impl.SimplePopulation;

public abstract class AbstractGeneticAlgorithm
extends AbstractChangeable
implements GeneticAlgorithm {
    protected Population population = new SimplePopulation();
    private CrossOverFunction crossF;
    private SelectionFunction selectF;
    private MutationFunction mutF;

    protected AbstractGeneticAlgorithm() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setPopulation(Population pop) throws ChangeVetoException {
        if (!this.hasListeners()) {
            this.population = pop;
        } else {
            ChangeSupport changeSupport;
            ChangeEvent ce = new ChangeEvent(this, GeneticAlgorithm.POPULATION, pop, this.population);
            ChangeSupport changeSupport2 = changeSupport = super.getChangeSupport(GeneticAlgorithm.POPULATION);
            synchronized (changeSupport2) {
                changeSupport.firePreChangeEvent(ce);
                this.population = pop;
                changeSupport.firePostChangeEvent(ce);
            }
        }
    }

    public final Population getPopulation() {
        return this.population;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setSelectionFunction(SelectionFunction function) throws ChangeVetoException {
        if (!this.hasListeners()) {
            this.selectF = function;
        } else {
            ChangeSupport changeSupport;
            ChangeEvent ce = new ChangeEvent(this, GeneticAlgorithm.POPULATION, function, this.selectF);
            ChangeSupport changeSupport2 = changeSupport = super.getChangeSupport(GeneticAlgorithm.POPULATION);
            synchronized (changeSupport2) {
                changeSupport.firePreChangeEvent(ce);
                this.selectF = function;
                changeSupport.firePostChangeEvent(ce);
            }
        }
    }

    public final SelectionFunction getSelectionFunction() {
        return this.selectF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setCrossOverFunction(CrossOverFunction function) throws ChangeVetoException {
        if (!this.hasListeners()) {
            this.crossF = function;
        } else {
            ChangeSupport changeSupport;
            ChangeEvent ce = new ChangeEvent(this, GeneticAlgorithm.POPULATION, function, this.crossF);
            ChangeSupport changeSupport2 = changeSupport = super.getChangeSupport(GeneticAlgorithm.POPULATION);
            synchronized (changeSupport2) {
                changeSupport.firePreChangeEvent(ce);
                this.crossF = function;
                changeSupport.firePostChangeEvent(ce);
            }
        }
    }

    public final CrossOverFunction getCrossOverFunction() {
        return this.crossF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setMutationFunction(MutationFunction function) throws ChangeVetoException {
        if (!this.hasListeners()) {
            this.mutF = function;
        } else {
            ChangeSupport changeSupport;
            ChangeEvent ce = new ChangeEvent(this, GeneticAlgorithm.POPULATION, function, this.mutF);
            ChangeSupport changeSupport2 = changeSupport = super.getChangeSupport(GeneticAlgorithm.POPULATION);
            synchronized (changeSupport2) {
                changeSupport.firePreChangeEvent(ce);
                this.mutF = function;
                changeSupport.firePostChangeEvent(ce);
            }
        }
    }

    public final MutationFunction getMutationFunction() {
        return this.mutF;
    }
}

