/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.ga.functions;

import java.util.ArrayList;
import java.util.Random;
import org.biojava.bio.BioError;
import org.biojava.bio.symbol.Edit;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.PointLocation;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeVetoException;
import org.biojavax.ga.functions.AbstractCrossOverFunction;
import org.biojavax.ga.functions.GACrossResult;
import org.biojavax.ga.functions.SimpleGACrossResult;

public class SimpleCrossOverFunction
extends AbstractCrossOverFunction {
    public GACrossResult performCrossOver(SymbolList chromA, SymbolList chromB) throws ChangeVetoException {
        ArrayList<PointLocation> crossPoints = new ArrayList<PointLocation>();
        Random rand = new Random();
        for (int i = 1; i < chromA.length() && i < chromB.length(); ++i) {
            double crossProb = i - 1 > this.getCrossOverProbs().length - 1 ? this.getCrossOverProbs()[this.getCrossOverProbs().length - 1] : this.getCrossOverProbs()[i - 1];
            if (crossPoints.size() >= this.getMaxCrossOvers()) break;
            if (!(rand.nextDouble() <= crossProb)) continue;
            crossPoints.add(new PointLocation(i));
            SymbolList aReplace = chromB.subList(i, chromB.length());
            SymbolList bReplace = chromA.subList(i, chromA.length());
            Edit ed = new Edit(i, aReplace.length(), aReplace);
            try {
                chromA.edit(ed);
            }
            catch (IllegalAlphabetException ex) {
                throw new BioError(ex);
            }
            ed = new Edit(i, bReplace.length(), bReplace);
            try {
                chromB.edit(ed);
                continue;
            }
            catch (IllegalAlphabetException ex) {
                throw new BioError(ex);
            }
        }
        PointLocation[] crosses = new PointLocation[crossPoints.size()];
        crosses = crossPoints.toArray(crosses);
        return new SimpleGACrossResult(crosses, new SymbolList[]{chromA, chromB});
    }
}

