/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import org.biojava.bio.structure.AminoAcid;
import org.biojava.bio.structure.Chain;
import org.biojava.bio.structure.Group;
import org.biojava.bio.structure.GroupIterator;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.io.PDBFileParser;
import org.biojava.bio.structure.io.StructureIOFile;
import org.biojava.utils.io.InputStreamProvider;

public class PDBFileReader
implements StructureIOFile {
    String path = "";
    ArrayList extensions = new ArrayList();
    boolean parseSecStruc;

    public static void main(String[] args) {
        String filename = "/path/to/5pti.pdb";
        PDBFileReader pdbreader = new PDBFileReader();
        pdbreader.setParseSecStruc(true);
        try {
            Structure struc = pdbreader.getStructure(filename);
            System.out.println(struc);
            GroupIterator gi = new GroupIterator(struc);
            while (gi.hasNext()) {
                Group g = (Group)gi.next();
                Chain c = g.getParent();
                if (!(g instanceof AminoAcid)) continue;
                AminoAcid aa = (AminoAcid)g;
                Map sec = aa.getSecStruc();
                System.out.println(c.getName() + " " + g + " " + sec);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public PDBFileReader() {
        this.extensions.add(".ent");
        this.extensions.add(".pdb");
        this.extensions.add(".ent.gz");
        this.extensions.add(".pdb.gz");
        this.extensions.add(".ent.Z");
        this.extensions.add(".pdb.Z");
        this.parseSecStruc = false;
    }

    public boolean isParseSecStruc() {
        return this.parseSecStruc;
    }

    public void setParseSecStruc(boolean parseSecStruc) {
        this.parseSecStruc = parseSecStruc;
    }

    public void setPath(String p) {
        this.path = p;
    }

    public String getPath() {
        return this.path;
    }

    public void addExtension(String s) {
        this.extensions.add(s);
    }

    private InputStream getInputStream(String pdbId) throws IOException {
        InputStream inputStream = null;
        String pdbFile = null;
        File f = null;
        String fpath = this.path + "/" + pdbId;
        String ppath = this.path + "/pdb" + pdbId;
        String[] paths = new String[]{fpath, ppath};
        block0: for (int p = 0; p < paths.length; ++p) {
            String testpath = paths[p];
            for (int i = 0; i < this.extensions.size(); ++i) {
                String ex = (String)this.extensions.get(i);
                f = new File(testpath + ex);
                if (f.exists()) {
                    pdbFile = testpath + ex;
                    InputStreamProvider isp = new InputStreamProvider();
                    inputStream = isp.getInputStream(pdbFile);
                    continue block0;
                }
                if (pdbFile != null) continue block0;
            }
        }
        if (pdbFile == null) {
            String message = "no structure with PDB code " + pdbId + " found!";
            throw new IOException(message);
        }
        return inputStream;
    }

    public Structure getStructureById(String pdbId) throws IOException {
        InputStream inStream = this.getInputStream(pdbId);
        PDBFileParser pdbpars = new PDBFileParser();
        pdbpars.setParseSecStruc(this.parseSecStruc);
        Structure struc = pdbpars.parsePDBFile(inStream);
        return struc;
    }

    public Structure getStructure(String filename) throws IOException {
        File f = new File(filename);
        return this.getStructure(f);
    }

    public Structure getStructure(File filename) throws IOException {
        InputStreamProvider isp = new InputStreamProvider();
        InputStream inStream = isp.getInputStream(filename);
        PDBFileParser pdbpars = new PDBFileParser();
        pdbpars.setParseSecStruc(this.parseSecStruc);
        Structure struc = pdbpars.parsePDBFile(inStream);
        return struc;
    }
}

