/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.biojava.bio.structure.Chain;
import org.biojava.bio.structure.ChainImpl;
import org.biojava.bio.structure.Group;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.StructureException;
import org.biojava.bio.structure.io.FileConvert;

public class StructureImpl
implements Structure {
    String pdb_id;
    ArrayList models = new ArrayList();
    HashMap header = new HashMap();
    ArrayList connections = new ArrayList();
    String name = "";
    boolean nmrflag = false;

    public StructureImpl() {
    }

    public StructureImpl(Group g) {
        this();
        ChainImpl c = new ChainImpl();
        c.addGroup(g);
        this.addChain(c);
    }

    public StructureImpl(Chain c) {
        this();
        this.addChain(c);
    }

    public Object clone() {
        StructureImpl n = new StructureImpl();
        if (this.isNmr()) {
            n.setNmr(true);
        }
        n.setPDBCode(this.getPDBCode());
        n.setName(this.getName());
        n.setHeader(this.getHeader());
        n.setConnections(this.getConnections());
        for (int i = 0; i < this.nrModels(); ++i) {
            ArrayList<Chain> cloned_model = new ArrayList<Chain>();
            for (int j = 0; j < this.size(i); ++j) {
                Chain current_chain = this.getChain(i, j);
                Chain cloned_chain = (Chain)current_chain.clone();
                cloned_model.add(cloned_chain);
            }
            n.addModel(cloned_model);
        }
        return n;
    }

    public Group findGroup(String chainId, String pdbResnum, int modelnr) throws StructureException {
        if (modelnr > this.models.size()) {
            throw new StructureException(" no model nr " + modelnr + " in this structure. (contains " + this.models.size() + ")");
        }
        Chain c = this.findChain(chainId, modelnr);
        List groups = c.getGroups();
        Iterator giter = groups.iterator();
        while (giter.hasNext()) {
            Group g = (Group)giter.next();
            String rnum = g.getPDBCode();
            if (!rnum.equals(pdbResnum)) continue;
            return g;
        }
        throw new StructureException("could not find group " + pdbResnum + " in chain " + chainId);
    }

    public Group findGroup(String chainName, String pdbResnum) throws StructureException {
        return this.findGroup(chainName, pdbResnum, 0);
    }

    public Chain findChain(String chainId, int modelnr) throws StructureException {
        List chains = this.getChains(modelnr);
        Iterator iter = chains.iterator();
        while (iter.hasNext()) {
            Chain c = (Chain)iter.next();
            if (!c.getName().equals(chainId)) continue;
            return c;
        }
        throw new StructureException("could not find chain " + chainId);
    }

    public Chain findChain(String chainId) throws StructureException {
        return this.findChain(chainId, 0);
    }

    public void setPDBCode(String pdb_id_) {
        this.pdb_id = pdb_id_;
    }

    public String getPDBCode() {
        return this.pdb_id;
    }

    public void setName(String nam) {
        this.name = nam;
    }

    public String getName() {
        return this.name;
    }

    public void setHeader(Map h) {
        this.header = (HashMap)h;
    }

    public Map getHeader() {
        return this.header;
    }

    public void setConnections(List conns) {
        this.connections = (ArrayList)conns;
    }

    public List getConnections() {
        return this.connections;
    }

    public void addChain(Chain chain) {
        int modelnr = 0;
        this.addChain(chain, modelnr);
    }

    public void addChain(Chain chain, int modelnr) {
        if (this.models.size() == 0) {
            ArrayList<Chain> model = new ArrayList<Chain>();
            model.add(chain);
            this.models.add(model);
        } else {
            ArrayList model = (ArrayList)this.models.get(modelnr);
            model.add(chain);
        }
    }

    public Chain getChain(int number) {
        int modelnr = 0;
        return this.getChain(modelnr, number);
    }

    public Chain getChain(int modelnr, int number) {
        ArrayList model = (ArrayList)this.models.get(modelnr);
        Chain chain = (Chain)model.get(number);
        return chain;
    }

    public void addModel(List model) {
        this.models.add((ArrayList)model);
    }

    public String toString() {
        String str = "structure " + this.name + " " + this.pdb_id;
        if (this.isNmr()) {
            str = str + " models: " + this.nrModels() + "\n";
        }
        str = str + this.header;
        for (int i = 0; i < this.nrModels(); ++i) {
            if (this.isNmr()) {
                str = str + " model[" + i + "]:";
            }
            str = str + " chains:";
            str = str + "\n";
            for (int j = 0; j < this.size(i); ++j) {
                Chain cha = this.getChain(i, j);
                List agr = cha.getGroups("amino");
                List hgr = cha.getGroups("hetatm");
                List ngr = cha.getGroups("nucleotide");
                str = str + "chain: >" + cha.getName() + "<" + " length: " + cha.getLength() + " aminos: " + agr.size() + " hetatms: " + hgr.size() + " nucleotides: " + ngr.size() + "\n";
            }
        }
        return str;
    }

    public int size() {
        int modelnr = 0;
        ArrayList model = null;
        if (this.models.size() <= 0) {
            return 0;
        }
        model = (ArrayList)this.models.get(modelnr);
        return model.size();
    }

    public int size(int modelnr) {
        return this.getChains(modelnr).size();
    }

    public int nrModels() {
        return this.models.size();
    }

    public boolean isNmr() {
        return this.nmrflag;
    }

    public void setNmr(boolean nmr) {
        this.nmrflag = nmr;
    }

    public List getChains(int modelnr) {
        return this.getModel(modelnr);
    }

    public List getModel(int modelnr) {
        ArrayList model = (ArrayList)this.models.get(modelnr);
        return model;
    }

    public Chain getChainByPDB(String chainId, int modelnr) throws StructureException {
        List chains = this.getChains(modelnr);
        Iterator iter = chains.iterator();
        while (iter.hasNext()) {
            Chain c = (Chain)iter.next();
            if (!c.getName().equals(chainId)) continue;
            return c;
        }
        throw new StructureException("did not find chain with chainId >" + chainId + "<");
    }

    public Chain getChainByPDB(String chainId) throws StructureException {
        return this.getChainByPDB(chainId, 0);
    }

    public String toPDB() {
        FileConvert f = new FileConvert(this);
        String str = f.toPDB();
        return str;
    }

    public boolean hasChain(String chainId) {
        int modelnr = 0;
        List chains = this.getChains(modelnr);
        Iterator iter = chains.iterator();
        while (iter.hasNext()) {
            Chain c = (Chain)iter.next();
            if (!c.getName().equals(chainId)) continue;
            return true;
        }
        return false;
    }
}

