/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.blast2html;

import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.biojava.bio.program.blast2html.AlignmentMarker;
import org.biojava.bio.program.blast2html.BlastLikeAlignment;
import org.biojava.bio.program.blast2html.DatabaseURLGenerator;
import org.biojava.bio.program.blast2html.DetailHit;
import org.biojava.bio.program.blast2html.HSPSummary;
import org.biojava.bio.program.blast2html.HitSummary;
import org.biojava.bio.program.blast2html.URLGeneratorFactory;

public class HTMLRenderer {
    private StringBuffer align = new StringBuffer();
    private StringBuffer alignMarkUp1 = new StringBuffer();
    private StringBuffer alignMarkUp2 = new StringBuffer();
    private PrintWriter out = null;
    private String oStyleDef;
    private StringBuffer pcDataBuffer = new StringBuffer(80);
    private boolean tAlternateSummary = false;
    private int iSummaryCount = 0;
    private boolean tNeedComma = false;
    private int iAlignLen = 50;
    private List oURLGeneratorList = null;
    private DatabaseURLGenerator oFirstURLGenerator = null;
    private AlignmentMarker oAlignmentMarker;
    private static String oJavaScriptDef = "<script language=\"JavaScript\">\nfunction setStatus(msgStr) { \n status=msgStr;\n  document.retVal = true;\n}\n</script>";
    private char[] padding = new char[100];
    private Properties oOptions;
    private boolean wasEmpty;

    public HTMLRenderer(PrintWriter poPrintWriter, String poStyleDef, int piAlignmentWidth, URLGeneratorFactory poFactory, AlignmentMarker poAlignmentMarker, Properties poOptions) {
        Arrays.fill(this.padding, 0, 100, ' ');
        this.oOptions = null;
        this.wasEmpty = true;
        this.oOptions = poOptions;
        if (poFactory != null) {
            this.oURLGeneratorList = poFactory.getDatabaseURLGenerators();
            if (!this.oURLGeneratorList.isEmpty()) {
                this.oFirstURLGenerator = (DatabaseURLGenerator)this.oURLGeneratorList.get(0);
            }
        }
        if (piAlignmentWidth <= 0) {
            throw new IllegalArgumentException("Alignment length must be > 0, not " + piAlignmentWidth);
        }
        this.iAlignLen = piAlignmentWidth;
        this.oStyleDef = poStyleDef;
        if (poPrintWriter == null) {
            throw new IllegalArgumentException("PrintWriter cannot be null");
        }
        this.out = poPrintWriter;
        this.oAlignmentMarker = poAlignmentMarker;
    }

    public void setPrintWriter(PrintWriter poPrintWriter) {
        this.out = poPrintWriter;
        this.tAlternateSummary = false;
        this.iSummaryCount = 0;
        this.tNeedComma = false;
        this.wasEmpty = true;
        this.align.setLength(0);
        this.alignMarkUp1.setLength(0);
        this.alignMarkUp2.setLength(0);
        this.pcDataBuffer.setLength(0);
    }

    public boolean wasEmpty() {
        return this.wasEmpty;
    }

    void writeTitleAndHeader(String oProgram, String oVersion, String oQuery, String oDatabase) {
        this.out.print("<TITLE>");
        this.out.print(oProgram);
        this.out.print(" version ");
        this.out.print(oVersion);
        this.out.print(" Search Results Query ID : ");
        this.out.print(oQuery);
        this.out.println("</TITLE>");
        this.out.println("<table width=\"100%\" border=\"0\" cellpadding=\"3\" cellspacing=\"0\">");
        this.out.println("  <tr align=\"left\" valign=\"top\">");
        this.out.println("    <td class=\"titleLevel1\" rowspan=\"3\"><a name=\"#AnchorTop\"></a>Sequence Similarity Report</td>");
        this.out.println("    <td align=\"right\" class=\"titleLevel1Sub\"> Query Id:</td>");
        this.out.print("    <td class=\"titleLevel1Sub\">");
        this.out.print(oQuery);
        this.out.println("&nbsp;</td>");
        this.out.println("  </tr><tr align=\"left\" valign=\"top\" class=\"level1titleContainer\"> ");
        this.out.println("    <td class=\"titleLevel1Sub\" align=\"right\">Search&nbsp;Program:</td>");
        this.out.print("    <td class=\"titleLevel1Sub\">");
        this.out.print(oProgram);
        this.out.print(" v.&nbsp;");
        this.out.print(oVersion);
        this.out.println("</td>");
        this.out.println("  </tr><tr align=\"left\" valign=\"top\" class=\"level1titleContainer\">");
        this.out.println("    <td class=\"titleLevel1Sub\" align=\"right\">Database:</td>");
        this.out.print("    <td class=\"titleLevel1Sub\">");
        this.out.print(oDatabase);
        this.out.println("</td>");
        this.out.println("  </tr>");
        this.out.println("</table>");
    }

    public String getHeaderDefinitions() {
        StringBuffer sb = new StringBuffer();
        sb.append("<STYLE TYPE=\"text/css\">\n");
        sb.append("<!--\n");
        sb.append(this.oStyleDef);
        if (this.oAlignmentMarker != null) {
            sb.append(this.oAlignmentMarker.getAlignmentStyles());
        }
        sb.append("-->\n</STYLE>\n");
        sb.append(oJavaScriptDef);
        return sb.substring(0);
    }

    void startSummaryTable(HitSummary oHitSummary) {
        this.wasEmpty = false;
        this.out.println("<br>");
        this.out.println("<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">");
        this.out.println("<tr valign=\"middle\"> ");
        this.out.println("<td colspan=\"4\" class=\"titleLevel2\" align=\"left\">Overview of Results</td>");
        this.out.println("</tr>");
        this.out.println("</table>");
        this.out.println("<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">");
        this.out.println("<td class=\"titleLevel3\" >");
        this.out.println("<table  width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">");
        this.out.println("<tr> ");
        this.out.println("<td class=\"titleLevel3\" width=\"40%\" align=\"left\" >Hit Id</td>");
        this.out.println("<td class=\"titleLevel3\" width=\"60%\" align=\"left\">Hit Description</td>");
        this.out.println("</tr>");
        this.out.println("</table>");
        this.out.println("</td> ");
        if (oHitSummary.readingFrame != null) {
            this.out.println("<td width=\"7%\" class=\"titleLevel3\" align=\"center\">Frame</td>");
        }
        this.out.println("<td width=\"7%\" class=\"titleLevel3\" align=\"center\">Score</td>");
        if (oHitSummary.expectValue != null) {
            this.out.println("<td width=\"7%\" class=\"titleLevel3\" align=\"center\">E value</td>");
        }
        if (oHitSummary.smallestSumProbability != null) {
            this.out.println("<td width=\"7%\" class=\"titleLevel3\" align=\"center\">P(N)</td>");
        }
        if (oHitSummary.numberOfHSPs != null) {
            this.out.println("<td width=\"7%\" class=\"titleLevel3\" align=\"left\">HSPs</td>");
        }
        if (oHitSummary.numberOfContributingHSPs != null) {
            this.out.println("<td width=\"7%\" class=\"titleLevel3\" align=\"center\">HSPs</td>");
        }
        this.out.println("</tr>");
        this.iSummaryCount = 10;
    }

    void writeCurrentSummary(HitSummary oHitSummary) {
        if (this.iSummaryCount == 10) {
            this.iSummaryCount = 0;
            this.out.println("</table>");
            this.out.println("<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">");
        }
        this.out.println("<tr valign=\"middle\" align=\"left\" > ");
        this.out.print("<td class=\"");
        if (this.tAlternateSummary) {
            this.out.print("summaryBodyLineEven");
        } else {
            this.out.print("summaryBodyLineOdd");
        }
        this.out.print("\">");
        this.out.println("<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">");
        this.out.println("<tr> ");
        this.out.print("<td width=\"40%\" class=\"");
        if (this.tAlternateSummary) {
            this.out.print("summaryBodyLineEven");
        } else {
            this.out.print("summaryBodyLineOdd");
        }
        this.out.print("\" >");
        if (this.oFirstURLGenerator != null) {
            this.out.print("<a href=\"");
            this.out.print(this.oFirstURLGenerator.toURL(oHitSummary.oHitId.id, this.oOptions));
            this.out.print("\" onMouseOver=\"setStatus('Retrieve hit from database');return document.retVal\" onMouseOut=\"setStatus(' ');return document.retVal\" class=\"dbRetrieve\">");
            this.out.print(oHitSummary.oHitId.id);
            this.out.print("</a></td>");
        } else {
            this.out.print(oHitSummary.oHitId.id);
            this.out.println("</td>");
        }
        this.out.print("<td width=\"60%\" class=\"");
        if (this.tAlternateSummary) {
            this.out.print("summaryBodyLineEven");
        } else {
            this.out.print("summaryBodyLineOdd");
        }
        this.out.print("\"><a href=\"#Anchor");
        this.out.print(oHitSummary.oHitId.id);
        this.out.print("\" onMouseOver=\"setStatus('Jump to detailed results');return document.retVal\" onMouseOut=\"setStatus(' ');return document.retVal\">");
        this.writeContentChars(oHitSummary.oDesc.hitDescription);
        this.out.println("</a></td>");
        this.out.println("</tr>");
        this.out.println("</table>");
        this.out.println("</td> ");
        this.writeSummaryColumn(oHitSummary.readingFrame, "center");
        this.out.print("<td width=\"7%\" align=\"center\" class=\"");
        if (this.tAlternateSummary) {
            this.out.print("summaryBodyLineEven");
        } else {
            this.out.print("summaryBodyLineOdd");
        }
        this.out.print("\"><a href=\"#Anchor");
        this.out.print(oHitSummary.oHitId.id);
        this.out.print("\" onMouseOver=\"setStatus('Jump to detailed results');return document.retVal\" onMouseOut=\"setStatus(' ');return document.retVal\">");
        this.out.print(oHitSummary.score);
        this.out.println("</a></td>");
        this.writeSummaryColumn(oHitSummary.expectValue, "center");
        this.writeSummaryColumn(oHitSummary.smallestSumProbability, "center");
        this.writeSummaryColumn(oHitSummary.numberOfHSPs, "center");
        this.writeSummaryColumn(oHitSummary.numberOfContributingHSPs, "center");
        this.out.println("</tr>");
        this.tAlternateSummary = !this.tAlternateSummary;
        ++this.iSummaryCount;
    }

    void writeSummaryColumn(String poValue, String poAlign) {
        if (poValue != null) {
            this.out.print("<td width=\"7%\" align=\"");
            this.out.print(poAlign);
            this.out.print("\" class=\"");
            if (this.tAlternateSummary) {
                this.out.print("summaryBodyLineEven");
            } else {
                this.out.print("summaryBodyLineOdd");
            }
            this.out.print("\">");
            this.out.print(poValue);
            this.out.println("</td>");
        }
    }

    void endSummaryTable() {
        this.out.println("</table>");
        this.out.println("<br>");
    }

    void startDetailTable() {
        this.wasEmpty = false;
        this.out.println("<br>");
        this.out.println("<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">");
        this.out.println("<tr valign=\"middle\"> ");
        this.out.println("<td class=\"titleLevel2\" align=\"left\">Detailed Analysis of Results</td>");
        this.out.println("</tr>");
        this.out.println("</table>");
    }

    void writeCurrentDetail(DetailHit oDetailHit) {
        this.out.println("<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"5\">");
        this.out.println("<tr align=\"left\" valign=\"top\"> ");
        this.out.print("<td class=\"titleLevel3\"> <a name=\"Anchor");
        this.out.print(oDetailHit.oHitId.id);
        this.out.print("\"></a>Hit Id : ");
        this.out.print(oDetailHit.oHitId.id);
        this.out.println("<br><span class=\"titleLevel3Sub\">");
        this.writeContentChars(oDetailHit.oDesc.hitDescription);
        this.out.println("</span></td>");
        this.out.println("<td class=\"titleLevel3\" align=\"right\" color=\"#000000\" ><a href=\"#AnchorTop\" onMouseOver=\"setStatus('Jump to top of  document');return document.retVal\" onMouseOut=\"setStatus(' ');return document.retVal\">Top</a></td>");
        this.out.println("</tr>");
        this.out.println("<tr align=\"left\" valign=\"top\"> ");
        this.out.println("<td colspan=\"2\"><span class=\"alignment\">");
        this.out.print("<p>Sequence length of hit = ");
        this.out.print(oDetailHit.sequenceLength);
        this.out.println("</span></td>");
        this.out.println("<br>");
        if (this.oURLGeneratorList != null && !this.oURLGeneratorList.isEmpty()) {
            this.out.println("<tr align=\"left\" valign=\"top\"> ");
            this.out.print("<td colspan=\"");
            this.out.print(this.oURLGeneratorList.size() + "");
            this.out.println("\"> ");
            for (int i = 0; i < this.oURLGeneratorList.size(); ++i) {
                DatabaseURLGenerator oURLGenerator = (DatabaseURLGenerator)this.oURLGeneratorList.get(i);
                this.out.print(oURLGenerator.toLink(oDetailHit.oHitId.id, this.oOptions));
            }
            this.out.println("</p></td>");
            this.out.println("</tr>");
        }
        this.out.print("</table>");
    }

    void writeHSPInfo(String poName, String poValue) {
        if (poValue != null) {
            if (this.tNeedComma) {
                this.out.print(", ");
            }
            this.out.print(poName);
            this.out.print("&nbsp;=&nbsp;");
            this.out.print(poValue);
            this.tNeedComma = true;
        }
    }

    void writeCurrentHSP(HSPSummary oHSPSummary, BlastLikeAlignment oAlignment) {
        this.tNeedComma = false;
        this.out.println("<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"5\">");
        this.out.println("<tr align=\"left\" valign=\"top\"> ");
        this.out.println("<td class=\"titleLevel4\">High-scoring segment pair (HSP) group</td>");
        this.out.println("</tr>");
        this.out.println("</table>");
        this.out.println("<div align=\"right\"><br>");
        this.out.println("<table width=\"95%\" border=\"0\" cellspacing=\"0\" cellpadding=\"5\">");
        this.out.println("<tr align=\"left\" valign=\"top\" class=\"level4title\"> ");
        this.out.println("<td class=\"titleLevel4\"> ");
        this.out.println("<p>HSP Information<br>");
        this.writeHSPInfo("Score", oHSPSummary.score);
        this.writeHSPInfo("E", oHSPSummary.expectValue);
        this.writeHSPInfo("P", oHSPSummary.pValue);
        if (oHSPSummary.numberOfIdentities != null || oHSPSummary.percentageIdentity != null) {
            this.out.print(", Identities&nbsp;=&nbsp;");
            if (oHSPSummary.numberOfIdentities != null) {
                this.out.print(oHSPSummary.numberOfIdentities);
                if (oHSPSummary.alignmentSize != null) {
                    this.out.print("/");
                    this.out.print(oHSPSummary.alignmentSize);
                }
                if (oHSPSummary.percentageIdentity != null) {
                    this.out.print("&nbsp;(");
                    this.out.print(oHSPSummary.percentageIdentity);
                    this.out.print("%)");
                }
            }
        }
        if (oHSPSummary.numberOfPositives != null || oHSPSummary.percentagePositives != null) {
            this.out.print(", Positives&nbsp;=&nbsp;");
            if (oHSPSummary.numberOfPositives != null) {
                this.out.print(oHSPSummary.numberOfPositives);
                if (oHSPSummary.alignmentSize != null) {
                    this.out.print("/");
                    this.out.print(oHSPSummary.alignmentSize);
                }
                if (oHSPSummary.percentagePositives != null) {
                    this.out.print("&nbsp;(");
                    this.out.print(oHSPSummary.percentagePositives);
                    this.out.print("%)");
                }
            }
        }
        this.writeHSPInfo("Length", oHSPSummary.alignmentSize);
        this.writeHSPInfo("Query Frame", this.toSign(oHSPSummary.queryFrame));
        this.writeHSPInfo("Hit Frame", this.toSign(oHSPSummary.hitFrame));
        if (oHSPSummary.queryFrame == null) {
            this.writeHSPInfo("Query Strand", this.toSign(oHSPSummary.queryStrand));
        }
        if (oHSPSummary.hitFrame == null) {
            this.writeHSPInfo("Hit Strand", this.toSign(oHSPSummary.hitStrand));
        }
        this.writeHSPInfo("P(N)", oHSPSummary.sumPValues);
        this.writeHSPInfo("No.&nbsp;of&nbsp;gaps", oHSPSummary.numberOfGaps);
        this.out.println("</p>");
        this.out.println("</td>");
        this.out.println("</tr>");
        this.out.println("</table>");
        this.out.println("</div>");
        this.out.println("<div align=\"right\">");
        this.out.println("<table width=\"95%\" border=\"0\" cellspacing=\"0\" cellpadding=\"5\">");
        this.out.println("<tr> ");
        this.out.println("<td> </td>");
        this.out.println("</tr>");
        this.drawCurrentAlignment(oAlignment);
        this.out.println("</table>");
        this.out.println("</div>");
    }

    String drawSubAlignment(String piQueryStart, String piQueryStop, String piHitStart, String piHitStop, String poQuery, String poConsensus, String poHit) {
        this.align.setLength(0);
        int iMax = 4;
        if (piQueryStart.length() > iMax) {
            iMax = piQueryStart.length();
        }
        if (piHitStart.length() > iMax) {
            iMax = piHitStart.length();
        }
        iMax += 2;
        String[] oFormattedSeq = new String[]{poQuery, poHit, poConsensus};
        if (this.oAlignmentMarker != null) {
            this.oAlignmentMarker.alignment2HTML(oFormattedSeq);
        }
        String oConsensusPad = "       ";
        oConsensusPad = oConsensusPad.concat(this.padTo("", iMax));
        this.align.append("<tr align=\"left\" valign=\"top\"> ");
        this.align.append("\n");
        this.align.append("<td>");
        this.align.append("\n");
        this.align.append("<pre><span class=\"alignment\">Query: ");
        this.align.append(this.padTo(piQueryStart, iMax));
        this.align.append(oFormattedSeq[0]);
        this.align.append("  ");
        this.align.append(this.padTo(piQueryStop, iMax));
        this.align.append("\n");
        this.align.append(oConsensusPad);
        this.align.append(oFormattedSeq[2]);
        this.align.append("\n");
        this.align.append("Hit  : ");
        this.align.append(this.padTo(piHitStart, iMax));
        this.align.append(oFormattedSeq[1]);
        this.align.append("  ");
        this.align.append(this.padTo(piHitStop, iMax));
        this.align.append("</span></PRE> ");
        this.align.append("\n");
        this.align.append("");
        this.align.append("\n");
        this.align.append("</td>");
        this.align.append("\n");
        this.align.append("</tr>");
        this.align.append("\n");
        return this.align.substring(0);
    }

    void drawCurrentAlignment(BlastLikeAlignment oAlignment) {
        int i = 0;
        int iCurrentQueryStart = Integer.parseInt(oAlignment.oQuerySeq.startPosition);
        int iCurrentHitStart = Integer.parseInt(oAlignment.oHitSeq.startPosition);
        int iQueryLen = oAlignment.oQuerySeq.seq.length();
        int iHitLen = oAlignment.oHitSeq.seq.length();
        int iNumberOfQueryGaps = 0;
        int iNumberOfHitGaps = 0;
        int index = -1;
        while ((index = oAlignment.oQuerySeq.seq.indexOf(45, index + 1)) != -1) {
            ++iNumberOfQueryGaps;
        }
        index = -1;
        while ((index = oAlignment.oHitSeq.seq.indexOf(45, index + 1)) != -1) {
            ++iNumberOfHitGaps;
        }
        int iQStop = Integer.parseInt(oAlignment.oQuerySeq.stopPosition);
        int iHStop = Integer.parseInt(oAlignment.oHitSeq.stopPosition);
        int queryDirection = 1;
        int hitDirection = 1;
        if (iQStop < iCurrentQueryStart) {
            queryDirection = -1;
        }
        if (iHStop < iCurrentHitStart) {
            hitDirection = -1;
        }
        int iQueryMultiplier = (iQStop - iCurrentQueryStart + queryDirection) / (iQueryLen - iNumberOfQueryGaps);
        int iHitMultiplier = (iHStop - iCurrentHitStart + hitDirection) / (iHitLen - iNumberOfHitGaps);
        int iCurrentQueryEnd = 0;
        int iCurrentHitEnd = 0;
        while ((i + 1) * this.iAlignLen < iQueryLen) {
            String oCurrentQueryString = oAlignment.oQuerySeq.seq.substring(i * this.iAlignLen, (i + 1) * this.iAlignLen);
            String oCurrentHitString = oAlignment.oHitSeq.seq.substring(i * this.iAlignLen, (i + 1) * this.iAlignLen);
            iNumberOfQueryGaps = this.countNumberOfGaps(oCurrentQueryString);
            iNumberOfHitGaps = this.countNumberOfGaps(oCurrentHitString);
            iCurrentQueryEnd = iCurrentQueryStart + (this.iAlignLen - iNumberOfQueryGaps) * iQueryMultiplier;
            iCurrentHitEnd = iCurrentHitStart + (this.iAlignLen - iNumberOfHitGaps) * iHitMultiplier;
            this.out.println(this.drawSubAlignment(iCurrentQueryStart + "", iCurrentQueryEnd - queryDirection + "", iCurrentHitStart + "", iCurrentHitEnd - hitDirection + "", oCurrentQueryString, oAlignment.oConsensus.substring(i * this.iAlignLen, (i + 1) * this.iAlignLen), oCurrentHitString));
            ++i;
            iCurrentQueryStart += (this.iAlignLen - iNumberOfQueryGaps) * iQueryMultiplier;
            iCurrentHitStart += (this.iAlignLen - iNumberOfHitGaps) * iHitMultiplier;
        }
        if (iQStop != iCurrentQueryEnd) {
            iCurrentQueryEnd = iQStop;
            iCurrentHitEnd = iHStop;
            this.out.println(this.drawSubAlignment(iCurrentQueryStart + "", iCurrentQueryEnd + "", iCurrentHitStart + "", iCurrentHitEnd + "", oAlignment.oQuerySeq.seq.substring(i * this.iAlignLen), oAlignment.oConsensus.substring(i * this.iAlignLen), oAlignment.oHitSeq.seq.substring(i * this.iAlignLen)));
        }
    }

    void endDetailTable() {
        this.out.println("<table width=\"100%\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">");
        this.out.println("<tr> ");
        this.out.println("<td class=\"footer\" height=\"21\"> ");
        this.out.println("<div align=\"center\"> <a href=\"http://www.biojava.org/\" class=\"footer\"> </a> ");
        this.out.println("Produced using <a href=\"http://www.biojava.org/\" class=\"footer\">biojava</a> ");
        this.out.println("- www.biojava.org</div>");
        this.out.println("</td>");
        this.out.println("</tr>");
        this.out.println("</table>");
    }

    private String toSign(String poString) {
        String oSign = null;
        if (poString != null) {
            if (poString.startsWith("plus")) {
                oSign = "+";
                if (poString.length() > 4) {
                    oSign = oSign.concat(poString.substring(4));
                }
            } else if (poString.startsWith("minus")) {
                oSign = "-";
                if (poString.length() > 5) {
                    oSign = oSign.concat(poString.substring(5));
                }
            }
        }
        return oSign;
    }

    private void writeContentChars(String poLine) {
        poLine = this.replace(poLine, '&', "&amp;");
        poLine = this.replaceGtLtAndQuote(poLine);
        this.out.print(poLine);
    }

    private String replaceGtLtAndQuote(String poInputString) {
        int iLength;
        this.pcDataBuffer.setLength(0);
        this.pcDataBuffer.append(poInputString);
        int i = iLength = this.pcDataBuffer.length();
        while (--i >= 0) {
            if (this.pcDataBuffer.charAt(i) == '<') {
                this.pcDataBuffer.deleteCharAt(i);
                this.pcDataBuffer.insert(i, "&lt;");
                continue;
            }
            if (this.pcDataBuffer.charAt(i) == '>') {
                this.pcDataBuffer.deleteCharAt(i);
                this.pcDataBuffer.insert(i, "&gt;");
                continue;
            }
            if (this.pcDataBuffer.charAt(i) != '\\') continue;
            this.pcDataBuffer.deleteCharAt(i);
            this.pcDataBuffer.insert(i, "&quot;");
        }
        return this.pcDataBuffer.substring(0);
    }

    private String replace(String poInputString, char pcCharToReplace, String poReplacementString) {
        int iLength;
        this.pcDataBuffer.setLength(0);
        this.pcDataBuffer.append(poInputString);
        int i = iLength = this.pcDataBuffer.length();
        while (--i >= 0) {
            if (this.pcDataBuffer.charAt(i) != pcCharToReplace) continue;
            this.pcDataBuffer.deleteCharAt(i);
            this.pcDataBuffer.insert(i, poReplacementString);
        }
        return this.pcDataBuffer.substring(0);
    }

    int countNumberOfGaps(String poString) {
        int index = -1;
        int iNumberOfGaps = 0;
        while ((index = poString.indexOf(45, index + 1)) != -1) {
            ++iNumberOfGaps;
        }
        return iNumberOfGaps;
    }

    String padTo(String poString, int iNumberOfChars) {
        int iLen = iNumberOfChars - poString.length();
        if (iLen > this.padding.length) {
            this.padding = new char[iLen];
            Arrays.fill(this.padding, 0, iLen, ' ');
        }
        return poString.concat(String.copyValueOf(this.padding, 0, iLen));
    }
}

