/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.abi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.ArrayList;
import org.biojava.bio.BioError;
import org.biojava.bio.chromatogram.AbstractChromatogram;
import org.biojava.bio.chromatogram.Chromatogram;
import org.biojava.bio.chromatogram.UnsupportedChromatogramFormatException;
import org.biojava.bio.program.abi.ABIFParser;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.IntegerAlphabet;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.SmallMap;

public class ABIFChromatogram
extends AbstractChromatogram
implements Serializable {
    public static ABIFChromatogram create(File f) throws IOException, UnsupportedChromatogramFormatException {
        ABIFChromatogram newOne = new ABIFChromatogram();
        newOne.load(f);
        return newOne;
    }

    public static ABIFChromatogram create(InputStream in) throws IOException, UnsupportedChromatogramFormatException {
        ABIFChromatogram newOne = new ABIFChromatogram();
        newOne.load(in);
        return newOne;
    }

    protected ABIFChromatogram load(File f) throws IOException, UnsupportedChromatogramFormatException {
        new Parser(f);
        return this;
    }

    protected ABIFChromatogram load(InputStream in) throws IOException, UnsupportedChromatogramFormatException {
        new Parser(in);
        return this;
    }

    protected AbstractChromatogram reverseComplementInstance() {
        return new ABIFChromatogram();
    }

    protected class Parser
    extends ABIFParser {
        public Parser(InputStream in) throws IOException, UnsupportedChromatogramFormatException {
            super(in);
            this.parse();
        }

        public Parser(File f) throws IOException, UnsupportedChromatogramFormatException {
            super(f);
            this.parse();
        }

        private final void parse() throws IOException, UnsupportedChromatogramFormatException {
            char[] fwo_ = new char[4];
            ABIFParser.TaggedDataRecord fwoRec = this.getDataRecord("FWO_", 1);
            if (fwoRec == null) {
                throw new UnsupportedChromatogramFormatException("No FWO_ (1) record in ABIF file, therefore no trace data");
            }
            fwo_[0] = (char)(fwoRec.dataRecord >>> 24 & 0xFFL);
            fwo_[1] = (char)(fwoRec.dataRecord >>> 16 & 0xFFL);
            fwo_[2] = (char)(fwoRec.dataRecord >>> 8 & 0xFFL);
            fwo_[3] = (char)(fwoRec.dataRecord & 0xFFL);
            ABIFChromatogram.this.clearTraces();
            for (int i = 0; i < 4; ++i) {
                Symbol sym;
                try {
                    sym = ABIFParser.decodeDNAToken(fwo_[i]);
                }
                catch (IllegalSymbolException ise) {
                    throw new UnsupportedChromatogramFormatException("An unexpected character (" + fwo_[i] + ") was found in the FWO_ tag.  Parsing cannot continue.");
                }
                if (!(sym instanceof AtomicSymbol)) {
                    throw new UnsupportedChromatogramFormatException("An unexpected character (" + fwo_[i] + ") was found in the FWO_ tag.  Parsing cannot continue.");
                }
                this.parseTrace((AtomicSymbol)sym, i + 9);
            }
            this.parseBaseCalls();
            ((RandomAccessFile)((Object)this.getDataAccess())).close();
        }

        private void parseTrace(AtomicSymbol sym, int whichData) throws IOException, UnsupportedChromatogramFormatException {
            ABIFParser.TaggedDataRecord dataPtr = this.getDataRecord("DATA", whichData);
            if (dataPtr.numberOfElements > Integer.MAX_VALUE) {
                throw new UnsupportedChromatogramFormatException("Chromatogram has more than 2147483647 trace samples -- can't handle it");
            }
            int count = (int)dataPtr.numberOfElements;
            int[] trace = new int[count];
            int max = -1;
            ABIFChromatogram.this.setBits(8 * dataPtr.elementLength);
            if (dataPtr.elementLength == 2) {
                byte[] shortArray = dataPtr.offsetData;
                int i = 0;
                for (int s = 0; s < shortArray.length; s += 2) {
                    trace[i] = (short)(shortArray[s] << 8 | shortArray[s + 1] & 0xFF) & 0xFFFF;
                    max = Math.max(trace[i++], max);
                }
            } else if (dataPtr.elementLength == 1) {
                byte[] byteArray = dataPtr.offsetData;
                for (int i = 0; i < byteArray.length; ++i) {
                    trace[i] = byteArray[i] & 0xFF;
                    max = Math.max(trace[i], max);
                }
            } else {
                throw new UnsupportedChromatogramFormatException("Only 8- and 16-bit trace samples are supported");
            }
            try {
                ABIFChromatogram.this.setTrace(sym, trace, max);
            }
            catch (IllegalSymbolException ise) {
                throw new BioError("Can't happen", ise);
            }
        }

        private void parseBaseCalls() throws IOException, UnsupportedChromatogramFormatException {
            byte[] byteArray;
            IntegerAlphabet integerAlphabet;
            ABIFParser.TaggedDataRecord offsetsPtr = this.getDataRecord("PLOC", 1);
            ABIFParser.TaggedDataRecord basesPtr = this.getDataRecord("PBAS", 1);
            if (offsetsPtr.numberOfElements != basesPtr.numberOfElements) {
                throw new BioError("PLOC and PBAS are different lengths.  Can't proceed.");
            }
            if (offsetsPtr.numberOfElements > Integer.MAX_VALUE) {
                throw new UnsupportedChromatogramFormatException("Chromatogram has more than 2147483647 base calls -- can't handle it");
            }
            int count = (int)offsetsPtr.numberOfElements;
            ArrayList<Symbol> dna = new ArrayList<Symbol>(count);
            ArrayList<IntegerAlphabet.IntegerSymbol> offsets = new ArrayList<IntegerAlphabet.IntegerSymbol>(count);
            if (offsetsPtr.elementLength == 2) {
                byte[] shortArray = offsetsPtr.offsetData;
                integerAlphabet = IntegerAlphabet.getInstance();
                for (int s = 0; s < shortArray.length; s += 2) {
                    offsets.add(integerAlphabet.getSymbol((short)(shortArray[s] << 8 | shortArray[s + 1] & 0xFF) & 0xFFFF));
                }
            } else if (offsetsPtr.elementLength == 1) {
                byteArray = offsetsPtr.offsetData;
                integerAlphabet = IntegerAlphabet.getInstance();
                for (int i = 0; i < byteArray.length; ++i) {
                    offsets.add(integerAlphabet.getSymbol(byteArray[i] & 0xFF));
                }
            } else {
                throw new IllegalStateException("Only 8- and 16-bit trace samples are supported");
            }
            try {
                byteArray = basesPtr.offsetData;
                for (int i = 0; i < byteArray.length; ++i) {
                    dna.add(ABIFParser.decodeDNAToken((char)byteArray[i]));
                }
            }
            catch (IllegalSymbolException ise) {
                throw new BioError("Can't happen", ise);
            }
            try {
                SmallMap baseCalls = new SmallMap(2);
                baseCalls.put(Chromatogram.DNA, ABIFChromatogram.this.createImmutableSymbolList(DNATools.getDNA(), dna));
                baseCalls.put(Chromatogram.OFFSETS, ABIFChromatogram.this.createImmutableSymbolList(IntegerAlphabet.getInstance(), offsets));
                ABIFChromatogram.this.setBaseCallAlignment(ABIFChromatogram.this.createImmutableAlignment(baseCalls));
            }
            catch (IllegalAlphabetException iae) {
                throw new BioError("Can't happen", iae);
            }
            catch (IllegalSymbolException ise) {
                throw new BioError("Can't happen", ise);
            }
        }
    }
}

