/*
 * Decompiled with CFR 0.152.
 */
package com.jmatio.types;

import com.jmatio.types.ByteStorageSupport;
import com.jmatio.types.GenericArrayCreator;
import com.jmatio.types.MLArray;
import java.nio.ByteBuffer;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MLNumericArray<T extends Number>
extends MLArray
implements GenericArrayCreator<T>,
ByteStorageSupport<T> {
    private ByteBuffer real = ByteBuffer.allocate(this.getSize() * this.getBytesAllocated());
    private ByteBuffer imaginary;
    private final byte[] bytes;

    public MLNumericArray(String string, int[] nArray, int n, int n2) {
        super(string, nArray, n, n2);
        if (this.isComplex()) {
            this.imaginary = ByteBuffer.allocate(this.getSize() * this.getBytesAllocated());
        }
        this.bytes = new byte[this.getBytesAllocated()];
    }

    public MLNumericArray(String string, int n, T[] TArray, int n2) {
        this(string, new int[]{n2, TArray.length / n2}, n, 0);
        for (int i = 0; i < TArray.length; ++i) {
            this.set(TArray[i], i);
        }
    }

    public T getReal(int n, int n2) {
        return this.getReal(this.getIndex(n, n2));
    }

    public T getReal(int n) {
        return this._get(this.real, n);
    }

    public void setReal(T t, int n, int n2) {
        this.setReal(t, this.getIndex(n, n2));
    }

    public void setReal(T t, int n) {
        this._set(this.real, t, n);
    }

    public void setReal(T[] TArray) {
        if (TArray.length != this.getSize()) {
            throw new IllegalArgumentException("Matrix dimensions do not match. " + this.getSize() + " not " + TArray.length);
        }
        System.arraycopy(TArray, 0, this.real, 0, TArray.length);
    }

    public void setImaginary(T t, int n, int n2) {
        this.setImaginary(t, this.getIndex(n, n2));
    }

    public void setImaginary(T t, int n) {
        if (this.isComplex()) {
            this._set(this.imaginary, t, n);
        }
    }

    public T getImaginary(int n, int n2) {
        return this.getImaginary(this.getIndex(n, n2));
    }

    public T getImaginary(int n) {
        return this._get(this.imaginary, n);
    }

    public void set(T t, int n, int n2) {
        if (this.isComplex()) {
            throw new IllegalStateException("Cannot use this method for Complex matrices");
        }
        this.setReal(t, n, n2);
    }

    public void set(T t, int n) {
        if (this.isComplex()) {
            throw new IllegalStateException("Cannot use this method for Complex matrices");
        }
        this.setReal(t, n);
    }

    public T get(int n, int n2) {
        if (this.isComplex()) {
            throw new IllegalStateException("Cannot use this method for Complex matrices");
        }
        return this.getReal(n, n2);
    }

    public T get(int n) {
        if (this.isComplex()) {
            throw new IllegalStateException("Cannot use this method for Complex matrices");
        }
        return this._get(this.real, n);
    }

    public void set(T[] TArray) {
        if (this.isComplex()) {
            throw new IllegalStateException("Cannot use this method for Complex matrices");
        }
        this.setReal((Number[])TArray);
    }

    private int getByteOffset(int n) {
        return n * this.getBytesAllocated();
    }

    protected T _get(ByteBuffer byteBuffer, int n) {
        byteBuffer.position(this.getByteOffset(n));
        byteBuffer.get(this.bytes, 0, this.bytes.length);
        return this.buldFromBytes(this.bytes);
    }

    protected void _set(ByteBuffer byteBuffer, T t, int n) {
        byteBuffer.position(this.getByteOffset(n));
        byteBuffer.put(this.getByteArray(t));
    }

    public void putImaginaryByteBuffer(ByteBuffer byteBuffer) {
        if (!this.isComplex()) {
            throw new RuntimeException("Array is not complex");
        }
        this.imaginary.rewind();
        this.imaginary.put(byteBuffer);
    }

    public ByteBuffer getImaginaryByteBuffer() {
        return this.imaginary;
    }

    public void putRealByteBuffer(ByteBuffer byteBuffer) {
        this.real.rewind();
        this.real.put(byteBuffer);
    }

    public ByteBuffer getRealByteBuffer() {
        return this.real;
    }

    @Override
    public String contentToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.name + " = \n");
        if (this.getSize() > 1000) {
            stringBuffer.append("Cannot display variables with more than 1000 elements.");
            return stringBuffer.toString();
        }
        for (int i = 0; i < this.getM(); ++i) {
            stringBuffer.append("\t");
            for (int j = 0; j < this.getN(); ++j) {
                stringBuffer.append(this.getReal(i, j));
                if (this.isComplex()) {
                    stringBuffer.append("+" + this.getImaginary(i, j));
                }
                stringBuffer.append("\t");
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof MLNumericArray) {
            boolean bl;
            boolean bl2 = bl = MLNumericArray.directByteBufferEquals(this.real, ((MLNumericArray)object).real) && Arrays.equals(this.dims, ((MLNumericArray)object).dims);
            if (this.isComplex() && bl) {
                bl &= MLNumericArray.directByteBufferEquals(this.imaginary, ((MLNumericArray)object).imaginary);
            }
            return bl;
        }
        return super.equals(object);
    }

    private static boolean directByteBufferEquals(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        if (byteBuffer == byteBuffer2) {
            return true;
        }
        if (byteBuffer == null || byteBuffer2 == null) {
            return false;
        }
        byteBuffer.rewind();
        byteBuffer2.rewind();
        int n = byteBuffer.remaining();
        if (byteBuffer2.remaining() != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (byteBuffer.get() == byteBuffer2.get()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void dispose() {
        if (this.real != null) {
            this.real.clear();
        }
        if (this.imaginary != null) {
            this.real.clear();
        }
    }
}

