package org.baderlab.pdzsvm.evaluation;

/**
 * Copyright (c) 2010 University of Toronto
 * Code written by: Shirley Hui
 * Authors: Shirley Hui, Gary Bader
 *
 * This file is part of PDZSVM.
 *
 * PDZSVM is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * PDZSVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  The software and
 * documentation provided hereunder is on an "as is" basis, and the
 * University of Toronto has no obligations to provide maintenance,
 * support, updates, enhancements or modifications.  In no event shall
 * the University of Toronto be liable to any party for direct, indirect,
 * special, incidental or consequential damages, including lost profits,
 * arising out of the use of this software and its documentation, even if
 * the University of Toronto has been advised of the possibility of such
 * damage. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with PDZSVM.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Represents a predictor prediction
 */
public class Prediction
{
    private double pred;
    private int actual;
    private double decValue;
    public String name;
    public String domainSeqFull;
    public String peptideSeq;
    public String organismShort;
    public String methodShort;
    public double fullSeqSim;
    public double bindingSiteSeqSim;
    public int numMismatch;
    public Prediction(double pred, int actual, double decValue)
    {
        this.pred = pred;
        this.actual = actual;
        this.decValue = decValue;
        //System.out.println(toString());
    }
    public Prediction(double pred, int actual, double decValue,
                      String name,
                      String domainSeqFull,
                      String peptideSeq,
                      String organismShort,
                      String methodShort)
    {
        this.pred = pred;
        this.actual = actual;
        this.decValue = decValue;
        this.name = name;
        this.domainSeqFull = domainSeqFull;
        this.peptideSeq = peptideSeq;
        this.organismShort = organismShort;
        this.methodShort = methodShort;
    }

    public double getPrediction()
    {
        return pred;
    }
    public int getActual()
    {
        return actual;
    }
    public double getDecValue()
    {
        return decValue;
    }
    public void setDecValue(double decValue)
    {
        this.decValue =decValue;
    }

    public String toString()
    {
        String retString = name + "\t" + domainSeqFull +"\t"+ peptideSeq+ "\t" + pred + "\t"+actual+"\t"+decValue;
        return retString;

    }
    
}
