package org.baderlab.pdzsvm.analysis;

import org.baderlab.pdzsvm.data.DataLoader;
import org.baderlab.pdzsvm.data.manager.DataFileManager;

import java.util.List;
import java.util.ArrayList;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.File;

import org.baderlab.pdzsvm.evaluation.Evaluation;
import org.baderlab.pdzsvm.utils.Constants;
import org.baderlab.pdzsvm.utils.PDZSVMUtils;

import weka.core.Utils;
import weka.core.Instances;
import org.baderlab.pdzsvm.predictor.Predictor;
import org.baderlab.pdzsvm.predictor.svm.ContactMapSVMPredictor;
import libsvm.svm_parameter;

/**
 * Copyright (c) 2010 University of Toronto
 * Code written by: Shirley Hui
 * Authors: Shirley Hui, Gary Bader
 *
 * This file is part of PDZSVM.
 *
 * PDZSVM is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * PDZSVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  The software and
 * documentation provided hereunder is on an "as is" basis, and the
 * University of Toronto has no obligations to provide maintenance,
 * support, updates, enhancements or modifications.  In no event shall
 * the University of Toronto be liable to any party for direct, indirect,
 * special, incidental or consequential damages, including lost profits,
 * arising out of the use of this software and its documentation, even if
 * the University of Toronto has been advised of the possibility of such
 * damage. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with PDZSVM.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * This file compares SVMs trained using different peptide redundancy reduction
 * thresholds as discussed in the Supplementary Information.  Produces R files
 * for Fig. 1 in the Supplementary Information.
 */
public class ComparePeptideRedundancy {
    private String testName;
    private int testNum ;
    private String dirName ;
    private boolean print = true;
    private List posTestProfileList;
    private List negTestProfileList;
    private DataLoader dl;
    private String parentDir = "/PeptideRedundancy";

    public void loadTests(int test)
    {
        dl.clearTest();
        if (test==5)
        {
            dl.loadMouseTest(Constants.MOUSE_ORPHAN);  testName = "MOUSE ORPHAN PM";
            dirName = "/PMMouseOrphanG";

        }
        else if (test==6)
        {
            dl.loadWormTest(Constants.PROTEIN_MICROARRAY); testName ="WORM PM";
            dirName = "/PMWormG";

        }
        else if (test==7)
        {
            dl.loadFlyTest(); testName = "FLY PM";
            dirName = "/PMFlyG";

        }

        posTestProfileList = dl.getPosTestProfileList();
        negTestProfileList= dl.getNegTestProfileList();

        System.out.println("\tTEST IS: " + testName);


    }
    public ComparePeptideRedundancy(int test)
    {
        dl = new DataLoader();
        testNum = test;
    }
    public static  void main(String[] args)
    {
        ComparePeptideRedundancy cp = new ComparePeptideRedundancy(Integer.parseInt(args[0]));
        cp.compare();

    }

    private void print(String output, String fileName)
    {
        System.out.println("\tWriting to " + DataFileManager.OUTPUT_ROOT_DIR + parentDir + dirName + "/" + fileName + "...");
        
        try
        {
            BufferedWriter bw = new BufferedWriter(new FileWriter(new File(DataFileManager.OUTPUT_ROOT_DIR
                    + parentDir + dirName + "/" + fileName)));
            bw.write(output);
            bw.close();
        }
        catch(Exception e)
        {
            System.out.println("Exception: " + e);
        }
    }

    private void compare()
    {
        List globalSVMCMPredictions1 = new ArrayList();
        List globalSVMCMPredictions2 = new ArrayList();
        List globalSVMCMPredictions3 = new ArrayList();
        List globalSVMCMPredictions4 = new ArrayList();
        List globalSVMCMPredictions5 = new ArrayList();

        loadTests(testNum);

        globalSVMCMPredictions1.addAll(runSVM(1));
        globalSVMCMPredictions2.addAll(runSVM(2));
        globalSVMCMPredictions3.addAll(runSVM(3));
        globalSVMCMPredictions4.addAll(runSVM(4));
        globalSVMCMPredictions5.addAll(runSVM(5));


        List predList =new ArrayList();
        List rocAUCList = new ArrayList();
        List prAUCList = new ArrayList();
        List aucLabelList = new ArrayList();

        String predictorName = "PeptideSim1";
        aucLabelList.add(predictorName);
        Evaluation evalCM1 = evaluate(globalSVMCMPredictions1, predictorName);
        double rocAUC = Double.parseDouble(Utils.doubleToString(evalCM1.getROCAUC(),3));
        rocAUCList.add(rocAUC);
        double prAUC = Double.parseDouble(Utils.doubleToString(evalCM1.getPRAUC(),3));
        prAUCList.add(prAUC);
        Instances instCM1 = evalCM1.getCurve(1);
        predList.add(instCM1);
        if (print)
        {
            List predictions = new ArrayList();
            predictions.add(globalSVMCMPredictions1);
            StringBuffer rString = PDZSVMUtils.toRString(predictions);
            print(rString.toString(),"test_" + predictorName.replace(' ','_') + "_Load.r");
        }

        predictorName = "PeptideSim2";
        aucLabelList.add(predictorName);
        Evaluation evalCM2 = evaluate(globalSVMCMPredictions2, predictorName);
        rocAUC = Double.parseDouble(Utils.doubleToString(evalCM2.getROCAUC(),3));
        rocAUCList.add(rocAUC);
        prAUC = Double.parseDouble(Utils.doubleToString(evalCM2.getPRAUC(),3));
        prAUCList.add(prAUC);
        Instances instCM2 = evalCM2.getCurve(1);
        predList.add(instCM2);
        if (print)
        {
            List predictions = new ArrayList();
            predictions.add(globalSVMCMPredictions2);

            StringBuffer rString = PDZSVMUtils.toRString(predictions);
            print(rString.toString(),"test_" + predictorName.replace(' ','_') + "_Load.r");
        }
        predictorName = "PeptideSim3";
        aucLabelList.add(predictorName);
        Evaluation evalCM3 = evaluate(globalSVMCMPredictions3, predictorName);
        rocAUC = Double.parseDouble(Utils.doubleToString(evalCM3.getROCAUC(),3));
        rocAUCList.add(rocAUC);
        prAUC = Double.parseDouble(Utils.doubleToString(evalCM3.getPRAUC(),3));
        prAUCList.add(prAUC);
        Instances instCM3 = evalCM3.getCurve(1);
        predList.add(instCM3);
        if (print)
        {
            List predictions = new ArrayList();
            predictions.add(globalSVMCMPredictions3);

            StringBuffer rString = PDZSVMUtils.toRString(predictions);
            print(rString.toString(),"test_" + predictorName.replace(' ','_') + "_Load.r");
        }
        predictorName = "PeptideSim4";
        aucLabelList.add(predictorName);
        Evaluation evalCM4 = evaluate(globalSVMCMPredictions4, predictorName);
        rocAUC = Double.parseDouble(Utils.doubleToString(evalCM4.getROCAUC(),3));
        rocAUCList.add(rocAUC);
        prAUC = Double.parseDouble(Utils.doubleToString(evalCM4.getPRAUC(),3));
        prAUCList.add(prAUC);
        Instances instCM4 = evalCM4.getCurve(1);
        predList.add(instCM4);
        if (print)
        {
            List predictions = new ArrayList();
            predictions.add(globalSVMCMPredictions4);

            StringBuffer rString = PDZSVMUtils.toRString(predictions);
            print(rString.toString(),"test_" + predictorName.replace(' ','_') + "_Load.r");
        }
        predictorName = "PeptideSim5";
        aucLabelList.add(predictorName);
        Evaluation evalCM5 = evaluate(globalSVMCMPredictions5, predictorName);
        rocAUC = Double.parseDouble(Utils.doubleToString(evalCM5.getROCAUC(),3));
        rocAUCList.add(rocAUC);
        prAUC = Double.parseDouble(Utils.doubleToString(evalCM5.getPRAUC(),3));
        prAUCList.add(prAUC);
        Instances instCM5 = evalCM5.getCurve(1);
        predList.add(instCM5);
        if (print)
        {
            List predictions = new ArrayList();
            predictions.add(globalSVMCMPredictions5);

            StringBuffer rString = PDZSVMUtils.toRString(predictions);
            print(rString.toString(),"test_" + predictorName.replace(' ','_') + "_Load.r");
        }
        Predictor.plotCurves(predList, rocAUCList, prAUCList, aucLabelList, testName);

    }

    private Evaluation evaluate(List predictionList, String predictorName)
    {
        Evaluation eval = new Evaluation(predictionList);

        System.out.println("=== Summary " +testName+ " ("+predictorName+") ===");
        System.out.println(eval.toString());
        return eval;
    }

    private List runSVM( int numPeptideSim)
    {
        DataLoader dl = new DataLoader();
        dl.loadMouseChenTrain();
        svm_parameter svmParams = new svm_parameter();
        svmParams.setDefaults();

        dl.loadHumanTrain(Constants.PWM, "", numPeptideSim);
         double C = 2; double g = 4;
        if (numPeptideSim ==1)
        {
             g =3 ;
        }
        else if (numPeptideSim ==2)
        {
        }
        else if (numPeptideSim == 3)
        {
        }
        else if (numPeptideSim == 4)
        {
            g = 3;
            C = 5;
        }
        else if (numPeptideSim ==5)
        {
        }

        List posTrainProfileList = dl.getPosTrainProfileList();
        List negTrainProfileList = dl.getNegTrainProfileList();
        System.out.println("\tSVM, [g,C] = ["+g+","+C+"])");
        svmParams.C = Math.exp(C);
        svmParams.gamma = Math.exp(-Math.log(2)-g);

        svmParams.data_encoding = svm_parameter.CONTACTMAP2020;

        ContactMapSVMPredictor p =new ContactMapSVMPredictor(
                posTrainProfileList,
                negTrainProfileList,
                svmParams);
        p.train();
        List predictions = p.predict(posTestProfileList, negTestProfileList);

        return predictions;

    }

}
