package org.baderlab.pdzsvm.predictor;

import java.util.List;
import java.util.ArrayList;
import java.util.HashMap;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.File;
import java.awt.*;

import org.baderlab.brain.ProteinProfile;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.XYPlot;
import org.baderlab.pdzsvm.evaluation.Evaluation;

import javax.swing.*;

import org.baderlab.pdzsvm.validation.ValidationParameters;
import org.baderlab.pdzsvm.utils.PDZSVMUtils;

/**
 * Copyright (c) 2010 University of Toronto
 * Code written by: Shirley Hui
 * Authors: Shirley Hui, Gary Bader
 *
 * This file is part of PDZSVM.
 *
 * PDZSVM is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * PDZSVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  The software and
 * documentation provided hereunder is on an "as is" basis, and the
 * University of Toronto has no obligations to provide maintenance,
 * support, updates, enhancements or modifications.  In no event shall
 * the University of Toronto be liable to any party for direct, indirect,
 * special, incidental or consequential damages, including lost profits,
 * arising out of the use of this software and its documentation, even if
 * the University of Toronto has been advised of the possibility of such
 * damage. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with PDZSVM.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Generic predictor class which all new predictors should implement
 */
public abstract class Predictor
{
    protected List allTrainProfileList;
    protected List predictionList;
    protected List posTrainProfileList;
    protected List negTrainProfileList;
    protected String predictorName;
    protected boolean print;

    public Predictor(List posTrainProfileList, List negTrainProfileList)
    {
        allTrainProfileList = PDZSVMUtils.allProfileList(posTrainProfileList, negTrainProfileList);
        this.posTrainProfileList = posTrainProfileList;
        this.negTrainProfileList = negTrainProfileList;
        this.predictionList = new ArrayList();

    }
    public String getPredictorName()
    {
        return predictorName;
    }
    public List getPredictions()
    {
        return predictionList;
    }

    public static void print(String output, String outputPathFileName)
    {
        System.out.println("\tPrinting to: " + outputPathFileName);
        try
        {
            BufferedWriter bw = new BufferedWriter(new FileWriter(new File(outputPathFileName)));
            bw.write(output);
            bw.close();
        }
        catch(Exception e)
        {
            System.out.println("Exception: " + e);
        }
    }

    public static void plotCurves(List predList, List rocAUCList, List prAUCList, List aucLabelList, String title)
    {
        int size = 400;
        XYPlot rocPlot = Evaluation.getROCPlot(predList,rocAUCList,aucLabelList, 1);
        XYPlot prPlot = Evaluation.getPRPlot(predList,prAUCList, aucLabelList, 1);

        JFreeChart rocChart = new JFreeChart(title + " ROC", JFreeChart.DEFAULT_TITLE_FONT, rocPlot, true);
        ChartPanel rocChartPanel = new ChartPanel(rocChart, true, true, true, true, true);
        rocChartPanel.setPreferredSize(new java.awt.Dimension(size, size));

        JFreeChart prChart = new JFreeChart(title + " PR", JFreeChart.DEFAULT_TITLE_FONT, prPlot, true);
        ChartPanel prChartPanel = new ChartPanel(prChart, true, true, true, true, true);
        prChartPanel.setPreferredSize(new java.awt.Dimension(size, size));


        JFrame f = new JFrame("");
        f.setLayout(new FlowLayout());
        f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        f.add(rocChartPanel);
        f.add(prChartPanel);
        f.pack();
        f.setVisible(true);
    }
    public abstract void train();
    
    public abstract List predict(List posTestProfileList, List negTestProfileList);

    public abstract HashMap kFoldCrossValidation(ValidationParameters validParams);

    public abstract HashMap leaveOutCrossValidation(ValidationParameters validParams);
}
