package org.baderlab.pdzsvm.data;

import org.baderlab.pdzsvm.utils.Constants;


/**
 * Copyright (c) 2010 University of Toronto
 * Code written by: Shirley Hui
 * Authors: Shirley Hui, Gary Bader
 *
 * This file is part of PDZSVM.
 *
 * PDZSVM is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * PDZSVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  The software and
 * documentation provided hereunder is on an "as is" basis, and the
 * University of Toronto has no obligations to provide maintenance,
 * support, updates, enhancements or modifications.  In no event shall
 * the University of Toronto be liable to any party for direct, indirect,
 * special, incidental or consequential damages, including lost profits,
 * arising out of the use of this software and its documentation, even if
 * the University of Toronto has been advised of the possibility of such
 * damage. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with PDZSVM.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * One datum represents one domain peptide interaction.  These are stored as a list
 * and other data structures in the Data object.
 */
public class Datum
{
    public String name = "";
    public String expMethod = "";
    public String organism = "";
    public String posneg = "";
    public int domainNum = -1;
    public int peptideNum = -1;
    private int hashCode = 0;

    public Datum(String name, String expMethod, String organism, String posneg, int domainNum, int peptideNum)
    {
        this.name = name;
        this.expMethod = expMethod;

        if ( organism.equalsIgnoreCase(Constants.HUMAN_STRING) || organism.equalsIgnoreCase(Constants.HUMAN))
            organism = Constants.HUMAN;
        else if (organism.equalsIgnoreCase(Constants.WORM_STRING)|| organism.equalsIgnoreCase(Constants.WORM))
            organism = Constants.WORM;
        else if (organism.equalsIgnoreCase(Constants.MOUSE_STRING)|| organism.equalsIgnoreCase(Constants.MOUSE))
            organism = Constants.MOUSE;
        else if (organism.equalsIgnoreCase(Constants.FLY_STRING)|| organism.equalsIgnoreCase(Constants.FLY))
            organism = Constants.FLY;
        else
            organism = "U";
        this.organism = organism;

        if (posneg.equalsIgnoreCase(Constants.CLASS_YES) || posneg.equalsIgnoreCase("Yes") || posneg.equalsIgnoreCase("Y"))
            this.posneg = Constants.CLASS_YES;
        else
            this.posneg = Constants.CLASS_NO;
        this.domainNum = domainNum;
        this.peptideNum = peptideNum;
        this.hashCode = this.hashCode();
    }


    public int getHashCode()
    {
        return hashCode;
    }
    
    public String toString()
    {
        String theString = name+ "\t" + expMethod + "\t"  + organism  +  "\t" + domainNum + "\t" + peptideNum+ "\t" + posneg;
        return theString;
    }

    public int classToInt()
    {
        if (posneg.equals(Constants.CLASS_YES))
            return 1;
        else
            return -1;
    }

    public void setDomainNum(int domainNum)
    {
        this.domainNum = domainNum;
    }

    public void setPeptideNum(int peptideNum)
    {
        this.peptideNum = peptideNum;                                        
    }
}
