package org.baderlab.pdzsvm.encoding;

import java.util.List;
import java.util.ArrayList;
import java.util.Arrays;

/**
 * Copyright (c) 2010 University of Toronto
 * Code written by: Shirley Hui
 * Authors: Shirley Hui, Gary Bader
 *
 * This file is part of PDZSVM.
 *
 * PDZSVM is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * PDZSVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  The software and
 * documentation provided hereunder is on an "as is" basis, and the
 * University of Toronto has no obligations to provide maintenance,
 * support, updates, enhancements or modifications.  In no event shall
 * the University of Toronto be liable to any party for direct, indirect,
 * special, incidental or consequential damages, including lost profits,
 * arising out of the use of this software and its documentation, even if
 * the University of Toronto has been advised of the possibility of such
 * damage. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with PDZSVM.  If not, see <http://www.gnu.org/licenses/>.
 */
/**
 * Parent class for features
 * TODO: Should be updated to properly support Double and String features.
 */
public class Features {

    protected List featureValues = new ArrayList();
    private double[] doubleFeatureValues;
    private String unDelimitedString = "";

    public Features()
    {
    }

    // comma delimited string of objects (string or numbers)
    public void addFeatures(String featuresString)
    {
        String[] featuresArray = featuresString.split(",");
        addFeatureValues(Arrays.asList(featuresArray));

    }
    /** IF POSSIBLE **/
        private void toDoubleArray()
        {
            doubleFeatureValues = new double[featureValues.size()];
            for (int i = 0; i < featureValues.size();i++)
            {
                try
                {
                    Object featureObject = featureValues.get(i);
                    double doubleFeature = 0.0;
                    if (featureObject.getClass() == Double.class)
                    {
                        Double feature = (Double)featureValues.get(i);
                        doubleFeature = feature.doubleValue();
                    }
                    else if (featureObject.getClass() == Integer.class)
                    {
                        Integer feature = (Integer)featureValues.get(i);
                        doubleFeature = (double)feature.intValue();

                    }
                    else if (featureObject.getClass() == String.class)
                    {
                        String feature = (String) featureValues.get(i);
                        doubleFeature = Double.parseDouble(feature);
                    }
                    //System.out.print("," + doubleFeature);

                    doubleFeatureValues[i] = doubleFeature;
                }
                catch(Exception e)
                {
                    //System.out.println("Exception: " + e);

                    //e.printStackTrace();
                }

            }
            //System.out.println();

        }


        public void addFeatureValues(List featureValues)
        {
            // convert to double array representation if possible
            this.featureValues.addAll(featureValues);
            toDoubleArray();
            toUndelimitedString();

        }
        public double[] getFeatureValuesAsDoubleArray()
        {
            return doubleFeatureValues;
        }
        public double getFeatureAsDouble(int index)
        {
            if (doubleFeatureValues.length >0)
                return doubleFeatureValues[index];
            else
                return Double.MAX_VALUE;

        }

        public String getFeatureValuesAsUndelimitedString()
        {
            return unDelimitedString;   
        }
        public static List scale(List featureList)
        {
            List scaledFeatureList = new ArrayList();
            for (int i =0; i < featureList.size();i++)
            {
                Features features = (Features)featureList.get(i);
                //List featureValues = features.getFeatureValues();
                double[] featureValues = features.getFeatureValuesAsDoubleArray();
                List scaledFeatureValues = new ArrayList();

                for (int j= 0; j < featureValues.length;j++)
                {
                    double featureValue = featureValues[j]/100;
                    scaledFeatureValues.add(featureValue);
                } // for
                Features scaledFeatures = new Features();
                scaledFeatures.addFeatureValues(scaledFeatureValues);
                scaledFeatureList.add(scaledFeatures);
            }  // for
            return scaledFeatureList;
        }

    public void addFeatures(Features features)
    {
        addFeatureValues(features.getFeatureValues());
    }

    public List getFeatureValues()
    {
        return featureValues;
    }

    public int numFeatures()
    {
        return featureValues.size();
    }

    public boolean isEmpty()
    {
        return featureValues.isEmpty();
    }

    public String toString()
    {
        String toString = "";

        if (!featureValues.isEmpty())
        {
            toString = featureValues.get(0).toString();
            for (int i =1;i < featureValues.size();i++)
            {
                toString = toString+ "," + featureValues.get(i).toString();
            }
        }
        return toString;
    }

    public String toUndelimitedString()
    {
        String toString = "";

        if (!featureValues.isEmpty())
        {
            toString = featureValues.get(0).toString();
            for (int i =1;i < featureValues.size();i++)
            {
                toString = toString+featureValues.get(i).toString();
            }
        }
        unDelimitedString = toString;
        return toString;
    }

    public boolean equals(Object f2)
    {
        if (f2.getClass() != Features.class)
            return false;
        else
        {
            return (this.toString().equals(((Features)f2).toString()));
        }
    }

    public int hashCode()
    {
        String featureString = toString();
        return featureString.hashCode();
    }

}
