/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui.icon;

import cytoscape.Cytoscape;
import cytoscape.visual.Arrow;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.ui.icon.VisualPropertyIcon;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public class ArrowIcon
extends VisualPropertyIcon {
    private static final Stroke EDGE_STROKE = new BasicStroke(6.0f, 2, 0);
    private static final Stroke EDGE_STROKE_SMALL = new BasicStroke(4.0f, 2, 0);
    protected Graphics2D g2d;
    private static final int DEF_L_PAD = 15;

    public ArrowIcon(Shape shape) {
        this(shape, 96, 32, ((Arrow)VisualPropertyType.EDGE_SRCARROW.getDefault(Cytoscape.getVisualMappingManager().getVisualStyle())).getShape().getName(), DEFAULT_ICON_COLOR);
    }

    public ArrowIcon(Shape shape, int width, int height, String name) {
        super(shape, width, height, name);
    }

    public ArrowIcon(Shape shape, int width, int height, String name, Color color) {
        super(shape, width, height, name, color);
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.g2d = (Graphics2D)g;
        this.g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.g2d.setColor(this.color);
        this.g2d.translate(this.leftPad, this.bottomPad);
        if (this.shape == null) {
            if (this.width < 20 || this.height < 20) {
                this.g2d.translate(-this.leftPad, -this.bottomPad);
                this.g2d.setStroke(EDGE_STROKE_SMALL);
                this.g2d.drawLine(3, c.getHeight() / 2, this.width / 2 + 10, c.getHeight() / 2);
                return;
            }
            this.g2d.translate(-this.leftPad, -this.bottomPad);
            return;
        }
        AffineTransform af = new AffineTransform();
        this.g2d.setStroke(new BasicStroke(2.0f));
        Rectangle2D bound = this.shape.getBounds2D();
        double minx = bound.getMinX();
        double miny = bound.getMinY();
        Shape newShape = this.shape;
        if (minx < 0.0) {
            af.setToTranslation(Math.abs(minx), 0.0);
            newShape = af.createTransformedShape(newShape);
        }
        if (miny < 0.0) {
            af.setToTranslation(0.0, Math.abs(miny));
            newShape = af.createTransformedShape(newShape);
        }
        double shapeWidth = newShape.getBounds2D().getWidth();
        double shapeHeight = newShape.getBounds2D().getHeight();
        double originalXYRatio = shapeWidth / shapeHeight;
        double xRatio = (double)(this.width / 3) / shapeWidth;
        double yRatio = (double)this.height / shapeHeight;
        af.setToScale(xRatio * originalXYRatio, yRatio);
        newShape = af.createTransformedShape(newShape);
        af.setToTranslation((double)this.width * 0.8 - newShape.getBounds2D().getCenterX(), (double)((this.height + 20) / 2) - newShape.getBounds2D().getCenterY());
        newShape = af.createTransformedShape(newShape);
        this.g2d.fill(newShape);
        if (this.width >= 20 && this.height >= 20) {
            this.g2d.setStroke(EDGE_STROKE);
            this.g2d.drawLine(15, (this.height + 20) / 2, (int)newShape.getBounds2D().getCenterX() - 2, (this.height + 20) / 2);
        }
        this.g2d.translate(-this.leftPad, -this.bottomPad);
        if (this.width < 20 || this.height < 20) {
            this.g2d.setStroke(EDGE_STROKE_SMALL);
            this.g2d.drawLine(3, c.getHeight() / 2, this.width / 2 + 10, c.getHeight() / 2);
        }
    }
}

