/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui.editors.continuous;

import cytoscape.Cytoscape;
import cytoscape.visual.LabelPosition;
import cytoscape.visual.LineStyle;
import cytoscape.visual.NodeShape;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.mappings.ContinuousMapping;
import cytoscape.visual.mappings.continuous.ContinuousMappingPoint;
import cytoscape.visual.ui.LabelPlacerGraphic;
import cytoscape.visual.ui.editors.continuous.EditorValueRangeTracer;
import cytoscape.visual.ui.editors.continuous.VizMapperTrackRenderer;
import cytoscape.visual.ui.icon.VisualPropertyIcon;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.JXMultiThumbSlider;
import org.jdesktop.swingx.multislider.Thumb;

public class DiscreteTrackRenderer
extends JComponent
implements VizMapperTrackRenderer {
    private final Font TITLE_FONT = new Font("SansSerif", 1, 12);
    private static final int ICON_SIZE = 32;
    private int SMALL_ICON_SIZE = 20;
    private static final Color ICON_COLOR = new Color(10, 100, 255, 200);
    private static int TRACK_HEIGHT = 70;
    private static final int THUMB_WIDTH = 12;
    private static final int V_PADDING = 20;
    private static int ARROW_BAR_Y_POSITION = TRACK_HEIGHT + 50;
    private Object below;
    private Object above;
    private VisualPropertyType type;
    private String title;
    private List<Object> rangeObjects;
    private Object lastObject;
    private List<String> rangeTooltips;
    private JXMultiThumbSlider slider;

    public DiscreteTrackRenderer(VisualPropertyType type, Object below, Object above) {
        this.below = below;
        this.above = above;
        this.type = type;
        this.title = type.isNodeProp() ? Cytoscape.getVisualMappingManager().getVisualStyle().getNodeAppearanceCalculator().getCalculator(type).getMapping(0).getControllingAttributeName() : Cytoscape.getVisualMappingManager().getVisualStyle().getEdgeAppearanceCalculator().getCalculator(type).getMapping(0).getControllingAttributeName();
        this.setBackground(Color.white);
        this.setForeground(Color.white);
    }

    public DiscreteTrackRenderer(Object lastRegionObject, ContinuousMapping cm) {
        this.rangeObjects = new ArrayList<Object>();
        this.rangeTooltips = new ArrayList<String>();
        this.lastObject = lastRegionObject;
        this.setBackground(Color.white);
        this.setForeground(Color.white);
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.paintComponent(g);
    }

    protected void paintComponent(Graphics gfx) {
        int iconLocY;
        int iconLocX;
        TRACK_HEIGHT = this.slider.getHeight() - 100;
        ARROW_BAR_Y_POSITION = TRACK_HEIGHT + 50;
        Graphics2D g = (Graphics2D)gfx;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int track_width = this.slider.getWidth() - 12;
        g.translate(6, 12);
        double minValue = EditorValueRangeTracer.getTracer().getMin(this.type);
        double maxValue = EditorValueRangeTracer.getTracer().getMax(this.type);
        double valueRange = EditorValueRangeTracer.getTracer().getRange(this.type);
        List stops = this.slider.getModel().getSortedThumbs();
        int numPoints = stops.size();
        float[] fractions = new float[numPoints];
        Object[] objectValues = new Object[numPoints];
        int i = 0;
        for (Thumb thumb : stops) {
            objectValues[i] = thumb.getObject();
            fractions[i] = thumb.getPosition();
            ++i;
        }
        g.setStroke(new BasicStroke(1.0f));
        g.setColor(Color.black);
        g.drawLine(0, ARROW_BAR_Y_POSITION, track_width, ARROW_BAR_Y_POSITION);
        Polygon arrow = new Polygon();
        arrow.addPoint(track_width, ARROW_BAR_Y_POSITION);
        arrow.addPoint(track_width - 20, ARROW_BAR_Y_POSITION - 8);
        arrow.addPoint(track_width - 20, ARROW_BAR_Y_POSITION);
        g.fill(arrow);
        g.setColor(Color.gray);
        g.drawLine(0, ARROW_BAR_Y_POSITION, 15, ARROW_BAR_Y_POSITION - 30);
        g.drawLine(15, ARROW_BAR_Y_POSITION - 30, 25, ARROW_BAR_Y_POSITION - 30);
        g.setFont(SMALL_FONT);
        g.drawString("Min=" + minValue, 28, ARROW_BAR_Y_POSITION - 25);
        g.drawLine(track_width, ARROW_BAR_Y_POSITION, track_width - 15, ARROW_BAR_Y_POSITION + 30);
        g.drawLine(track_width - 15, ARROW_BAR_Y_POSITION + 30, track_width - 25, ARROW_BAR_Y_POSITION + 30);
        String maxStr = "Max=" + maxValue;
        int strWidth = SwingUtilities.computeStringWidth(g.getFontMetrics(), maxStr);
        g.drawString(maxStr, track_width - strWidth - 26, ARROW_BAR_Y_POSITION + 35);
        g.setFont(SMALL_FONT);
        g.setColor(Color.black);
        strWidth = SwingUtilities.computeStringWidth(g.getFontMetrics(), this.title);
        g.drawString(this.title, track_width / 2 - strWidth / 2, ARROW_BAR_Y_POSITION + 35);
        if (numPoints == 0) {
            g.setColor(BORDER_COLOR);
            g.setStroke(new BasicStroke(1.5f));
            g.drawRect(0, 5, track_width, TRACK_HEIGHT);
            return;
        }
        g.setStroke(new BasicStroke(1.0f));
        g.setColor(Color.white);
        g.fillRect(0, 5, track_width, TRACK_HEIGHT);
        this.rangeObjects = DiscreteTrackRenderer.buildIconArray(stops.size() + 1);
        int newX = 0;
        Point2D.Float p1 = new Point2D.Float(0.0f, 5.0f);
        Point2D.Float p2 = new Point2D.Float(0.0f, 5.0f);
        for (i = 0; i < stops.size(); ++i) {
            newX = (int)((float)track_width * (fractions[i] / 100.0f));
            ((Point2D)p2).setLocation(newX, 5.0);
            g.setColor(Color.black);
            g.setStroke(STROKE1);
            g.drawLine(newX, 5, newX, TRACK_HEIGHT + 4);
            g.setColor(Color.DARK_GRAY);
            g.setFont(new Font("SansSerif", 1, 10));
            Float curPositionValue = Float.valueOf(((Number)((double)(fractions[i] / 100.0f) * valueRange + minValue)).floatValue());
            String valueString = String.format("%.5f", curPositionValue);
            int flipLimit = 90;
            int borderVal = track_width - newX;
            if (i % 2 == 0 && flipLimit < borderVal) {
                g.drawLine(newX, ARROW_BAR_Y_POSITION, newX + 20, ARROW_BAR_Y_POSITION - 15);
                g.drawLine(newX + 20, ARROW_BAR_Y_POSITION - 15, newX + 30, ARROW_BAR_Y_POSITION - 15);
                g.setColor(Color.black);
                g.drawString(valueString, newX + 33, ARROW_BAR_Y_POSITION - 11);
            } else if (i % 2 == 1 && flipLimit < borderVal) {
                g.drawLine(newX, ARROW_BAR_Y_POSITION, newX + 20, ARROW_BAR_Y_POSITION + 15);
                g.drawLine(newX + 20, ARROW_BAR_Y_POSITION + 15, newX + 30, ARROW_BAR_Y_POSITION + 15);
                g.setColor(Color.black);
                g.drawString(valueString, newX + 33, ARROW_BAR_Y_POSITION + 19);
            } else if (i % 2 == 0 && flipLimit >= borderVal) {
                g.drawLine(newX, ARROW_BAR_Y_POSITION, newX - 20, ARROW_BAR_Y_POSITION - 15);
                g.drawLine(newX - 20, ARROW_BAR_Y_POSITION - 15, newX - 30, ARROW_BAR_Y_POSITION - 15);
                g.setColor(Color.black);
                g.drawString(valueString, newX - 90, ARROW_BAR_Y_POSITION - 11);
            } else {
                g.drawLine(newX, ARROW_BAR_Y_POSITION, newX - 20, ARROW_BAR_Y_POSITION + 15);
                g.drawLine(newX - 20, ARROW_BAR_Y_POSITION + 15, newX - 30, ARROW_BAR_Y_POSITION + 15);
                g.setColor(Color.black);
                g.drawString(valueString, newX - 90, ARROW_BAR_Y_POSITION + 19);
            }
            g.setColor(Color.black);
            g.fillOval(newX - 3, ARROW_BAR_Y_POSITION - 3, 6, 6);
            iconLocX = newX - ((newX - (int)((Point2D)p1).getX()) / 2 + 16);
            iconLocY = TRACK_HEIGHT / 2 - 16 + 5;
            if (i == 0) {
                this.drawIcon(this.below, g, iconLocX, iconLocY, 32);
            } else {
                this.drawIcon(objectValues[i], g, iconLocX, iconLocY, 32);
            }
            p1.setLocation(p2);
        }
        ((Point2D)p2).setLocation(track_width, 5.0);
        iconLocX = track_width - ((track_width - (int)((Point2D)p1).getX()) / 2 + 16);
        iconLocY = TRACK_HEIGHT / 2 - 16 + 5;
        this.drawIcon(this.above, g, iconLocX, iconLocY, 32);
        g.setColor(BORDER_COLOR);
        g.setStroke(new BasicStroke(1.5f));
        g.drawRect(0, 5, track_width, TRACK_HEIGHT);
        g.translate(-6, -12);
    }

    public JComponent getRendererComponent(JXMultiThumbSlider slider) {
        this.slider = slider;
        return this;
    }

    protected List getRanges() {
        ArrayList range = new ArrayList();
        return range;
    }

    public String getToolTipForCurrentLocation(int x, int y) {
        int oldX = 0;
        List stops = this.slider.getModel().getSortedThumbs();
        int i = 1;
        for (Thumb thumb : stops) {
            int newX = (int)((float)this.slider.getWidth() * (thumb.getPosition() / 100.0f));
            if (oldX <= x && x <= newX && 20 < y && y < 20 + TRACK_HEIGHT) {
                return "This is region " + i;
            }
            ++i;
            oldX = newX + 1;
        }
        if (oldX <= x && x <= this.slider.getWidth() && 20 < y && y < 20 + TRACK_HEIGHT) {
            return "Last Area: " + oldX + " - " + this.slider.getWidth() + " (x, y) = " + x + ", " + y;
        }
        return null;
    }

    public Object getObjectInRange(int x, int y) {
        int range = this.getRangeID(x, y);
        if (range == -1) {
            return null;
        }
        if (range == 0) {
            return null;
        }
        if (range == this.slider.getModel().getThumbCount()) {
            // empty if block
        }
        return this.rangeObjects.get(this.getRangeID(x, y));
    }

    protected int getRangeID(int x, int y) {
        int i;
        int oldX = 0;
        List stops = this.slider.getModel().getSortedThumbs();
        for (i = 0; i < stops.size(); ++i) {
            Thumb thumb = (Thumb)stops.get(i);
            int newX = (int)((float)this.slider.getWidth() * (thumb.getPosition() / 100.0f));
            if (oldX <= x && x <= newX && 20 < y && y < 20 + TRACK_HEIGHT) {
                return i;
            }
            oldX = newX + 1;
        }
        if (oldX <= x && x <= this.slider.getWidth() && 20 < y && y < 20 + TRACK_HEIGHT) {
            return i;
        }
        return -1;
    }

    public static ImageIcon getTrackGraphicIcon(int iconWidth, int iconHeight, ContinuousMapping mapping) {
        BufferedImage bi = new BufferedImage(iconWidth, iconHeight, 1);
        Graphics2D g2 = bi.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int leftSpace = 2;
        int trackHeight = iconHeight - 15;
        int trackWidth = iconWidth - 2 - 5;
        g2.setBackground(Color.white);
        g2.setColor(Color.white);
        g2.fillRect(0, 0, iconWidth, iconHeight);
        g2.setStroke(new BasicStroke(1.0f));
        g2.setColor(Color.black);
        ArrayList<ContinuousMappingPoint> points = mapping.getAllPoints();
        int pointCount = points.size();
        if (pointCount == 0) {
            g2.drawRect(2, 0, trackWidth, trackHeight);
            return new ImageIcon(bi);
        }
        float[] fractions = new float[pointCount + 2];
        double[] values = new double[pointCount];
        Object[] objValues = new Object[pointCount + 2];
        objValues[0] = ((ContinuousMappingPoint)points.get((int)0)).getRange().lesserValue;
        if (pointCount == 1) {
            objValues[1] = ((ContinuousMappingPoint)points.get((int)0)).getRange().equalValue;
            objValues[2] = ((ContinuousMappingPoint)points.get((int)0)).getRange().greaterValue;
        } else {
            objValues[objValues.length - 1] = ((ContinuousMappingPoint)points.get((int)(points.size() - 1))).getRange().greaterValue;
            for (int i = 0; i < pointCount; ++i) {
                objValues[i + 1] = ((ContinuousMappingPoint)points.get((int)i)).getRange().equalValue;
            }
        }
        Point2D.Float start = new Point2D.Float(10.0f, 0.0f);
        Point2D.Float end = new Point2D.Float(trackWidth, trackHeight);
        return new ImageIcon(bi);
    }

    private static List buildIconArray(int size) {
        ArrayList<ImageIcon> icons = new ArrayList<ImageIcon>();
        Map<Object, Icon> iconMap = NodeShape.getIconSet();
        Object[] keys = iconMap.keySet().toArray();
        for (int i = 0; i < size; ++i) {
            icons.add((ImageIcon)iconMap.get(keys[i]));
        }
        return icons;
    }

    private void drawIcon(Object key, Graphics2D g, int x, int y, int size) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.translate(x, y);
        g.setColor(ICON_COLOR);
        g.setStroke(STROKE2);
        switch (this.type) {
            case NODE_SHAPE: {
                VisualPropertyIcon icon = (VisualPropertyIcon)this.type.getVisualProperty().getIconSet().get(key);
                icon.setIconHeight(size);
                icon.setIconWidth(size);
                g.fill(icon.getShape());
                break;
            }
            case EDGE_SRCARROW_SHAPE: 
            case EDGE_TGTARROW_SHAPE: {
                VisualPropertyIcon arrowIcon = (VisualPropertyIcon)this.type.getVisualProperty().getIconSet().get(key);
                if (arrowIcon == null) break;
                int newSize = size;
                arrowIcon.setIconHeight(newSize);
                arrowIcon.setIconWidth(((Number)((double)newSize * 2.5)).intValue());
                g.translate(-newSize, 0);
                arrowIcon.paintIcon(this, g, x, y);
                g.translate(newSize, 0);
                break;
            }
            case NODE_FONT_FACE: 
            case EDGE_FONT_FACE: {
                Font font = (Font)key;
                String fontName = font.getFontName();
                g.setFont(new Font(fontName, font.getStyle(), size));
                g.drawString("A", 0, size);
                int smallFontSize = ((Number)((double)size * 0.25)).intValue();
                g.setFont(new Font(fontName, font.getStyle(), smallFontSize));
                int stringWidth = SwingUtilities.computeStringWidth(g.getFontMetrics(), fontName);
                g.drawString(fontName, size / 2 - stringWidth / 2, size + smallFontSize + 2);
                break;
            }
            case NODE_LINE_STYLE: 
            case EDGE_LINE_STYLE: {
                Stroke stroke = ((LineStyle)((Object)key)).getStroke(2.0f);
                int newSize2 = (int)((double)size * 1.5);
                g.translate(0.0, (double)(-size) * 0.25);
                g.setColor(Color.DARK_GRAY);
                g.drawRect(0, 0, size, newSize2);
                g.setStroke(stroke);
                g.setColor(ICON_COLOR);
                g.drawLine(size - 1, 1, 1, newSize2 - 1);
                g.translate(0.0, (double)size * 0.25);
                break;
            }
            case NODE_LABEL_POSITION: {
                LabelPlacerGraphic lp = new LabelPlacerGraphic((LabelPosition)key, (int)((double)size * 1.5), false);
                lp.paint(g);
                break;
            }
            case NODE_LABEL: 
            case NODE_TOOLTIP: 
            case EDGE_LABEL: 
            case EDGE_TOOLTIP: {
                if (key == null) break;
                g.drawString(key.toString(), 0, g.getFont().getSize() * 2);
                break;
            }
        }
        g.translate(-x, -y);
    }

    public ImageIcon getTrackGraphicIcon(int iconWidth, int iconHeight) {
        return this.drawIcon(iconWidth, iconHeight, false);
    }

    public ImageIcon getLegend(int iconWidth, int iconHeight) {
        return this.drawIcon(iconWidth, iconHeight, true);
    }

    private ImageIcon drawIcon(int iconWidth, int iconHeight, boolean detail) {
        int iconLocY;
        int iconLocX;
        if (this.slider == null) {
            return null;
        }
        BufferedImage bi = new BufferedImage(iconWidth, iconHeight, 1);
        Graphics2D g = bi.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(Color.white);
        g.fillRect(0, 0, iconWidth, iconHeight);
        double minValue = EditorValueRangeTracer.getTracer().getMin(this.type);
        double maxValue = EditorValueRangeTracer.getTracer().getMax(this.type);
        double valueRange = EditorValueRangeTracer.getTracer().getRange(this.type);
        int track_width = iconWidth;
        int trackHeight = iconHeight - 8;
        if (detail) {
            trackHeight = iconHeight - 30;
            this.SMALL_ICON_SIZE = (int)((double)trackHeight * 0.5);
        } else {
            trackHeight = iconHeight - 8;
        }
        List stops = this.slider.getModel().getSortedThumbs();
        int numPoints = stops.size();
        float[] fractions = new float[numPoints];
        Object[] objectValues = new Object[numPoints];
        int i = 0;
        for (Thumb thumb : stops) {
            objectValues[i] = thumb.getObject();
            fractions[i] = thumb.getPosition();
            ++i;
        }
        if (numPoints == 0) {
            g.setColor(BORDER_COLOR);
            g.setStroke(new BasicStroke(1.0f));
            g.drawRect(0, 0, track_width - 3, trackHeight);
            return new ImageIcon(bi);
        }
        this.rangeObjects = DiscreteTrackRenderer.buildIconArray(stops.size() + 1);
        int newX = 0;
        Point2D.Float p1 = new Point2D.Float(0.0f, 5.0f);
        Point2D.Float p2 = new Point2D.Float(0.0f, 5.0f);
        for (i = 0; i < stops.size(); ++i) {
            newX = (int)((float)track_width * (fractions[i] / 100.0f));
            ((Point2D)p2).setLocation(newX, 0.0);
            iconLocX = newX - ((newX - (int)((Point2D)p1).getX()) / 2 + this.SMALL_ICON_SIZE / 2);
            iconLocY = trackHeight / 2 - this.SMALL_ICON_SIZE / 2;
            if (i == 0) {
                this.drawIcon(this.below, g, iconLocX, iconLocY, this.SMALL_ICON_SIZE);
            } else {
                this.drawIcon(objectValues[i], g, iconLocX, iconLocY, this.SMALL_ICON_SIZE);
            }
            g.setColor(Color.DARK_GRAY);
            g.setStroke(STROKE1);
            g.drawLine(newX, 0, newX, trackHeight);
            p1.setLocation(p2);
        }
        ((Point2D)p2).setLocation(track_width, 0.0);
        iconLocX = track_width - ((track_width - (int)((Point2D)p1).getX()) / 2 + this.SMALL_ICON_SIZE / 2);
        iconLocY = trackHeight / 2 - this.SMALL_ICON_SIZE / 2;
        this.drawIcon(this.above, g, iconLocX, iconLocY, this.SMALL_ICON_SIZE);
        g.setColor(BORDER_COLOR);
        g.setStroke(new BasicStroke(1.0f));
        g.drawRect(0, 0, track_width - 3, trackHeight);
        g.setFont(new Font("SansSerif", 1, 9));
        String minStr = String.format("%.2f", minValue);
        String maxStr = String.format("%.2f", maxValue);
        g.setColor(Color.black);
        if (detail) {
            int strWidth;
            String fNum = null;
            for (int j = 0; j < fractions.length; ++j) {
                fNum = String.format("%.2f", (double)(fractions[j] / 100.0f) * valueRange + minValue);
                strWidth = SwingUtilities.computeStringWidth(g.getFontMetrics(), fNum);
                g.drawString(fNum, fractions[j] / 100.0f * (float)iconWidth - (float)(strWidth / 2), (float)(iconHeight - 20));
            }
            g.drawString(minStr, 0, iconHeight);
            strWidth = SwingUtilities.computeStringWidth(g.getFontMetrics(), maxStr);
            g.drawString(maxStr, iconWidth - strWidth - 2, iconHeight);
            g.setFont(this.TITLE_FONT);
            int titleWidth = SwingUtilities.computeStringWidth(g.getFontMetrics(), this.title);
            g.setColor(Color.black);
            g.drawString(this.title, iconWidth / 2 - titleWidth / 2, iconHeight - 5);
            Polygon p = new Polygon();
            p.addPoint(iconWidth, iconHeight - 9);
            p.addPoint(iconWidth - 15, iconHeight - 15);
            p.addPoint(iconWidth - 15, iconHeight - 9);
            g.fillPolygon(p);
            g.drawLine(0, iconHeight - 9, iconWidth / 2 - titleWidth / 2 - 3, iconHeight - 9);
            g.drawLine(iconWidth / 2 + titleWidth / 2 + 3, iconHeight - 9, iconWidth, iconHeight - 9);
        } else {
            g.drawString(minStr, 0, iconHeight);
            int strWidth = SwingUtilities.computeStringWidth(g.getFontMetrics(), maxStr);
            g.drawString(maxStr, iconWidth - strWidth - 2, iconHeight);
        }
        return new ImageIcon(bi);
    }

    public Double getSelectedThumbValue() {
        double minValue = EditorValueRangeTracer.getTracer().getMin(this.type);
        double valueRange = EditorValueRangeTracer.getTracer().getRange(this.type);
        float position = this.slider.getModel().getThumbAt(this.slider.getSelectedIndex()).getPosition();
        return (double)(position / 100.0f) * valueRange + minValue;
    }
}

