/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui;

import cytoscape.CyNetwork;
import cytoscape.CyNetworkEvent;
import cytoscape.CyNetworkListener;
import cytoscape.Cytoscape;
import cytoscape.dialogs.GridBagGroup;
import cytoscape.dialogs.MiscGB;
import cytoscape.logger.CyLogger;
import cytoscape.util.SwingWorker;
import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.VisualMappingManager;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.VisualStyle;
import cytoscape.visual.calculators.Calculator;
import cytoscape.visual.ui.DefaultPanel;
import cytoscape.visual.ui.LegendDialog;
import cytoscape.visual.ui.VizMapAttrTab;
import cytoscape.visual.ui.VizMapFontTab;
import cytoscape.visual.ui.VizMapSizeTab;
import cytoscape.visual.ui.VizMapTab;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class VizMapUI
extends JDialog
implements CyNetworkListener {
    @Deprecated
    public static final byte NODE_COLOR = 0;
    @Deprecated
    public static final byte NODE_BORDER_COLOR = 1;
    @Deprecated
    public static final byte NODE_LINETYPE = 2;
    @Deprecated
    public static final byte NODE_SHAPE = 3;
    @Deprecated
    public static final byte NODE_SIZE = 4;
    @Deprecated
    public static final byte NODE_WIDTH = 5;
    @Deprecated
    public static final byte NODE_HEIGHT = 6;
    @Deprecated
    public static final byte NODE_LABEL = 7;
    @Deprecated
    public static final byte NODE_FONT_FACE = 8;
    @Deprecated
    public static final byte NODE_FONT_SIZE = 9;
    @Deprecated
    public static final byte NODE_LABEL_COLOR = 10;
    @Deprecated
    public static final byte NODE_TOOLTIP = 11;
    @Deprecated
    public static final byte NODE_LABEL_POSITION = 12;
    @Deprecated
    public static final byte EDGE_COLOR = 13;
    @Deprecated
    public static final byte EDGE_LINETYPE = 14;
    @Deprecated
    public static final byte EDGE_SRCARROW = 15;
    @Deprecated
    public static final byte EDGE_TGTARROW = 16;
    @Deprecated
    public static final byte EDGE_LABEL = 17;
    @Deprecated
    public static final byte EDGE_FONT_FACE = 18;
    @Deprecated
    public static final byte EDGE_FONT_SIZE = 19;
    @Deprecated
    public static final byte EDGE_LABEL_COLOR = 20;
    @Deprecated
    public static final byte EDGE_TOOLTIP = 21;
    @Deprecated
    public static final byte EDGE_LABEL_POSITION = 22;
    @Deprecated
    public static final byte EDGE_SRCARROW_COLOR = 50;
    @Deprecated
    public static final byte EDGE_TGTARROW_COLOR = 51;
    @Deprecated
    public static final byte NODE_LABEL_FONT = 100;
    @Deprecated
    public static final byte EDGE_LABEL_FONT = 101;
    protected VisualMappingManager VMM;
    private JPanel mainPane;
    private JPanel actionButtonsPanel;
    private JPanel attrSelectorPanel;
    private JPanel tabPaneContainer;
    private List<VizMapTab> tabs;
    protected Collection styles;
    protected StyleSelector styleSelector;
    private boolean initialized = false;

    public VizMapUI(VisualMappingManager VMM, JFrame mainFrame) {
        super((Frame)mainFrame, "VizMapper\u2122");
        this.VMM = VMM;
        CyNetwork cyNetwork = VMM.getNetwork();
        cyNetwork.addCyNetworkListener(this);
        this.mainPane = new JPanel(new GridBagLayout());
        this.tabs = new ArrayList<VizMapTab>();
        this.tabPaneContainer = new JPanel(new GridLayout(), false);
        JTabbedPane nodePane = new JTabbedPane();
        JTabbedPane edgePane = new JTabbedPane();
        nodePane.setName("nodePane");
        edgePane.setName("edgePane");
        this.addTab(this.tabs, nodePane, new VizMapAttrTab(this, nodePane, 0, VMM, (byte)VisualPropertyType.NODE_FILL_COLOR.ordinal()));
        this.addTab(this.tabs, nodePane, new VizMapAttrTab(this, nodePane, 1, VMM, (byte)VisualPropertyType.NODE_BORDER_COLOR.ordinal()));
        this.addTab(this.tabs, nodePane, new VizMapAttrTab(this, nodePane, 2, VMM, (byte)VisualPropertyType.NODE_LINETYPE.ordinal()));
        this.addTab(this.tabs, nodePane, new VizMapAttrTab(this, nodePane, 3, VMM, (byte)VisualPropertyType.NODE_SHAPE.ordinal()));
        this.addTab(this.tabs, nodePane, new VizMapSizeTab(this, nodePane, 4, VMM, (byte)VisualPropertyType.NODE_SIZE.ordinal()));
        this.addTab(this.tabs, nodePane, new VizMapAttrTab(this, nodePane, 5, VMM, (byte)VisualPropertyType.NODE_LABEL.ordinal()));
        this.addTab(this.tabs, nodePane, new VizMapFontTab(this, nodePane, 6, VMM, 100));
        this.addTab(this.tabs, nodePane, new VizMapAttrTab(this, nodePane, 7, VMM, (byte)VisualPropertyType.NODE_LABEL_COLOR.ordinal()));
        this.addTab(this.tabs, nodePane, new VizMapAttrTab(this, nodePane, 8, VMM, (byte)VisualPropertyType.NODE_LABEL_POSITION.ordinal()));
        this.addTab(this.tabs, nodePane, new VizMapAttrTab(this, nodePane, 9, VMM, (byte)VisualPropertyType.NODE_LINE_WIDTH.ordinal()));
        this.addTab(this.tabs, edgePane, new VizMapAttrTab(this, edgePane, 0, VMM, (byte)VisualPropertyType.EDGE_COLOR.ordinal()));
        this.addTab(this.tabs, edgePane, new VizMapAttrTab(this, edgePane, 1, VMM, (byte)VisualPropertyType.EDGE_LINETYPE.ordinal()));
        this.addTab(this.tabs, edgePane, new VizMapAttrTab(this, edgePane, 2, VMM, (byte)VisualPropertyType.EDGE_SRCARROW.ordinal()));
        this.addTab(this.tabs, edgePane, new VizMapAttrTab(this, edgePane, 3, VMM, (byte)VisualPropertyType.EDGE_TGTARROW.ordinal()));
        this.addTab(this.tabs, edgePane, new VizMapAttrTab(this, edgePane, 4, VMM, (byte)VisualPropertyType.EDGE_LABEL.ordinal()));
        this.addTab(this.tabs, edgePane, new VizMapFontTab(this, edgePane, 5, VMM, 101));
        this.addTab(this.tabs, edgePane, new VizMapAttrTab(this, edgePane, 6, VMM, (byte)VisualPropertyType.EDGE_LABEL_COLOR.ordinal()));
        this.addTab(this.tabs, edgePane, new VizMapAttrTab(this, edgePane, 7, VMM, (byte)VisualPropertyType.EDGE_LINE_WIDTH.ordinal()));
        this.addTab(this.tabs, edgePane, new VizMapAttrTab(this, edgePane, 8, VMM, (byte)VisualPropertyType.EDGE_SRCARROW_COLOR.ordinal()));
        this.addTab(this.tabs, edgePane, new VizMapAttrTab(this, edgePane, 9, VMM, (byte)VisualPropertyType.EDGE_TGTARROW_COLOR.ordinal()));
        DefaultPanel defaultPane = new DefaultPanel(this, VMM);
        ButtonGroup grp = new ButtonGroup();
        JToggleButton nodeSelect = new JToggleButton("Node Attributes", true);
        JToggleButton edgeSelect = new JToggleButton("Edge Attributes", false);
        JToggleButton defSelect = new JToggleButton("Global Defaults", false);
        grp.add(defSelect);
        grp.add(nodeSelect);
        grp.add(edgeSelect);
        nodeSelect.addActionListener(new AttrSelector(nodePane));
        edgeSelect.addActionListener(new AttrSelector(edgePane));
        defSelect.addActionListener(new AttrSelector(defaultPane));
        this.attrSelectorPanel = new JPanel(new FlowLayout(), false);
        this.attrSelectorPanel.add(nodeSelect);
        this.attrSelectorPanel.add(edgeSelect);
        this.attrSelectorPanel.add(defSelect);
        this.styleSelector = new StyleSelector(this, mainFrame);
        this.actionButtonsPanel = new JPanel();
        JButton applyButton = new JButton("Apply to Network");
        applyButton.addActionListener(new ApplyAction());
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(new CloseAction());
        this.actionButtonsPanel.add(applyButton);
        this.actionButtonsPanel.add(closeButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weightx = 1.0;
        this.mainPane.add((Component)this.attrSelectorPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.mainPane.add((Component)this.tabPaneContainer, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.mainPane.add((Component)this.actionButtonsPanel, gridBagConstraints);
        this.setContentPane(this.mainPane);
        this.pack();
        nodeSelect.doClick();
        this.initialized = true;
    }

    private void addTab(List<VizMapTab> tabs, JTabbedPane pane, VizMapTab t) {
        tabs.add(t);
        pane.add(t);
    }

    public StyleSelector getStyleSelector() {
        return this.styleSelector;
    }

    public void refreshUI() {
        for (int i = 0; i < this.tabs.size(); ++i) {
            this.tabs.get(i).refreshUI();
        }
        this.validate();
        this.repaint();
    }

    public void visualStyleChanged() {
        for (int i = 0; i < this.tabs.size(); ++i) {
            this.tabs.get(i).visualStyleChanged();
        }
        this.validate();
        this.pack();
        this.repaint();
    }

    VizMapTab checkCalcSelected(Calculator selectedCalc) {
        if (!this.initialized) {
            return null;
        }
        VizMapTab selected = null;
        for (int i = 0; i < this.tabs.size() && selected == null; ++i) {
            VizMapTab t = this.tabs.get(i);
            selected = t.checkCalcSelected(selectedCalc);
        }
        return selected;
    }

    public Vector checkCalculatorUsage(Calculator c) {
        Vector<Vector> conflicts = new Vector<Vector>();
        for (VisualStyle vs : this.styles) {
            Vector styleName = vs.checkConflictingCalculator(c);
            if (styleName.size() == 1) continue;
            conflicts.add(styleName);
        }
        return conflicts;
    }

    @Override
    public void onCyNetworkEvent(CyNetworkEvent event) {
        this.refreshUI();
    }

    private class CloseAction
    extends AbstractAction {
        private CloseAction() {
        }

        public void actionPerformed(ActionEvent e) {
            VizMapUI.this.dispose();
        }
    }

    private class ApplyAction
    extends AbstractAction {
        private ApplyAction() {
        }

        public void actionPerformed(ActionEvent e) {
            VizMapUI.this.VMM.getNetworkView().redrawGraph(false, true);
            Cytoscape.getDesktop().setFocus(VizMapUI.this.VMM.getNetworkView().getIdentifier());
        }
    }

    private class AttrSelector
    implements ActionListener {
        private JComponent myTab;

        private AttrSelector(JComponent myTab) {
            this.myTab = myTab;
        }

        public void actionPerformed(ActionEvent e) {
            VizMapUI.this.tabPaneContainer.removeAll();
            VizMapUI.this.tabPaneContainer.add(this.myTab);
            VizMapUI.this.pack();
            VizMapUI.this.repaint();
        }
    }

    public class StyleSelector
    extends JDialog
    implements ChangeListener {
        protected CalculatorCatalog catalog;
        protected DefaultComboBoxModel styleComboModel;
        protected JComboBox styleComboBox;
        protected JComboBox styleComboBoxDupe;
        protected GridBagGroup styleGBG;
        protected VisualStyle currentStyle;
        protected VizMapUI styleDefUI;
        protected StyleSelector myself;
        protected boolean styleDefNeedsUpdate;
        protected boolean rebuilding;
        protected JFrame mainFrame;

        protected StyleSelector(VizMapUI styleDef, JFrame mainFrame) {
            super((Frame)mainFrame, "VizMapper\u2122");
            this.styleComboModel = new DefaultComboBoxModel();
            this.styleComboBox = new JComboBox(this.styleComboModel);
            this.styleComboBoxDupe = new JComboBox(this.styleComboModel);
            this.styleDefNeedsUpdate = true;
            this.rebuilding = false;
            this.mainFrame = mainFrame;
            this.currentStyle = VizMapUI.this.VMM.getVisualStyle();
            this.styleDefUI = styleDef;
            this.catalog = VizMapUI.this.VMM.getCalculatorCatalog();
            VizMapUI.this.styles = this.catalog.getVisualStyles();
            this.styleGBG = new GridBagGroup("Visual Styles");
            this.myself = this;
            StyleSelectionListener listen = new StyleSelectionListener();
            this.styleComboBox.addItemListener(listen);
            String comboBoxHelp = "Change the current visual style";
            this.styleComboBox.setToolTipText(comboBoxHelp);
            this.styleComboBoxDupe.setToolTipText(comboBoxHelp);
            MiscGB.pad(this.styleGBG.constraints, 2, 2);
            MiscGB.inset(this.styleGBG.constraints, 3);
            this.resetStyles();
            JButton newStyle = new JButton("New");
            newStyle.addActionListener(new NewStyleListener());
            MiscGB.insert(this.styleGBG, newStyle, 0, 1, 1, 1, 1, 0, 2);
            newStyle.setToolTipText("Create a new style");
            JButton dupeStyle = new JButton("Duplicate");
            dupeStyle.addActionListener(new DupeStyleListener());
            MiscGB.insert(this.styleGBG, dupeStyle, 1, 1, 1, 1, 1, 0, 2);
            dupeStyle.setToolTipText("Duplicate the current style");
            JButton renStyle = new JButton("Rename");
            renStyle.addActionListener(new RenameStyleListener());
            MiscGB.insert(this.styleGBG, renStyle, 2, 1, 1, 1, 1, 0, 2);
            renStyle.setToolTipText("Rename the current style");
            JButton rmStyle = new JButton("Delete");
            rmStyle.addActionListener(new RemoveStyleListener());
            MiscGB.insert(this.styleGBG, rmStyle, 3, 1, 1, 1, 1, 0, 2);
            rmStyle.setToolTipText("Delete the current style");
            JButton createLegend = new JButton("Create Legend");
            createLegend.addActionListener(new LegendListener(this));
            MiscGB.insert(this.styleGBG, createLegend, 4, 1, 1, 1, 1, 0, 2);
            createLegend.setToolTipText("Create a figure legend for the selected visual style");
            JButton closeBut = new JButton("Close");
            closeBut.addActionListener(new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    StyleSelector.this.dispose();
                }
            });
            MiscGB.insert(this.styleGBG, closeBut, 5, 1, 1, 1, 1, 0, 2);
            closeBut.setToolTipText("Close this dialog");
            JButton defStyle = new JButton("Define");
            defStyle.addActionListener(new DefStyleListener());
            MiscGB.insert(this.styleGBG, defStyle, 5, 0, 1, 1, 1, 0, 2);
            defStyle.setToolTipText("Change the current style's settings");
            MiscGB.insert(this.styleGBG, this.styleComboBox, 0, 0, 5, 1, 1, 0, 2);
            this.setContentPane(this.styleGBG.panel);
            this.styleGBG.panel.setToolTipText("Visual styles are a collection of attribute mappings.");
            this.pack();
        }

        public String getStyleName(VisualStyle s) {
            String newName;
            String ret;
            int alt;
            String suggestedName = null;
            if (s != null) {
                suggestedName = this.catalog.checkVisualStyleName(s.getName());
            }
            do {
                if ((ret = (String)JOptionPane.showInputDialog(this.myself, "Name for new visual style", "Visual Style Name Input", 3, null, null, suggestedName)) == null) {
                    return null;
                }
                newName = this.catalog.checkVisualStyleName(ret);
                if (!newName.equals(ret)) continue;
                return ret;
            } while ((alt = JOptionPane.showConfirmDialog(this.myself, "Visual style with name " + ret + " already exists,\nrename to " + newName + " okay?", "Duplicate visual style name", 0, 2, null)) != 0);
            return newName;
        }

        public JComboBox getToolbarComboBox() {
            return this.styleComboBoxDupe;
        }

        protected void refreshStyleComboBox(VisualStyle selectedStyle) {
            this.rebuilding = true;
            this.styleComboModel.removeAllElements();
            Iterator styleIter = VizMapUI.this.styles.iterator();
            while (styleIter.hasNext()) {
                this.styleComboModel.addElement(styleIter.next());
            }
            if (selectedStyle != null) {
                this.styleComboModel.setSelectedItem(selectedStyle);
            } else {
                this.styleComboModel.setSelectedItem(this.currentStyle);
            }
            this.rebuilding = false;
        }

        public void resetStyles() {
            VizMapUI.this.styles = this.catalog.getVisualStyles();
            this.refreshStyleComboBox(null);
        }

        public void resetStyles(String selected) {
            VizMapUI.this.styles = this.catalog.getVisualStyles();
            this.refreshStyleComboBox(this.catalog.getVisualStyle(selected));
        }

        public void stateChanged(ChangeEvent ce) {
            if (this.currentStyle != VizMapUI.this.VMM.getVisualStyle()) {
                this.currentStyle = VizMapUI.this.VMM.getVisualStyle();
                if (this.styleComboModel.getIndexOf(this.currentStyle) == -1) {
                    this.styleComboModel.addElement(this.currentStyle);
                }
                this.styleComboModel.setSelectedItem(this.currentStyle);
                if (this.styleDefUI.isShowing()) {
                    VizMapUI.this.visualStyleChanged();
                } else {
                    this.styleDefNeedsUpdate = true;
                }
            }
        }

        protected class StyleSelectionListener
        implements ItemListener {
            protected StyleSelectionListener() {
            }

            public void itemStateChanged(ItemEvent e) {
                VisualStyle newStyle;
                if (StyleSelector.this.rebuilding) {
                    return;
                }
                if (e.getStateChange() == 1 && (newStyle = (VisualStyle)((JComboBox)e.getSource()).getSelectedItem()) != StyleSelector.this.currentStyle && newStyle != null) {
                    VizMapUI.this.VMM.setVisualStyle(newStyle);
                    Cytoscape.getNetworkView(Cytoscape.getCurrentNetwork().getIdentifier()).setVisualStyle(newStyle.getName());
                    Cytoscape.getCurrentNetworkView().redrawGraph(false, true);
                }
            }
        }

        protected class DupeStyleListener
        extends AbstractAction {
            protected DupeStyleListener() {
            }

            public void actionPerformed(ActionEvent e) {
                VisualStyle clone = null;
                try {
                    clone = (VisualStyle)StyleSelector.this.currentStyle.clone();
                }
                catch (CloneNotSupportedException exc) {
                    CyLogger.getLogger().warn("Clone not supported exception!");
                }
                String newName = StyleSelector.this.getStyleName(clone);
                if (newName == null) {
                    return;
                }
                clone.setName(newName);
                StyleSelector.this.catalog.addVisualStyle(clone);
                StyleSelector.this.currentStyle = clone;
                StyleSelector.this.resetStyles();
                VizMapUI.this.VMM.setVisualStyle(StyleSelector.this.currentStyle);
                VizMapUI.this.VMM.getNetworkView().redrawGraph(false, true);
            }
        }

        protected class RemoveStyleListener
        extends AbstractAction {
            protected RemoveStyleListener() {
            }

            public void actionPerformed(ActionEvent e) {
                if (VizMapUI.this.styles.size() == 1) {
                    JOptionPane.showMessageDialog(StyleSelector.this.myself, "There must be at least one visual style", "Cannot remove style", 0);
                    return;
                }
                String styleName = StyleSelector.this.currentStyle.getName();
                String checkString = "Are you sure you want to permanently delete the visual style named '" + styleName + "'?";
                int ich = JOptionPane.showConfirmDialog(StyleSelector.this.myself, checkString, "Confirm Delete Style", 0);
                if (ich == 0) {
                    StyleSelector.this.catalog.removeVisualStyle(StyleSelector.this.currentStyle.getName());
                    StyleSelector.this.currentStyle = StyleSelector.this.catalog.getVisualStyle("default");
                    if (StyleSelector.this.currentStyle == null) {
                        StyleSelector.this.currentStyle = (VisualStyle)VizMapUI.this.styles.iterator().next();
                    }
                    StyleSelector.this.resetStyles();
                    VizMapUI.this.VMM.setVisualStyle(StyleSelector.this.currentStyle);
                    VizMapUI.this.VMM.getNetworkView().redrawGraph(false, true);
                }
            }
        }

        protected class RenameStyleListener
        extends AbstractAction {
            protected RenameStyleListener() {
            }

            public void actionPerformed(ActionEvent e) {
                String oldName = StyleSelector.this.currentStyle.getName();
                String name = StyleSelector.this.getStyleName(StyleSelector.this.currentStyle);
                if (name == null) {
                    return;
                }
                StyleSelector.this.currentStyle.setName(name);
                StyleSelector.this.catalog.removeVisualStyle(oldName);
                StyleSelector.this.catalog.addVisualStyle(StyleSelector.this.currentStyle);
                StyleSelector.this.resetStyles();
                VizMapUI.this.VMM.setVisualStyle(StyleSelector.this.currentStyle);
            }
        }

        protected class NewStyleListener
        extends AbstractAction {
            protected NewStyleListener() {
            }

            public void actionPerformed(ActionEvent e) {
                String name = StyleSelector.this.getStyleName(null);
                if (name == null) {
                    return;
                }
                StyleSelector.this.currentStyle = new VisualStyle(name);
                StyleSelector.this.catalog.addVisualStyle(StyleSelector.this.currentStyle);
                StyleSelector.this.resetStyles();
                VizMapUI.this.VMM.setVisualStyle(StyleSelector.this.currentStyle);
                Cytoscape.getNetworkView(Cytoscape.getCurrentNetwork().getIdentifier()).setVisualStyle(StyleSelector.this.currentStyle.getName());
                VizMapUI.this.VMM.getNetworkView().redrawGraph(false, true);
            }
        }

        protected class LegendListener
        extends AbstractAction {
            JDialog parent;

            public LegendListener(JDialog p) {
                this.parent = p;
            }

            public void actionPerformed(ActionEvent e) {
                SwingWorker worker = new SwingWorker(){

                    public Object construct() {
                        LegendDialog ld = new LegendDialog((Dialog)LegendListener.this.parent, StyleSelector.this.currentStyle);
                        ld.setVisible(true);
                        return null;
                    }
                };
                worker.start();
            }
        }

        protected class DefStyleListener
        extends AbstractAction {
            protected DefStyleListener() {
            }

            public void actionPerformed(ActionEvent e) {
                if (StyleSelector.this.styleDefNeedsUpdate) {
                    StyleSelector.this.styleDefUI.visualStyleChanged();
                    StyleSelector.this.styleDefNeedsUpdate = false;
                }
                StyleSelector.this.styleDefUI.setVisible(true);
            }
        }
    }
}

