/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui;

import cytoscape.Cytoscape;
import cytoscape.util.CyColorChooser;
import cytoscape.visual.ArrowShape;
import cytoscape.visual.LabelPosition;
import cytoscape.visual.LineStyle;
import cytoscape.visual.NodeShape;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.ui.PopupFontChooser;
import cytoscape.visual.ui.PopupLabelPositionChooser;
import cytoscape.visual.ui.ValueSelectDialog;
import cytoscape.visual.ui.editors.continuous.C2CMappingEditor;
import cytoscape.visual.ui.editors.continuous.C2DMappingEditor;
import cytoscape.visual.ui.editors.continuous.GradientEditorPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum EditorDisplayer {
    DISCRETE_COLOR(CyColorChooser.class, "showDialog", new Class[]{Component.class, String.class, Color.class}, new Object[]{Cytoscape.getDesktop(), "Select Color...", null}, Color.class),
    DISCRETE_FONT(PopupFontChooser.class, "showDialog", new Class[]{Frame.class, Font.class}, new Object[]{Cytoscape.getDesktop(), null}, Font.class),
    DISCRETE_NUMBER(JOptionPane.class, "showInputDialog", new Class[]{Component.class, Object.class}, new Object[]{Cytoscape.getDesktop(), "Please enter new numeric value:"}, Number.class),
    DISCRETE_STRING(JOptionPane.class, "showInputDialog", new Class[]{Component.class, Object.class}, new Object[]{Cytoscape.getDesktop(), "Please enter new text value:"}, String.class),
    DISCRETE_SHAPE(ValueSelectDialog.class, "showDialog", new Class[]{VisualPropertyType.class, JDialog.class}, new Object[]{VisualPropertyType.NODE_SHAPE, null}, NodeShape.class),
    DISCRETE_ARROW_SHAPE(ValueSelectDialog.class, "showDialog", new Class[]{VisualPropertyType.class, JDialog.class}, new Object[]{VisualPropertyType.EDGE_SRCARROW_SHAPE, null}, ArrowShape.class),
    DISCRETE_LINE_STYLE(ValueSelectDialog.class, "showDialog", new Class[]{VisualPropertyType.class, JDialog.class}, new Object[]{VisualPropertyType.EDGE_LINE_STYLE, null}, LineStyle.class),
    DISCRETE_LABEL_POSITION(PopupLabelPositionChooser.class, "showDialog", new Class[]{Frame.class, LabelPosition.class}, new Object[]{Cytoscape.getDesktop(), null}, LabelPosition.class),
    CONTINUOUS_COLOR(GradientEditorPanel.class, "showDialog", new Class[]{Integer.TYPE, Integer.TYPE, String.class, VisualPropertyType.class}, new Object[]{450, 180, "Gradient Editor", null}, Color.class),
    CONTINUOUS_CONTINUOUS(C2CMappingEditor.class, "showDialog", new Class[]{Integer.TYPE, Integer.TYPE, String.class, VisualPropertyType.class}, new Object[]{450, 250, "Continuous-Continuous Editor", null}, Number.class),
    CONTINUOUS_DISCRETE(C2DMappingEditor.class, "showDialog", new Class[]{Integer.TYPE, Integer.TYPE, String.class, VisualPropertyType.class}, new Object[]{450, 200, "Continuous-Discrete Editor", null}, Object.class);

    private Class chooserClass;
    private String command;
    private Class[] paramTypes;
    private Object[] parameters;
    private Class compatibleClass;

    private EditorDisplayer(Class chooserClass, String command, Class[] paramTypes, Object[] parameters, Class compatibleClass) {
        this.chooserClass = chooserClass;
        this.command = command;
        this.paramTypes = paramTypes;
        this.parameters = parameters;
        this.compatibleClass = compatibleClass;
    }

    public Class getActionClass() {
        return this.chooserClass;
    }

    public String getCommand() {
        return this.command;
    }

    public Class[] getParamTypes() {
        return this.paramTypes;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public Class getCompatibleClass() {
        return this.compatibleClass;
    }

    public void setParameters(Object[] param) {
        this.parameters = param;
    }

    public static EditorDisplayer getEditor(VisualPropertyType type, EditorType editor) {
        Class dataType = type.getDataType();
        for (EditorDisplayer command : EditorDisplayer.values()) {
            if (dataType != command.getCompatibleClass() || (editor != EditorType.CONTINUOUS || !command.toString().startsWith(EditorType.CONTINUOUS.name())) && (editor != EditorType.DISCRETE || !command.toString().startsWith(EditorType.DISCRETE.name()))) continue;
            return command;
        }
        return CONTINUOUS_DISCRETE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EditorType {
        CONTINUOUS,
        DISCRETE,
        PASSTHROUGH;

    }
}

