/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.properties;

import cytoscape.Cytoscape;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.parsers.FloatParser;
import cytoscape.visual.properties.AbstractVisualProperty;
import cytoscape.visual.ui.icon.NodeIcon;
import giny.view.NodeView;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Paint;
import java.util.Properties;
import javax.swing.Icon;

public class NodeLabelOpacityProp
extends AbstractVisualProperty {
    public VisualPropertyType getType() {
        return VisualPropertyType.NODE_LABEL_OPACITY;
    }

    public Icon getIcon(final Object value) {
        NodeIcon icon = new NodeIcon(){

            public void paintIcon(Component c, Graphics g, int x, int y) {
                super.setColor(new Color(10, 10, 10, 0));
                super.paintIcon(c, g, x, y);
                this.g2d.translate(0, -2);
                Color color = (Color)VisualPropertyType.NODE_LABEL_COLOR.getDefault(Cytoscape.getVisualMappingManager().getVisualStyle());
                this.g2d.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), ((Number)value).intValue()));
                this.g2d.setStroke(new BasicStroke(2.0f));
                this.g2d.draw(this.newShape);
                this.g2d.translate(0, 2);
                this.g2d.setFont(new Font("SansSerif", 1, 24));
                this.g2d.setColor(Color.DARK_GRAY);
                this.g2d.drawString(value.toString(), c.getX() + 7, c.getHeight() / 2 + 7);
                this.g2d.setFont(new Font("SansSerif", 1, 12));
            }
        };
        return icon;
    }

    public void applyToNodeView(NodeView nv, Object o) {
        Integer newTp;
        if (o == null || nv == null) {
            return;
        }
        Integer tp = ((Color)nv.getLabel().getTextPaint()).getAlpha();
        if (tp != (newTp = Integer.valueOf(((Number)o).intValue()))) {
            Color oldPaint = (Color)nv.getLabel().getTextPaint();
            nv.getLabel().setTextPaint((Paint)new Color(oldPaint.getRed(), oldPaint.getGreen(), oldPaint.getBlue(), newTp));
        }
    }

    public Object parseProperty(Properties props, String baseKey) {
        String s = props.getProperty(VisualPropertyType.NODE_LABEL_OPACITY.getDefaultPropertyKey(baseKey));
        if (s != null) {
            return new FloatParser().parseFloat(s).intValue();
        }
        return null;
    }

    public Object getDefaultAppearanceObject() {
        return new Integer(255);
    }
}

