/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.properties;

import cytoscape.Cytoscape;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.parsers.ColorParser;
import cytoscape.visual.properties.AbstractVisualProperty;
import cytoscape.visual.ui.icon.NodeIcon;
import giny.view.Label;
import giny.view.NodeView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Paint;
import java.util.Properties;
import javax.swing.Icon;

public class NodeLabelColorProp
extends AbstractVisualProperty {
    public VisualPropertyType getType() {
        return VisualPropertyType.NODE_LABEL_COLOR;
    }

    public Icon getIcon(final Object value) {
        NodeIcon icon = new NodeIcon(){

            public void paintIcon(Component c, Graphics g, int x, int y) {
                super.setColor(new Color(10, 10, 10, 0));
                super.paintIcon(c, g, x, y);
                this.g2d.setColor((Color)value);
                Font font = (Font)VisualPropertyType.NODE_FONT_FACE.getDefault(Cytoscape.getVisualMappingManager().getVisualStyle());
                this.g2d.setFont(new Font(font.getFontName(), font.getStyle(), 28));
                this.g2d.drawString("Label", 8, c.getHeight() / 2 + 10);
                this.g2d.setFont(new Font("SansSerif", 1, 12));
            }
        };
        return icon;
    }

    public void applyToNodeView(NodeView nv, Object o) {
        if (o == null || nv == null) {
            return;
        }
        Label nodelabel = nv.getLabel();
        if (!((Color)o).equals(nodelabel.getTextPaint())) {
            nodelabel.setTextPaint((Paint)((Color)o));
        }
    }

    public Object parseProperty(Properties props, String baseKey) {
        String s = props.getProperty(VisualPropertyType.NODE_LABEL_COLOR.getDefaultPropertyKey(baseKey));
        if (s != null) {
            return new ColorParser().parseColor(s);
        }
        return null;
    }

    public Object getDefaultAppearanceObject() {
        return Color.black;
    }
}

