/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.properties;

import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.parsers.FloatParser;
import cytoscape.visual.properties.AbstractVisualProperty;
import cytoscape.visual.ui.icon.LineTypeIcon;
import giny.view.EdgeView;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.util.Properties;
import javax.swing.Icon;

public class EdgeLineWidthProp
extends AbstractVisualProperty {
    public VisualPropertyType getType() {
        return VisualPropertyType.EDGE_LINE_WIDTH;
    }

    public Icon getIcon(Object value) {
        LineTypeIcon icon = new LineTypeIcon();
        icon.setColor(new Color(10, 10, 10, 20));
        icon.setText(value.toString());
        icon.setBottomPadding(-7);
        return icon;
    }

    public void applyToEdgeView(EdgeView ev, Object o) {
        if (o == null || ev == null) {
            return;
        }
        if (ev.getStrokeWidth() != ((Number)o).floatValue()) {
            BasicStroke oldValue = (BasicStroke)ev.getStroke();
            BasicStroke newLine = new BasicStroke(((Number)o).floatValue(), oldValue.getEndCap(), oldValue.getLineJoin(), oldValue.getMiterLimit(), oldValue.getDashArray(), oldValue.getDashPhase());
            ev.setStroke((Stroke)newLine);
        }
    }

    public Object parseProperty(Properties props, String baseKey) {
        String s = props.getProperty(VisualPropertyType.EDGE_LINE_WIDTH.getDefaultPropertyKey(baseKey));
        if (s != null) {
            return new FloatParser().parseFloat(s);
        }
        return null;
    }

    public Object getDefaultAppearanceObject() {
        return new Float(1.0f);
    }
}

