/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual;

import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.CalculatorIO;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.VisualStyle;
import cytoscape.visual.calculators.AbstractCalculator;
import cytoscape.visual.calculators.Calculator;
import cytoscape.visual.mappings.ObjectMapping;
import java.awt.Color;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Properties;
import junit.framework.TestCase;

public class VizMapPropertiesTest
extends TestCase {
    private CalculatorCatalog catalog;
    private Properties props;

    public void setUp() {
        this.catalog = new CalculatorCatalog();
        this.props = new Properties();
        try {
            String propsFile = "testData/old_vizmap.props";
            FileInputStream is = new FileInputStream(propsFile);
            this.props.load(is);
            ((InputStream)is).close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        CalculatorIO.loadCalculators(this.props, this.catalog);
    }

    public void tearDown() {
    }

    public void testProperties() {
        Collection<Calculator> nodeColorCalcs = this.catalog.getCalculators(VisualPropertyType.NODE_FILL_COLOR);
        System.out.println("nodeColorCalcs.size() = " + nodeColorCalcs.size());
        this.checkCalculator(this.catalog.getCalculator(VisualPropertyType.NODE_FILL_COLOR, "RedGreen"));
        System.out.println();
        Collection<Calculator> nodeLineTypeCalcs = this.catalog.getCalculators(VisualPropertyType.NODE_LINETYPE);
        System.out.println("nodeLineTypeCalcs.size() = " + nodeLineTypeCalcs.size());
        VizMapPropertiesTest.assertNull((Object)this.catalog.getCalculator(VisualPropertyType.NODE_LINETYPE, "BasicDiscrete"));
        VizMapPropertiesTest.assertNull((Object)this.catalog.getCalculator(VisualPropertyType.NODE_LINETYPE, "BasicContinuous"));
        System.out.println();
        Collection<Calculator> nodeShapeCalcs = this.catalog.getCalculators(VisualPropertyType.NODE_SHAPE);
        System.out.println("nodeShapeCalcs.size() = " + nodeShapeCalcs.size());
        this.checkCalculator(this.catalog.getCalculator(VisualPropertyType.NODE_SHAPE, "BasicDiscrete"));
        this.checkCalculator(this.catalog.getCalculator(VisualPropertyType.NODE_SHAPE, "BasicContinuous"));
        System.out.println();
        Collection<Calculator> nodeSizeCalcs = this.catalog.getCalculators(VisualPropertyType.NODE_SIZE);
        System.out.println("nodeSizeCalcs.size() = " + nodeSizeCalcs.size());
        this.checkCalculator(this.catalog.getCalculator(VisualPropertyType.NODE_SIZE, "BasicDiscrete"));
        this.checkCalculator(this.catalog.getCalculator(VisualPropertyType.NODE_SIZE, "BasicContinuous"));
        System.out.println();
        Collection<Calculator> nodeLabelCalcs = this.catalog.getCalculators(VisualPropertyType.NODE_LABEL);
        System.out.println("nodeLabelCalcs.size() = " + nodeLabelCalcs.size());
        this.checkCalculator(this.catalog.getCalculator(VisualPropertyType.NODE_LABEL, "BasicDiscrete"));
        this.checkCalculator(this.catalog.getCalculator(VisualPropertyType.NODE_LABEL, "BasicContinuous"));
        System.out.println();
        Collection<Calculator> nodeToolTipCalcs = this.catalog.getCalculators(VisualPropertyType.NODE_TOOLTIP);
        System.out.println("nodeToolTipCalcs.size() = " + nodeToolTipCalcs.size());
        this.checkCalculator(this.catalog.getCalculator(VisualPropertyType.NODE_TOOLTIP, "BasicDiscrete"));
        this.checkCalculator(this.catalog.getCalculator(VisualPropertyType.NODE_TOOLTIP, "BasicContinuous"));
        System.out.println();
        Collection<Calculator> nodeFontFaceCalcs = this.catalog.getCalculators(VisualPropertyType.NODE_FONT_FACE);
        System.out.println("nodeFontFaceCalcs.size() = " + nodeFontFaceCalcs.size());
        this.checkCalculator(this.catalog.getCalculator(VisualPropertyType.NODE_FONT_FACE, "BasicDiscrete"));
        this.checkCalculator(this.catalog.getCalculator(VisualPropertyType.NODE_FONT_FACE, "BasicContinuous"));
        System.out.println();
        Collection<Calculator> nodeFontSizeCalcs = this.catalog.getCalculators(VisualPropertyType.NODE_FONT_SIZE);
        System.out.println("nodeFontSizeCalcs.size() = " + nodeFontSizeCalcs.size());
        this.checkCalculator(this.catalog.getCalculator(VisualPropertyType.NODE_FONT_SIZE, "BasicDiscrete"));
        this.checkCalculator(this.catalog.getCalculator(VisualPropertyType.NODE_FONT_SIZE, "BasicContinuous"));
        System.out.println();
        Collection<Calculator> edgeColorCalcs = this.catalog.getCalculators(VisualPropertyType.EDGE_COLOR);
        System.out.println("edgeColorCalcs.size() = " + edgeColorCalcs.size());
        this.checkCalculator(this.catalog.getCalculator(VisualPropertyType.EDGE_COLOR, "BasicDiscrete"));
        System.out.println();
        Collection<Calculator> edgeLineTypeCalcs = this.catalog.getCalculators(VisualPropertyType.EDGE_LINETYPE);
        System.out.println("edgeLineTypeCalcs.size() = " + edgeLineTypeCalcs.size());
        VizMapPropertiesTest.assertEquals((int)0, (int)edgeLineTypeCalcs.size());
        System.out.println();
        Collection<Calculator> edgeArrowCalcs = this.catalog.getCalculators(VisualPropertyType.EDGE_SRCARROW);
        System.out.println("edgeArrowCalcs.size() = " + edgeArrowCalcs.size());
        this.checkCalculator(this.catalog.getCalculator(VisualPropertyType.EDGE_SRCARROW, "BasicDiscrete"));
        this.checkCalculator(this.catalog.getCalculator(VisualPropertyType.EDGE_TGTARROW, "BasicContinuous"));
        System.out.println();
        Collection<Calculator> edgeLabelCalcs = this.catalog.getCalculators(VisualPropertyType.EDGE_LABEL);
        System.out.println("edgeLabelCalcs.size() = " + edgeLabelCalcs.size());
        this.checkCalculator(this.catalog.getCalculator(VisualPropertyType.EDGE_LABEL, "BasicDiscrete"));
        this.checkCalculator(this.catalog.getCalculator(VisualPropertyType.EDGE_LABEL, "BasicContinuous"));
        this.checkCalculator(this.catalog.getCalculator(VisualPropertyType.EDGE_LABEL, "testPassThrough"));
        System.out.println();
        Collection<Calculator> edgeToolTipCalcs = this.catalog.getCalculators(VisualPropertyType.EDGE_TOOLTIP);
        System.out.println("edgeToolTipCalcs.size() = " + edgeToolTipCalcs.size());
        this.checkCalculator(this.catalog.getCalculator(VisualPropertyType.EDGE_TOOLTIP, "BasicDiscrete"));
        this.checkCalculator(this.catalog.getCalculator(VisualPropertyType.EDGE_TOOLTIP, "BasicContinuous"));
        System.out.println();
        Collection<Calculator> edgeFontFaceCalcs = this.catalog.getCalculators(VisualPropertyType.EDGE_FONT_FACE);
        System.out.println("edgeFontFaceCalcs.size() = " + edgeFontFaceCalcs.size());
        this.checkCalculator(this.catalog.getCalculator(VisualPropertyType.EDGE_FONT_FACE, "BasicDiscrete"));
        this.checkCalculator(this.catalog.getCalculator(VisualPropertyType.EDGE_FONT_FACE, "BasicContinuous"));
        System.out.println();
        Collection<Calculator> edgeFontSizeCalcs = this.catalog.getCalculators(VisualPropertyType.EDGE_FONT_SIZE);
        System.out.println("edgeFontSizeCalcs.size() = " + edgeFontSizeCalcs.size());
        this.checkCalculator(this.catalog.getCalculator(VisualPropertyType.EDGE_FONT_SIZE, "BasicDiscrete"));
        this.checkCalculator(this.catalog.getCalculator(VisualPropertyType.EDGE_FONT_SIZE, "BasicContinuous"));
        System.out.println();
    }

    public void testVisualStyle() {
        String DEF = "default";
        String CLONE = "default clone1";
        System.out.println("====================== Start Visual Style Test ====================");
        Collection<VisualStyle> vizStyles = this.catalog.getVisualStyles();
        for (VisualStyle style : vizStyles) {
            System.out.println("Style Names: " + style.getName());
        }
        VisualStyle originalStyle = this.catalog.getVisualStyle("default");
        VizMapPropertiesTest.assertNotNull((Object)originalStyle);
        originalStyle.getGlobalAppearanceCalculator().setDefaultBackgroundColor(Color.white);
        originalStyle.getNodeAppearanceCalculator().getDefaultAppearance().set(VisualPropertyType.NODE_FILL_COLOR, (Object)Color.red);
        System.out.println("Original Style BG Color = " + originalStyle.getGlobalAppearanceCalculator().getDefaultBackgroundColor());
        System.out.println("Original Style Def Node Color = " + originalStyle.getNodeAppearanceCalculator().getDefaultAppearance().get(VisualPropertyType.NODE_FILL_COLOR));
        VisualStyle cloneStyle = new VisualStyle(originalStyle, "default clone1");
        VizMapPropertiesTest.assertNotNull((Object)originalStyle);
        VizMapPropertiesTest.assertEquals((String)cloneStyle.getName(), (String)"default clone1");
        this.catalog.addVisualStyle(cloneStyle);
        cloneStyle.getGlobalAppearanceCalculator().setDefaultBackgroundColor(Color.black);
        cloneStyle.getNodeAppearanceCalculator().getDefaultAppearance().set(VisualPropertyType.NODE_FILL_COLOR, (Object)Color.blue);
        System.out.println("Clone Style BG Color = " + cloneStyle.getGlobalAppearanceCalculator().getDefaultBackgroundColor());
        System.out.println("Clone Style Def Node Color = " + cloneStyle.getNodeAppearanceCalculator().getDefaultAppearance().get(VisualPropertyType.NODE_FILL_COLOR));
        for (VisualStyle style : vizStyles) {
            System.out.println("New Style Names: " + style.getName());
        }
        VizMapPropertiesTest.assertEquals((Object)this.catalog.getVisualStyle("default").getGlobalAppearanceCalculator().getDefaultBackgroundColor(), (Object)Color.white);
        VizMapPropertiesTest.assertEquals((Object)this.catalog.getVisualStyle("default clone1").getGlobalAppearanceCalculator().getDefaultBackgroundColor(), (Object)Color.black);
        VizMapPropertiesTest.assertEquals((Object)this.catalog.getVisualStyle("default").getNodeAppearanceCalculator().getDefaultAppearance().get(VisualPropertyType.NODE_FILL_COLOR), (Object)Color.red);
        VizMapPropertiesTest.assertEquals((Object)this.catalog.getVisualStyle("default clone1").getNodeAppearanceCalculator().getDefaultAppearance().get(VisualPropertyType.NODE_FILL_COLOR), (Object)Color.blue);
        System.out.println("====================== End Visual Style Test ====================");
    }

    private void checkCalculator(Calculator c) {
        if (c == null) {
            VizMapPropertiesTest.fail();
        }
        AbstractCalculator gc = (AbstractCalculator)c;
        ObjectMapping m = gc.getMapping(0);
        System.out.println("controller = " + m.getControllingAttributeName());
        System.out.println("Map = " + m);
    }
}

