/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual;

import cytoscape.visual.Appearance;
import cytoscape.visual.Arrow;
import cytoscape.visual.ArrowShape;
import cytoscape.visual.EdgeAppearance;
import cytoscape.visual.EdgeAppearanceCalculator;
import cytoscape.visual.LabelPosition;
import cytoscape.visual.LineStyle;
import cytoscape.visual.LineType;
import cytoscape.visual.NodeAppearance;
import cytoscape.visual.NodeAppearanceCalculator;
import cytoscape.visual.NodeShape;
import cytoscape.visual.VisualProperty;
import cytoscape.visual.VisualStyle;
import cytoscape.visual.calculators.Calculator;
import cytoscape.visual.parsers.ArrowParser;
import cytoscape.visual.parsers.ArrowShapeParser;
import cytoscape.visual.parsers.ColorParser;
import cytoscape.visual.parsers.DoubleParser;
import cytoscape.visual.parsers.FloatParser;
import cytoscape.visual.parsers.FontParser;
import cytoscape.visual.parsers.LabelPositionParser;
import cytoscape.visual.parsers.LineStyleParser;
import cytoscape.visual.parsers.LineTypeParser;
import cytoscape.visual.parsers.NodeShapeParser;
import cytoscape.visual.parsers.StringParser;
import cytoscape.visual.parsers.ValueParser;
import cytoscape.visual.properties.EdgeColorProp;
import cytoscape.visual.properties.EdgeFontFaceProp;
import cytoscape.visual.properties.EdgeFontSizeProp;
import cytoscape.visual.properties.EdgeLabelColorProp;
import cytoscape.visual.properties.EdgeLabelOpacityProp;
import cytoscape.visual.properties.EdgeLabelPositionProp;
import cytoscape.visual.properties.EdgeLabelProp;
import cytoscape.visual.properties.EdgeLineStyleProp;
import cytoscape.visual.properties.EdgeLineTypeProp;
import cytoscape.visual.properties.EdgeLineWidthProp;
import cytoscape.visual.properties.EdgeOpacityProp;
import cytoscape.visual.properties.EdgeSourceArrowColorProp;
import cytoscape.visual.properties.EdgeSourceArrowOpacityProp;
import cytoscape.visual.properties.EdgeSourceArrowProp;
import cytoscape.visual.properties.EdgeSourceArrowShapeProp;
import cytoscape.visual.properties.EdgeTargetArrowColorProp;
import cytoscape.visual.properties.EdgeTargetArrowOpacityProp;
import cytoscape.visual.properties.EdgeTargetArrowProp;
import cytoscape.visual.properties.EdgeTargetArrowShapeProp;
import cytoscape.visual.properties.EdgeToolTipProp;
import cytoscape.visual.properties.NodeBorderColorProp;
import cytoscape.visual.properties.NodeBorderOpacityProp;
import cytoscape.visual.properties.NodeFillColorProp;
import cytoscape.visual.properties.NodeFontFaceProp;
import cytoscape.visual.properties.NodeFontSizeProp;
import cytoscape.visual.properties.NodeHeightProp;
import cytoscape.visual.properties.NodeLabelColorProp;
import cytoscape.visual.properties.NodeLabelOpacityProp;
import cytoscape.visual.properties.NodeLabelPositionProp;
import cytoscape.visual.properties.NodeLabelProp;
import cytoscape.visual.properties.NodeLineStyleProp;
import cytoscape.visual.properties.NodeLineTypeProp;
import cytoscape.visual.properties.NodeLineWidthProp;
import cytoscape.visual.properties.NodeOpacityProp;
import cytoscape.visual.properties.NodeShapeProp;
import cytoscape.visual.properties.NodeSizeProp;
import cytoscape.visual.properties.NodeToolTipProp;
import cytoscape.visual.properties.NodeWidthProp;
import cytoscape.visual.ui.EditorDisplayer;
import cytoscape.visual.ui.editors.continuous.ContinuousMappingEditorPanel;
import java.awt.Color;
import java.awt.Font;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum VisualPropertyType {
    NODE_FILL_COLOR("Node Color", "nodeFillColorCalculator", "node.fillColor", "defaultNodeFillColor", Color.class, new NodeFillColorProp(), new ColorParser(), true, true),
    NODE_BORDER_COLOR("Node Border Color", "nodeBorderColorCalculator", "node.borderColor", "defaultNodeBorderColor", Color.class, new NodeBorderColorProp(), new ColorParser(), true, true),
    NODE_LINETYPE("Node Line Type", "nodeLineTypeCalculator", "node.lineType", "defaultNodeLineType", LineType.class, new NodeLineTypeProp(), new LineTypeParser(), true, false),
    NODE_SHAPE("Node Shape", "nodeShapeCalculator", "node.shape", "defaultNodeShape", NodeShape.class, new NodeShapeProp(), new NodeShapeParser(), true, true),
    NODE_SIZE("Node Size", "nodeUniformSizeCalculator", "node.size", "defaultNodeSize", Number.class, new NodeSizeProp(), new DoubleParser(), true, true),
    NODE_WIDTH("Node Width", "nodeWidthCalculator", "node.width", "defaultNodeWidth", Number.class, new NodeWidthProp(), new DoubleParser(), true, true),
    NODE_HEIGHT("Node Height", "nodeHeightCalculator", "node.height", "defaultNodeHight", Number.class, new NodeHeightProp(), new DoubleParser(), true, true),
    NODE_LABEL("Node Label", "nodeLabelCalculator", "node.label", "defaultNodeLabel", String.class, new NodeLabelProp(), new StringParser(), true, true),
    NODE_FONT_FACE("Node Font Face", "nodeFontFaceCalculator", "node.font", "defaultNodeFont", Font.class, new NodeFontFaceProp(), new FontParser(), true, true),
    NODE_FONT_SIZE("Node Font Size", "nodeFontSizeCalculator", "node.fontSize", "defaultNodeFontSize", Number.class, new NodeFontSizeProp(), new DoubleParser(), true, true),
    NODE_LABEL_COLOR("Node Label Color", "nodeLabelColor", "node.labelColor", "defaultNodeLabelColor", Color.class, new NodeLabelColorProp(), new ColorParser(), true, true),
    NODE_TOOLTIP("Node Tooltip", "nodeTooltipCalculator", "node.toolTip", "defaultNodeToolTip", String.class, new NodeToolTipProp(), new StringParser(), true, true),
    NODE_LABEL_POSITION("Node Label Position", "nodeLabelPositionCalculator", "node.labelPosition", "defaultNodeLabelPosition", LabelPosition.class, new NodeLabelPositionProp(), new LabelPositionParser(), true, true),
    EDGE_COLOR("Edge Color", "edgeColorCalculator", "edge.color", "defaultEdgeColor", Color.class, new EdgeColorProp(), new ColorParser(), false, true),
    EDGE_LINETYPE("Edge Line Type", "edgeLineTypeCalculator", "edge.lineType", "defaultEdgeLineType", LineType.class, new EdgeLineTypeProp(), new LineTypeParser(), false, false),
    EDGE_SRCARROW("Edge Source Arrow", "edgeSourceArrowCalculator", "edge.sourceArrow", "defaultEdgeSourceArrow", Arrow.class, new EdgeSourceArrowProp(), new ArrowParser(), false, false),
    EDGE_TGTARROW("Edge Target Arrow", "edgeTargetArrowCalculator", "edge.targetArrow", "defaultEdgeTargetArrow", Arrow.class, new EdgeTargetArrowProp(), new ArrowParser(), false, false),
    EDGE_LABEL("Edge Label", "edgeLabelCalculator", "edge.label", "defaultEdgeLabel", String.class, new EdgeLabelProp(), new StringParser(), false, true),
    EDGE_FONT_FACE("Edge Font Face", "edgeFontFaceCalculator", "edge.font", "defaultEdgeFont", Font.class, new EdgeFontFaceProp(), new FontParser(), false, true),
    EDGE_FONT_SIZE("Edge Font Size", "edgeFontSizeCalculator", "edge.fontSize", "defaultEdgeFontSize", Number.class, new EdgeFontSizeProp(), new DoubleParser(), false, true),
    EDGE_LABEL_COLOR("Edge Label Color", "edgeLabelColorCalculator", "edge.labelColor", "defaultEdgeLabelColor", Color.class, new EdgeLabelColorProp(), new ColorParser(), false, true),
    EDGE_TOOLTIP("Edge Tooltip", "edgeTooltipCalculator", "edge.toolTip", "defaultEdgeToolTip", String.class, new EdgeToolTipProp(), new StringParser(), false, true),
    NODE_LINE_WIDTH("Node Line Width", "nodeLineWidthCalculator", "node.lineWidth", "defaultNodeLineWidth", Number.class, new NodeLineWidthProp(), new FloatParser(), true, true),
    EDGE_LINE_WIDTH("Edge Line Width", "edgeLineWidthCalculator", "edge.lineWidth", "defaultEdgeLineWidth", Number.class, new EdgeLineWidthProp(), new FloatParser(), false, true),
    NODE_LINE_STYLE("Node Line Style", "nodeLineStyleCalculator", "node.lineStyle", "defaultNodeLineStyle", LineStyle.class, new NodeLineStyleProp(), new LineStyleParser(), true, true),
    EDGE_LINE_STYLE("Edge Line Style", "edgeLineStyleCalculator", "edge.lineStyle", "defaultEdgeLineStyle", LineStyle.class, new EdgeLineStyleProp(), new LineStyleParser(), false, true),
    EDGE_SRCARROW_SHAPE("Edge Source Arrow Shape", "edgeSourceArrowShapeCalculator", "edge.sourceArrowShape", "defaultEdgeSourceArrowShape", ArrowShape.class, new EdgeSourceArrowShapeProp(), new ArrowShapeParser(), false, true),
    EDGE_TGTARROW_SHAPE("Edge Target Arrow Shape", "edgeTargetArrowShapeCalculator", "edge.targetArrowShape", "defaultEdgeTargetArrowShape", ArrowShape.class, new EdgeTargetArrowShapeProp(), new ArrowShapeParser(), false, true),
    EDGE_SRCARROW_COLOR("Edge Source Arrow Color", "edgeSourceArrowColorCalculator", "edge.sourceArrowColor", "defaultEdgeSourceArrowColor", Color.class, new EdgeSourceArrowColorProp(), new ColorParser(), false, true),
    EDGE_TGTARROW_COLOR("Edge Target Arrow Color", "edgeTargetArrowColorCalculator", "edge.targetArrowColor", "defaultEdgeTargetArrowColor", Color.class, new EdgeTargetArrowColorProp(), new ColorParser(), false, true),
    NODE_OPACITY("Node Opacity", "nodeOpacityCalculator", "node.opacity", "defaultNodeOpacity", Number.class, new NodeOpacityProp(), new FloatParser(), true, true),
    EDGE_OPACITY("Edge Opacity", "edgeOpacityCalculator", "edge.opacity", "defaultEdgeOpacity", Number.class, new EdgeOpacityProp(), new FloatParser(), false, true),
    NODE_LABEL_OPACITY("Node Label Opacity", "nodeLabelOpacityCalculator", "node.LabelOpacity", "defaultNodeLabelOpacity", Number.class, new NodeLabelOpacityProp(), new FloatParser(), true, true),
    EDGE_LABEL_OPACITY("Edge Label Opacity", "edgeLabelOpacityCalculator", "edge.labelOpacity", "defaultEdgeLabelOpacity", Number.class, new EdgeLabelOpacityProp(), new FloatParser(), false, true),
    NODE_BORDER_OPACITY("Node Border Opacity", "nodeBorderOpacityCalculator", "node.borderOpacity", "defaultNodeBorderOpacity", Number.class, new NodeBorderOpacityProp(), new FloatParser(), true, true),
    EDGE_SRCARROW_OPACITY("Edge Source Arrow Opacity", "edgeSourceArrowOpacityCalculator", "edge.sourceArrowOpacity", "defaultEdgeSourceArrowOpacity", Number.class, new EdgeSourceArrowOpacityProp(), new FloatParser(), false, true),
    EDGE_TGTARROW_OPACITY("Edge Target Arrow Opacity", "edgeTargetArrowOpacityCalculator", "edge.targetArrowOpacity", "defaultEdgeTargetArrowOpacity", Number.class, new EdgeTargetArrowOpacityProp(), new FloatParser(), false, true),
    EDGE_LABEL_POSITION("Edge Label Position", "edgeLabelPositionCalculator", "edge.labelPosition", "defaultEdgeLabelPosition", null, new EdgeLabelPositionProp(), new LabelPositionParser(), false, false);

    private final String calcName;
    private String propertyLabel;
    private String bypassAttrName;
    private String defaultPropertyLabel;
    private Class dataType;
    private VisualProperty vizProp;
    private ValueParser valueParser;
    private boolean isNodeProp;
    private boolean isAllowed;

    private VisualPropertyType(String calcName, String propertyLabel, String bypassAttrName, String defaultPropertyLabel, Class dataType, VisualProperty vizProp, ValueParser valueParser, boolean isNodeProp, boolean isAllowed) {
        this.calcName = calcName;
        this.propertyLabel = propertyLabel;
        this.bypassAttrName = bypassAttrName;
        this.defaultPropertyLabel = defaultPropertyLabel;
        this.dataType = dataType;
        this.vizProp = vizProp;
        this.valueParser = valueParser;
        this.isNodeProp = isNodeProp;
        this.isAllowed = isAllowed;
    }

    public String getName() {
        return this.calcName;
    }

    public String getPropertyLabel() {
        return this.propertyLabel;
    }

    public String getBypassAttrName() {
        return this.bypassAttrName;
    }

    public String getDefaultPropertyLabel() {
        return this.defaultPropertyLabel;
    }

    public String getDefaultPropertyKey(String baseKey) {
        return baseKey + "." + this.defaultPropertyLabel;
    }

    @Deprecated
    public byte getType() {
        return (byte)this.ordinal();
    }

    @Deprecated
    public static VisualPropertyType getVisualPorpertyType(byte type) {
        return VisualPropertyType.values()[type];
    }

    public Class getDataType() {
        return this.dataType;
    }

    public boolean isNodeProp() {
        return this.isNodeProp;
    }

    public boolean isAllowed() {
        return this.isAllowed;
    }

    public static List<VisualPropertyType> getNodeVisualPropertyList() {
        ArrayList<VisualPropertyType> list = new ArrayList<VisualPropertyType>();
        for (VisualPropertyType type : VisualPropertyType.values()) {
            if (!type.isNodeProp() || !type.isAllowed()) continue;
            list.add(type);
        }
        return list;
    }

    public static List<VisualPropertyType> getEdgeVisualPropertyList() {
        ArrayList<VisualPropertyType> list = new ArrayList<VisualPropertyType>();
        for (VisualPropertyType type : VisualPropertyType.values()) {
            if (type.isNodeProp() || !type.isAllowed()) continue;
            list.add(type);
        }
        return list;
    }

    private Object showEditor(EditorDisplayer action) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
        Method method = action.getActionClass().getMethod(action.getCommand(), action.getParamTypes());
        Object ret = method.invoke(null, action.getParameters());
        if (ret != null && ret instanceof ContinuousMappingEditorPanel) {
            return ret;
        }
        if (ret != null && this == EDGE_LINE_WIDTH) {
            try {
                ret = Float.valueOf((String)ret);
            }
            catch (NumberFormatException e) {
                ret = Float.valueOf(1.0f);
            }
        } else if (ret != null && action.getCompatibleClass() != ret.getClass()) {
            try {
                ret = Double.parseDouble(ret.toString());
            }
            catch (NumberFormatException e) {
                ret = 1.0;
            }
        }
        if ((this.name().toUpperCase().endsWith("WIDTH") || this.name().toUpperCase().endsWith("SIZE")) && ((Number)ret).doubleValue() < 0.0) {
            ret = Float.valueOf(1.0f);
        }
        if (this.name().toUpperCase().endsWith("OPACITY")) {
            if (((Number)ret).doubleValue() > 255.0) {
                ret = 255.0;
            } else if (((Number)ret).doubleValue() < 0.0) {
                ret = 0.0;
            }
        }
        return ret;
    }

    public Object showDiscreteEditor() throws Exception {
        return this.showEditor(EditorDisplayer.getEditor(this, EditorDisplayer.EditorType.DISCRETE));
    }

    public Object showContinuousEditor() throws Exception {
        EditorDisplayer editor = EditorDisplayer.getEditor(this, EditorDisplayer.EditorType.CONTINUOUS);
        if (editor == EditorDisplayer.CONTINUOUS_COLOR) {
            editor.setParameters(new Object[]{450, 180, "Gradient Editor for " + this.calcName, this});
        } else if (editor == EditorDisplayer.CONTINUOUS_CONTINUOUS) {
            editor.setParameters(new Object[]{450, 350, "Continuous Editor for " + this.calcName, this});
        } else {
            editor.setParameters(new Object[]{450, 300, "Continuous Editor for " + this.calcName, this});
        }
        return this.showEditor(editor);
    }

    public VisualProperty getVisualProperty() {
        return this.vizProp;
    }

    public Object getDefault(VisualStyle style) {
        if (style == null) {
            return null;
        }
        Appearance a = null;
        a = this.isNodeProp() ? style.getNodeAppearanceCalculator().getDefaultAppearance() : style.getEdgeAppearanceCalculator().getDefaultAppearance();
        return a.get(this);
    }

    public void setDefault(VisualStyle style, Object c) {
        if (style == null || c == null) {
            return;
        }
        if (this.isNodeProp()) {
            NodeAppearanceCalculator nodeCalc = style.getNodeAppearanceCalculator();
            NodeAppearance na = nodeCalc.getDefaultAppearance();
            na.set(this, c);
            nodeCalc.setDefaultAppearance(na);
        } else {
            EdgeAppearanceCalculator edgeCalc = style.getEdgeAppearanceCalculator();
            EdgeAppearance ea = edgeCalc.getDefaultAppearance();
            ea.set(this, c);
            edgeCalc.setDefaultAppearance(ea);
        }
    }

    public Calculator getCurrentCalculator(VisualStyle style) {
        if (style == null) {
            return null;
        }
        if (this.isNodeProp()) {
            return style.getNodeAppearanceCalculator().getCalculator(this);
        }
        return style.getEdgeAppearanceCalculator().getCalculator(this);
    }

    public void setCurrentCalculator(VisualStyle style, Calculator c) {
        if (style == null) {
            return;
        }
        if (this.isNodeProp()) {
            if (c == null) {
                style.getNodeAppearanceCalculator().removeCalculator(this);
            } else {
                style.getNodeAppearanceCalculator().setCalculator(c);
            }
        } else if (c == null) {
            style.getEdgeAppearanceCalculator().removeCalculator(this);
        } else {
            style.getEdgeAppearanceCalculator().setCalculator(c);
        }
    }

    public ValueParser getValueParser() {
        return this.valueParser;
    }
}

