/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual;

import cytoscape.visual.ui.icon.NodeIcon;
import ding.view.DGraphView;
import java.awt.Shape;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum NodeShape {
    RECT(6, "Rectangle", true),
    ROUND_RECT(7, "Round Rectangle", true),
    RECT_3D(6, "3D Rectabgle", false),
    TRAPEZOID(6, "Trapezoid", false),
    TRAPEZOID_2(6, "Trapezoid 2", false),
    TRIANGLE(0, "Triangle", true),
    PARALLELOGRAM(5, "Parallelogram", true),
    DIAMOND(1, "Diamond", true),
    ELLIPSE(2, "Ellipse", true),
    HEXAGON(3, "Hexagon", true),
    OCTAGON(4, "Octagon", true);

    private int ginyShape;
    private String name;
    private boolean isSupported;
    private static Map<Integer, Shape> nodeShapes;

    private NodeShape(int ginyShape, String name, boolean isSupported) {
        this.ginyShape = ginyShape;
        this.name = name;
        this.isSupported = isSupported;
    }

    public boolean isSupported() {
        return this.isSupported;
    }

    public static NodeShape parseNodeShapeText(String text) {
        String trimed = text.trim();
        for (NodeShape shape : NodeShape.values()) {
            if (!NodeShape.getNodeShapeText(shape).equalsIgnoreCase(trimed)) continue;
            return shape;
        }
        return RECT;
    }

    public static String[] valuesAsString() {
        int length = NodeShape.values().length;
        String[] nameArray = new String[length];
        for (int i = 0; i < length; ++i) {
            nameArray[i] = NodeShape.values()[i].getShapeName();
        }
        return nameArray;
    }

    public String getShapeName() {
        return this.name;
    }

    public static boolean isValidShape(NodeShape type) {
        for (NodeShape curType : NodeShape.values()) {
            if (type != curType) continue;
            return true;
        }
        return false;
    }

    public static String getNodeShapeText(NodeShape shape) {
        String nstext = shape.name();
        nstext = nstext.replaceAll("_", "");
        return nstext.toLowerCase();
    }

    public int getGinyShape() {
        return this.ginyShape;
    }

    public static NodeShape getNodeShape(int ginyShape) {
        for (NodeShape shape : NodeShape.values()) {
            if (shape.ginyShape != ginyShape) continue;
            return shape;
        }
        return RECT;
    }

    public Shape getShape() {
        return nodeShapes.get(this.ginyShape);
    }

    public static Map<Object, Icon> getIconSet() {
        HashMap<Object, Icon> nodeShapeIcons = new HashMap<Object, Icon>();
        for (NodeShape shape : NodeShape.values()) {
            NodeIcon icon = new NodeIcon(nodeShapes.get(shape.getGinyShape()), 32, 32, shape.getShapeName());
            nodeShapeIcons.put((Object)shape, icon);
        }
        return nodeShapeIcons;
    }

    static {
        nodeShapes = DGraphView.getNodeShapes();
    }
}

