/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual;

import cytoscape.visual.ui.icon.LineTypeIcon;
import java.awt.BasicStroke;
import java.awt.Stroke;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum LineStyle {
    SOLID(null, "line"),
    LONG_DASH("10.0f,4.0f", "dash");

    private final float[] strokeDef;
    private String regex;
    private static Pattern numPattern;

    private LineStyle(String def, String regex) {
        if (def == null) {
            this.strokeDef = null;
        } else {
            String[] parts = def.split(",");
            this.strokeDef = new float[parts.length];
            for (int i = 0; i < this.strokeDef.length; ++i) {
                this.strokeDef[i] = Float.parseFloat(parts[i]);
            }
        }
        this.regex = regex;
    }

    private String getRegex() {
        return this.regex;
    }

    public static LineStyle parse(String val) {
        for (LineStyle ls : LineStyle.values()) {
            if (!ls.toString().equals(val)) continue;
            return ls;
        }
        for (LineStyle ls : LineStyle.values()) {
            Pattern p = Pattern.compile(ls.getRegex(), 2);
            Matcher m = p.matcher(val);
            if (!m.matches()) continue;
            return ls;
        }
        return SOLID;
    }

    public static float parseWidth(String s) {
        Matcher m = numPattern.matcher(s);
        if (m.matches()) {
            try {
                return new Float(m.group(1)).floatValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 1.0f;
    }

    public static LineStyle extractLineStyle(Stroke stroke) {
        if (stroke instanceof BasicStroke) {
            float[] dash = ((BasicStroke)stroke).getDashArray();
            if (dash == null) {
                return SOLID;
            }
            return LONG_DASH;
        }
        return SOLID;
    }

    public Stroke getStroke(float width) {
        if (this.strokeDef != null) {
            return new BasicStroke(width, 1, 0, 10.0f, this.strokeDef, 0.0f);
        }
        return new BasicStroke(width);
    }

    public float[] getDashDef() {
        return this.strokeDef;
    }

    public static Map<Object, Icon> getIconSet() {
        HashMap<Object, Icon> icons = new HashMap<Object, Icon>();
        for (LineStyle def : LineStyle.values()) {
            LineTypeIcon icon = new LineTypeIcon((BasicStroke)def.getStroke(5.0f), 128, 32, def.name());
            icons.put((Object)def, icon);
        }
        return icons;
    }

    static {
        numPattern = Pattern.compile("(\\d+)");
    }
}

