/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual;

import cytoscape.logger.CyLogger;
import cytoscape.visual.Arrow;
import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.EdgeAppearanceCalculator;
import cytoscape.visual.GlobalAppearanceCalculator;
import cytoscape.visual.NodeAppearanceCalculator;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.VisualStyle;
import cytoscape.visual.calculators.Calculator;
import cytoscape.visual.calculators.CalculatorFactory;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalculatorIO {
    private static final List<String> OLD_CALC_KEYS;
    private static CyLogger logger;
    private static final String nodeColorBaseKey = "nodeColorCalculator";
    private static final String nodeSizeBaseKey = "nodeSizeCalculator";
    private static final String edgeArrowBaseKey = "edgeArrowCalculator";
    private static final String nodeAppearanceBaseKey = "nodeAppearanceCalculator";
    private static final String edgeAppearanceBaseKey = "edgeAppearanceCalculator";
    private static final String globalAppearanceBaseKey = "globalAppearanceCalculator";

    public static void storeCatalog(CalculatorCatalog catalog, File outFile) throws IOException {
        FileWriter writer = new FileWriter(outFile);
        CalculatorIO.storeCatalog(catalog, writer);
        ((Writer)writer).close();
    }

    public static void storeCatalog(CalculatorCatalog catalog, Writer writer) throws IOException {
        String lineSep = System.getProperty("line.separator");
        StringBuffer header = new StringBuffer();
        header.append("This file specifies visual mappings for Cytoscape");
        header.append(" and has been automatically generated.").append(lineSep);
        header.append("# WARNING: any changes you make to this file while");
        header.append(" Cytoscape is running may be overwritten.").append(lineSep);
        header.append("# Any changes may make these visual mappings unreadable.");
        header.append(lineSep);
        header.append("# Please make sure you know what you are doing before");
        header.append(" modifying this file by hand.").append(lineSep);
        Properties props = CalculatorIO.getProperties(catalog);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        props.store(buffer, header.toString());
        BufferedReader reader = new BufferedReader(new StringReader(buffer.toString()));
        ArrayList<String> headerLines = new ArrayList<String>();
        ArrayList<String> lines = new ArrayList<String>();
        String oneLine = reader.readLine();
        while (oneLine != null) {
            if (oneLine.startsWith("#")) {
                headerLines.add(oneLine);
            } else {
                boolean test = true;
                for (String key : OLD_CALC_KEYS) {
                    if (!oneLine.toUpperCase().contains(key)) continue;
                    test = false;
                    break;
                }
                if (test) {
                    lines.add(oneLine);
                }
            }
            oneLine = reader.readLine();
        }
        buffer.close();
        reader.close();
        Collections.sort(lines);
        for (String theLine : headerLines) {
            writer.write(theLine, 0, theLine.length());
            writer.write(lineSep);
        }
        for (String theLine : lines) {
            writer.write(theLine, 0, theLine.length());
            writer.write(lineSep);
        }
        writer.flush();
    }

    public static Properties getProperties(CalculatorCatalog catalog) {
        Properties newProps = new Properties();
        for (Calculator c : catalog.getCalculators()) {
            newProps.putAll((Map<?, ?>)c.getProperties());
        }
        Set<String> visualStyleNames = catalog.getVisualStyleNames();
        for (String name : visualStyleNames) {
            VisualStyle vs = catalog.getVisualStyle(name);
            Properties styleProps = new Properties();
            try {
                styleProps.putAll((Map<?, ?>)vs.getNodeAppearanceCalculator().getProperties("nodeAppearanceCalculator." + name));
                styleProps.putAll((Map<?, ?>)vs.getEdgeAppearanceCalculator().getProperties("edgeAppearanceCalculator." + name));
                styleProps.putAll((Map<?, ?>)vs.getGlobalAppearanceCalculator().getProperties("globalAppearanceCalculator." + name));
                newProps.putAll((Map<?, ?>)styleProps);
            }
            catch (Exception e) {
                logger.info("Exception while saving visual style '" + name + "': " + e.getMessage());
            }
        }
        return newProps;
    }

    public static void loadCalculators(Properties props, CalculatorCatalog catalog) {
        CalculatorIO.loadCalculators(props, catalog, true);
    }

    public static void loadCalculators(Properties props, CalculatorCatalog catalog, boolean overWrite) {
        VisualStyle vs;
        HashMap<String, Map<String, Properties>> calcNames = new HashMap<String, Map<String, Properties>>();
        Enumeration<?> eI = props.propertyNames();
        while (eI.hasMoreElements()) {
            String key = (String)eI.nextElement();
            if (key.startsWith("nodeColorCalculator.")) {
                key = CalculatorIO.updateLegacyKey(key, props, nodeColorBaseKey, VisualPropertyType.NODE_FILL_COLOR.getPropertyLabel(), "cytoscape.visual.calculators.GenericNodeFillColorCalculator");
                CalculatorIO.storeKey(key, props, calcNames);
                key = CalculatorIO.updateLegacyKey(key, props, VisualPropertyType.NODE_FILL_COLOR.getPropertyLabel(), VisualPropertyType.NODE_BORDER_COLOR.getPropertyLabel(), "cytoscape.visual.calculators.GenericNodeBorderColorCalculator");
                CalculatorIO.storeKey(key, props, calcNames);
                continue;
            }
            if (key.startsWith("nodeSizeCalculator.")) {
                key = CalculatorIO.updateLegacyKey(key, props, nodeSizeBaseKey, VisualPropertyType.NODE_SIZE.getPropertyLabel(), "cytoscape.visual.calculators.GenericNodeUniformSizeCalculator");
                CalculatorIO.storeKey(key, props, calcNames);
                key = CalculatorIO.updateLegacyKey(key, props, VisualPropertyType.NODE_SIZE.getPropertyLabel(), VisualPropertyType.NODE_WIDTH.getPropertyLabel(), "cytoscape.visual.calculators.GenericNodeWidthCalculator");
                CalculatorIO.storeKey(key, props, calcNames);
                key = CalculatorIO.updateLegacyKey(key, props, VisualPropertyType.NODE_WIDTH.getPropertyLabel(), VisualPropertyType.NODE_HEIGHT.getPropertyLabel(), "cytoscape.visual.calculators.GenericNodeHeightCalculator");
                CalculatorIO.storeKey(key, props, calcNames);
                continue;
            }
            if (key.startsWith("edgeArrowCalculator.")) {
                key = CalculatorIO.updateLegacyKey(key, props, edgeArrowBaseKey, VisualPropertyType.EDGE_SRCARROW.getPropertyLabel(), "cytoscape.visual.calculators.GenericEdgeSourceArrowCalculator");
                CalculatorIO.storeKey(key, props, calcNames);
                key = CalculatorIO.updateLegacyKey(key, props, VisualPropertyType.EDGE_SRCARROW.getPropertyLabel(), VisualPropertyType.EDGE_TGTARROW.getPropertyLabel(), "cytoscape.visual.calculators.GenericEdgeTargetArrowCalculator");
                CalculatorIO.storeKey(key, props, calcNames);
                key = CalculatorIO.updateLegacyKey(key, props, VisualPropertyType.EDGE_TGTARROW.getPropertyLabel(), VisualPropertyType.EDGE_SRCARROW_COLOR.getPropertyLabel(), "cytoscape.visual.calculators.GenericEdgeSourceArrowColorCalculator");
                CalculatorIO.storeKey(key, props, calcNames);
                key = CalculatorIO.updateLegacyKey(key, props, VisualPropertyType.EDGE_SRCARROW_COLOR.getPropertyLabel(), VisualPropertyType.EDGE_SRCARROW_SHAPE.getPropertyLabel(), "cytoscape.visual.calculators.GenericEdgeSourceArrowShapeCalculator");
                CalculatorIO.storeKey(key, props, calcNames);
                key = CalculatorIO.updateLegacyKey(key, props, VisualPropertyType.EDGE_SRCARROW_SHAPE.getPropertyLabel(), VisualPropertyType.EDGE_TGTARROW_COLOR.getPropertyLabel(), "cytoscape.visual.calculators.GenericEdgeTargetArrowColorCalculator");
                CalculatorIO.storeKey(key, props, calcNames);
                key = CalculatorIO.updateLegacyKey(key, props, VisualPropertyType.EDGE_TGTARROW_COLOR.getPropertyLabel(), VisualPropertyType.EDGE_TGTARROW_SHAPE.getPropertyLabel(), "cytoscape.visual.calculators.GenericEdgeTargetArrowShapeCalculator");
                CalculatorIO.storeKey(key, props, calcNames);
                continue;
            }
            if (key.startsWith(VisualPropertyType.EDGE_SRCARROW.getPropertyLabel() + ".")) {
                key = CalculatorIO.updateLegacyKey(key, props, VisualPropertyType.EDGE_SRCARROW.getPropertyLabel(), VisualPropertyType.EDGE_SRCARROW_COLOR.getPropertyLabel(), "cytoscape.visual.calculators.GenericEdgeSourceArrowColorCalculator");
                CalculatorIO.storeKey(key, props, calcNames);
                key = CalculatorIO.updateLegacyKey(key, props, VisualPropertyType.EDGE_SRCARROW_COLOR.getPropertyLabel(), VisualPropertyType.EDGE_SRCARROW_SHAPE.getPropertyLabel(), "cytoscape.visual.calculators.GenericEdgeSourceArrowShapeCalculator");
                CalculatorIO.storeKey(key, props, calcNames);
                continue;
            }
            if (key.startsWith(VisualPropertyType.EDGE_TGTARROW.getPropertyLabel() + ".")) {
                key = CalculatorIO.updateLegacyKey(key, props, VisualPropertyType.EDGE_TGTARROW.getPropertyLabel(), VisualPropertyType.EDGE_TGTARROW_COLOR.getPropertyLabel(), "cytoscape.visual.calculators.GenericEdgeTargetArrowColorCalculator");
                CalculatorIO.storeKey(key, props, calcNames);
                key = CalculatorIO.updateLegacyKey(key, props, VisualPropertyType.EDGE_TGTARROW_COLOR.getPropertyLabel(), VisualPropertyType.EDGE_TGTARROW_SHAPE.getPropertyLabel(), "cytoscape.visual.calculators.GenericEdgeTargetArrowShapeCalculator");
                CalculatorIO.storeKey(key, props, calcNames);
                continue;
            }
            if (key.startsWith(VisualPropertyType.EDGE_LINETYPE.getPropertyLabel() + ".")) {
                key = CalculatorIO.updateLegacyKey(key, props, VisualPropertyType.EDGE_LINETYPE.getPropertyLabel(), VisualPropertyType.EDGE_LINE_STYLE.getPropertyLabel(), "cytoscape.visual.calculators.GenericEdgeLineStyleCalculator");
                CalculatorIO.storeKey(key, props, calcNames);
                key = CalculatorIO.updateLegacyKey(key, props, VisualPropertyType.EDGE_LINE_STYLE.getPropertyLabel(), VisualPropertyType.EDGE_LINE_WIDTH.getPropertyLabel(), "cytoscape.visual.calculators.GenericEdgeLineWidthCalculator");
                CalculatorIO.storeKey(key, props, calcNames);
                continue;
            }
            if (key.startsWith(VisualPropertyType.NODE_LINETYPE.getPropertyLabel() + ".")) {
                key = CalculatorIO.updateLegacyKey(key, props, VisualPropertyType.NODE_LINETYPE.getPropertyLabel(), VisualPropertyType.NODE_LINE_STYLE.getPropertyLabel(), "cytoscape.visual.calculators.GenericNodeLineStyleCalculator");
                CalculatorIO.storeKey(key, props, calcNames);
                key = CalculatorIO.updateLegacyKey(key, props, VisualPropertyType.NODE_LINE_STYLE.getPropertyLabel(), VisualPropertyType.NODE_LINE_WIDTH.getPropertyLabel(), "cytoscape.visual.calculators.GenericNodeLineWidthCalculator");
                CalculatorIO.storeKey(key, props, calcNames);
                continue;
            }
            if (key.endsWith(VisualPropertyType.EDGE_TGTARROW.getPropertyLabel())) {
                key = CalculatorIO.updateLegacyKey(key, props, VisualPropertyType.EDGE_TGTARROW.getPropertyLabel(), VisualPropertyType.EDGE_TGTARROW_SHAPE.getPropertyLabel(), "cytoscape.visual.calculators.GenericEdgeTargetArrowShapeCalculator");
                CalculatorIO.storeKey(key, props, calcNames);
                continue;
            }
            if (key.endsWith(VisualPropertyType.EDGE_SRCARROW.getPropertyLabel())) {
                key = CalculatorIO.updateLegacyKey(key, props, VisualPropertyType.EDGE_SRCARROW.getPropertyLabel(), VisualPropertyType.EDGE_SRCARROW_SHAPE.getPropertyLabel(), "cytoscape.visual.calculators.GenericEdgeSourceArrowShapeCalculator");
                CalculatorIO.storeKey(key, props, calcNames);
                continue;
            }
            if (key.endsWith(VisualPropertyType.EDGE_LINETYPE.getPropertyLabel())) {
                key = CalculatorIO.updateLegacyKey(key, props, VisualPropertyType.EDGE_LINETYPE.getPropertyLabel(), VisualPropertyType.EDGE_LINE_STYLE.getPropertyLabel(), "cytoscape.visual.calculators.GenericEdgeLineStyleCalculator");
                CalculatorIO.storeKey(key, props, calcNames);
                continue;
            }
            if (key.endsWith(VisualPropertyType.NODE_LINETYPE.getPropertyLabel())) {
                key = CalculatorIO.updateLegacyKey(key, props, VisualPropertyType.NODE_LINETYPE.getPropertyLabel(), VisualPropertyType.NODE_LINE_STYLE.getPropertyLabel(), "cytoscape.visual.calculators.GenericNodeLineStyleCalculator");
                CalculatorIO.storeKey(key, props, calcNames);
                continue;
            }
            if (key.endsWith(VisualPropertyType.NODE_LINETYPE.getDefaultPropertyLabel())) {
                key = CalculatorIO.updateLegacyKey(key, props, VisualPropertyType.NODE_LINETYPE.getDefaultPropertyLabel(), VisualPropertyType.NODE_LINE_STYLE.getDefaultPropertyLabel(), "cytoscape.visual.calculators.GenericNodeLineStyleCalculator");
                CalculatorIO.storeKey(key, props, calcNames);
                continue;
            }
            if (key.endsWith(VisualPropertyType.EDGE_LINETYPE.getDefaultPropertyLabel())) {
                key = CalculatorIO.updateLegacyKey(key, props, VisualPropertyType.EDGE_LINETYPE.getDefaultPropertyLabel(), VisualPropertyType.EDGE_LINE_STYLE.getDefaultPropertyLabel(), "cytoscape.visual.calculators.GenericEdgeLineStyleCalculator");
                CalculatorIO.storeKey(key, props, calcNames);
                continue;
            }
            if (key.endsWith(VisualPropertyType.EDGE_TGTARROW.getDefaultPropertyLabel())) {
                key = CalculatorIO.updateLegacyKey(key, props, VisualPropertyType.EDGE_TGTARROW.getDefaultPropertyLabel(), VisualPropertyType.EDGE_TGTARROW_SHAPE.getDefaultPropertyLabel(), "cytoscape.visual.calculators.GenericEdgeTargetArrowShapeCalculator");
                CalculatorIO.storeKey(key, props, calcNames);
                continue;
            }
            if (key.endsWith(VisualPropertyType.EDGE_SRCARROW.getDefaultPropertyLabel())) {
                key = CalculatorIO.updateLegacyKey(key, props, VisualPropertyType.EDGE_SRCARROW.getDefaultPropertyLabel(), VisualPropertyType.EDGE_SRCARROW_SHAPE.getDefaultPropertyLabel(), "cytoscape.visual.calculators.GenericEdgeSourceArrowShapeCalculator");
                CalculatorIO.storeKey(key, props, calcNames);
                continue;
            }
            CalculatorIO.storeKey(key, props, calcNames);
        }
        for (String calcTypeKey : calcNames.keySet()) {
            CalculatorIO.handleCalculators((Map)calcNames.get(calcTypeKey), catalog, overWrite, calcTypeKey);
        }
        HashMap<String, VisualStyle> visualStyles = new HashMap<String, VisualStyle>();
        Map nacNames = (Map)calcNames.get(nodeAppearanceBaseKey);
        for (String name : nacNames.keySet()) {
            vs = (VisualStyle)visualStyles.get(name);
            if (vs == null) {
                vs = new VisualStyle(name);
                visualStyles.put(name, vs);
            }
            vs.setNodeAppearanceCalculator(new NodeAppearanceCalculator(name, (Properties)nacNames.get(name), "nodeAppearanceCalculator." + name, catalog));
        }
        Map eacNames = (Map)calcNames.get(edgeAppearanceBaseKey);
        for (String name : eacNames.keySet()) {
            vs = (VisualStyle)visualStyles.get(name);
            if (vs == null) {
                vs = new VisualStyle(name);
                visualStyles.put(name, vs);
            }
            vs.setEdgeAppearanceCalculator(new EdgeAppearanceCalculator(name, (Properties)eacNames.get(name), "edgeAppearanceCalculator." + name, catalog));
        }
        Map gacNames = (Map)calcNames.get(globalAppearanceBaseKey);
        for (String name : gacNames.keySet()) {
            vs = (VisualStyle)visualStyles.get(name);
            if (vs == null) {
                vs = new VisualStyle(name);
                visualStyles.put(name, vs);
            }
            vs.setGlobalAppearanceCalculator(new GlobalAppearanceCalculator(name, (Properties)gacNames.get(name), "globalAppearanceCalculator." + name, catalog));
        }
        for (VisualStyle visualStyle : visualStyles.values()) {
            catalog.addVisualStyle(visualStyle);
        }
    }

    private static void storeKey(String key, Properties props, Map<String, Map<String, Properties>> calcNames) {
        String name;
        String calcTypeKey = CalculatorIO.extractCalcType(key);
        if (calcTypeKey == null) {
            logger.warn("couldn't parse calcTypeKey from '" + key + "'");
            return;
        }
        Map<String, Properties> name2props = calcNames.get(calcTypeKey);
        if (name2props == null) {
            name2props = new HashMap<String, Properties>();
            calcNames.put(calcTypeKey, name2props);
        }
        if ((name = CalculatorIO.extractName(key)) != null) {
            Properties calcProps = name2props.get(name);
            if (calcProps == null) {
                calcProps = new Properties();
                name2props.put(name, calcProps);
            }
            calcProps.setProperty(key, props.getProperty(key));
        }
    }

    private static String extractName(String key) {
        if (key == null) {
            return null;
        }
        int dot1 = key.indexOf(".");
        if (dot1 == -1 || dot1 >= key.length() - 1) {
            return null;
        }
        int dot2 = key.indexOf(".", dot1 + 1);
        if (dot2 == -1) {
            return null;
        }
        return key.substring(dot1 + 1, dot2);
    }

    private static String extractCalcType(String key) {
        if (key == null) {
            return null;
        }
        int dot1 = key.indexOf(".");
        if (dot1 == -1 || dot1 >= key.length() - 1) {
            return null;
        }
        return key.substring(0, dot1);
    }

    private static void handleCalculators(Map<String, Properties> nameMap, CalculatorCatalog catalog, boolean overWrite, String calcTypeKey) {
        for (String name : nameMap.keySet()) {
            Calculator c = CalculatorFactory.newCalculator(name, nameMap.get(name), calcTypeKey + "." + name);
            if (c == null) continue;
            if (overWrite) {
                catalog.removeCalculator(c);
            } else {
                CalculatorIO.renameAsNeeded(c, catalog);
            }
            catalog.addCalculator(c);
        }
    }

    public static void renameAsNeeded(Calculator c, CalculatorCatalog catalog) {
        String name = ((Object)c).toString();
        String newName = catalog.checkCalculatorName(c.getVisualPropertyType(), name);
        if (!newName.equals(name)) {
            c.setName(newName);
        }
    }

    private static String updateLegacyKey(String key, Properties props, String oldKey, String newKey, String newClass) {
        String value = props.getProperty(key);
        if ((key.endsWith("equal") || key.endsWith("greater") || key.endsWith("lesser")) && (key.startsWith(VisualPropertyType.EDGE_TGTARROW.getPropertyLabel() + ".") || key.startsWith(VisualPropertyType.EDGE_SRCARROW.getPropertyLabel() + "."))) {
            value = Arrow.parseArrowText(value).getShape().toString();
        }
        if (key.endsWith(VisualPropertyType.EDGE_TGTARROW.getDefaultPropertyLabel()) || key.endsWith(VisualPropertyType.EDGE_SRCARROW.getDefaultPropertyLabel())) {
            value = Arrow.parseArrowText(value).getShape().toString();
        }
        if ((key = key.replace(oldKey, newKey)).endsWith(".class")) {
            props.setProperty(key, newClass);
        } else {
            props.setProperty(key, value);
        }
        return key;
    }

    static {
        logger = CyLogger.getLogger(CalculatorIO.class);
        OLD_CALC_KEYS = new ArrayList<String>();
        OLD_CALC_KEYS.add("EDGELINETYPE");
        OLD_CALC_KEYS.add("NODELINETYPE");
        OLD_CALC_KEYS.add(VisualPropertyType.EDGE_SRCARROW.getDefaultPropertyLabel().toUpperCase() + "=");
        OLD_CALC_KEYS.add(VisualPropertyType.EDGE_TGTARROW.getDefaultPropertyLabel().toUpperCase() + "=");
    }
}

