/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual;

import cytoscape.logger.CyLogger;
import cytoscape.visual.Appearance;
import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.calculators.Calculator;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AppearanceCalculator
implements Cloneable {
    protected List<Calculator> calcs = new ArrayList<Calculator>();
    protected Appearance tmpDefaultAppearance;

    public Object clone() {
        Object copy = null;
        try {
            copy = super.clone();
        }
        catch (CloneNotSupportedException e) {
            CyLogger.getLogger().warn("Error cloning!");
        }
        return copy;
    }

    public Object clone(String vsName) {
        Object copy = null;
        CyLogger.getLogger().info("====Cloning: " + this.toString());
        try {
            copy = super.clone();
        }
        catch (CloneNotSupportedException e) {
            CyLogger.getLogger().warn("Error cloning!");
        }
        return copy;
    }

    public AppearanceCalculator() {
    }

    public AppearanceCalculator(String name, Properties nacProps, String baseKey, CalculatorCatalog catalog, Appearance appr) {
        this.tmpDefaultAppearance = appr;
        this.applyProperties(appr, name, nacProps, baseKey, catalog);
    }

    public AppearanceCalculator(AppearanceCalculator toCopy) {
        if (toCopy == null) {
            return;
        }
        for (Calculator c : toCopy.getCalculators()) {
            CyLogger.getLogger().info("New calc = " + ((Object)c).toString());
            this.setCalculator(c);
        }
        this.copyDefaultAppearance(toCopy);
    }

    @Deprecated
    public Calculator getCalculator(byte type) {
        return this.getCalculator(VisualPropertyType.getVisualPorpertyType(type));
    }

    public Calculator getCalculator(VisualPropertyType type) {
        for (Calculator nc : this.calcs) {
            if (nc.getVisualPropertyType() != type) continue;
            return nc;
        }
        return null;
    }

    public List<Calculator> getCalculators() {
        return this.calcs;
    }

    @Deprecated
    public void removeCalculator(byte type) {
        this.removeCalculator(VisualPropertyType.getVisualPorpertyType(type));
    }

    public void removeCalculator(VisualPropertyType type) {
        Calculator toBeRemoved = null;
        for (Calculator c : this.calcs) {
            if (c.getVisualPropertyType() != type) continue;
            toBeRemoved = c;
            break;
        }
        this.calcs.remove(toBeRemoved);
    }

    public void setCalculator(Calculator c) {
        if (c == null) {
            return;
        }
        Calculator toReplace = null;
        for (Calculator nc : this.calcs) {
            if (nc.getVisualPropertyType() != c.getVisualPropertyType()) continue;
            toReplace = nc;
            break;
        }
        if (toReplace != null) {
            this.calcs.remove(toReplace);
        }
        this.calcs.add(c);
    }

    protected String getDescription(String name, Appearance defaultAppr) {
        String lineSep = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        sb.append(name + ":" + lineSep);
        sb.append(defaultAppr.getDescription("default")).append(lineSep);
        for (Calculator c : this.calcs) {
            sb.append(((Object)c).toString()).append(lineSep);
        }
        return sb.toString();
    }

    protected void applyProperties(Appearance appr, String name, Properties nacProps, String baseKey, CalculatorCatalog catalog) {
        String value = null;
        appr.applyDefaultProperties(nacProps, baseKey);
        for (VisualPropertyType type : catalog.getCalculatorTypes()) {
            for (Calculator c : catalog.getCalculators(type)) {
                value = nacProps.getProperty(baseKey + "." + c.getVisualPropertyType().getPropertyLabel());
                Calculator newCalc = catalog.getCalculator(c.getVisualPropertyType(), value);
                this.setCalculator(newCalc);
            }
        }
    }

    protected Properties getProperties(Appearance appr, String baseKey) {
        String key = null;
        String value = null;
        Properties newProps = appr.getDefaultProperties(baseKey);
        for (Calculator c : this.calcs) {
            key = baseKey + "." + c.getVisualPropertyType().getPropertyLabel();
            value = ((Object)c).toString();
            newProps.setProperty(key, value);
        }
        return newProps;
    }

    protected abstract void copyDefaultAppearance(AppearanceCalculator var1);
}

