/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual;

import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.parsers.ObjectToString;
import cytoscape.visual.parsers.ValueParser;
import giny.model.Edge;
import giny.model.GraphObject;
import giny.model.Node;
import giny.view.EdgeView;
import giny.view.NodeView;
import java.awt.Color;
import java.util.Properties;

public class Appearance {
    private static final String NODE_SIZE_LOCKED = ".nodeSizeLocked";
    protected Object[] vizProps = new Object[VisualPropertyType.values().length];
    protected boolean nodeSizeLocked = true;

    public Appearance() {
        for (VisualPropertyType type : VisualPropertyType.values()) {
            this.vizProps[type.ordinal()] = type.getVisualProperty().getDefaultAppearanceObject();
        }
    }

    public void set(VisualPropertyType p, Object o) {
        if (o != null) {
            this.vizProps[p.ordinal()] = o;
        }
    }

    public Object get(VisualPropertyType p) {
        return this.vizProps[p.ordinal()];
    }

    public void applyAppearance(NodeView nodeView) {
        for (VisualPropertyType type : VisualPropertyType.values()) {
            if (type == VisualPropertyType.NODE_SIZE) {
                if (!this.nodeSizeLocked) continue;
                type.getVisualProperty().applyToNodeView(nodeView, this.vizProps[type.ordinal()]);
                continue;
            }
            if (type == VisualPropertyType.NODE_WIDTH || type == VisualPropertyType.NODE_HEIGHT) {
                if (this.nodeSizeLocked) continue;
                type.getVisualProperty().applyToNodeView(nodeView, this.vizProps[type.ordinal()]);
                continue;
            }
            type.getVisualProperty().applyToNodeView(nodeView, this.vizProps[type.ordinal()]);
        }
    }

    public void applyAppearance(EdgeView edgeView) {
        for (VisualPropertyType type : VisualPropertyType.values()) {
            type.getVisualProperty().applyToEdgeView(edgeView, this.vizProps[type.ordinal()]);
        }
    }

    public void applyDefaultProperties(Properties nacProps, String baseKey) {
        for (VisualPropertyType type : VisualPropertyType.values()) {
            Object o = type.getVisualProperty().parseProperty(nacProps, baseKey);
            if (o == null) continue;
            this.vizProps[type.ordinal()] = o;
        }
        String lockKey = baseKey + NODE_SIZE_LOCKED;
        String lockVal = nacProps.getProperty(lockKey);
        if (lockVal == null || lockVal.equalsIgnoreCase("true")) {
            this.setNodeSizeLocked(true);
        } else {
            this.setNodeSizeLocked(false);
        }
    }

    public Properties getDefaultProperties(String baseKey) {
        Properties props = new Properties();
        for (VisualPropertyType type : VisualPropertyType.values()) {
            String key = type.getDefaultPropertyKey(baseKey);
            String value = ObjectToString.getStringValue(this.vizProps[type.ordinal()]);
            if (key == null || value == null) continue;
            props.setProperty(key, value);
        }
        String lockKey = baseKey + NODE_SIZE_LOCKED;
        String lockVal = new Boolean(this.getNodeSizeLocked()).toString();
        props.setProperty(lockKey, lockVal);
        return props;
    }

    public String getDescription(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        String lineSep = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        for (VisualPropertyType type : VisualPropertyType.values()) {
            if (this.vizProps[type.ordinal()] == null) continue;
            sb.append(prefix);
            sb.append(type.getName());
            sb.append(" = ");
            sb.append(ObjectToString.getStringValue(this.vizProps[type.ordinal()]));
            sb.append(lineSep);
        }
        return sb.toString();
    }

    public String getDescription() {
        return this.getDescription(null);
    }

    public void copy(Appearance na) {
        boolean actualLockState = na.getNodeSizeLocked();
        this.setNodeSizeLocked(false);
        na.setNodeSizeLocked(false);
        for (VisualPropertyType type : VisualPropertyType.values()) {
            this.vizProps[type.ordinal()] = na.get(type);
        }
        this.setNodeSizeLocked(actualLockState);
        na.setNodeSizeLocked(actualLockState);
    }

    public Object clone() {
        Appearance ga = new Appearance();
        ga.copy(this);
        return ga;
    }

    public void applyBypass(GraphObject n) {
        if (n == null) {
            return;
        }
        String id = n.getIdentifier();
        CyAttributes attrs = null;
        if (n instanceof Node) {
            attrs = Cytoscape.getNodeAttributes();
        } else if (n instanceof Edge) {
            attrs = Cytoscape.getEdgeAttributes();
        } else {
            return;
        }
        for (VisualPropertyType type : VisualPropertyType.values()) {
            Object bypass = Appearance.getBypass(attrs, id, type);
            if (bypass == null) continue;
            this.vizProps[type.ordinal()] = bypass;
        }
    }

    static Object getBypass(CyAttributes attrs, String id, VisualPropertyType type) {
        String attrName = type.getBypassAttrName();
        String value = attrs.getStringAttribute(id, attrName);
        if (value == null) {
            return null;
        }
        ValueParser p = type.getValueParser();
        Object ret = null;
        if (p == null) {
            return null;
        }
        ret = p.parseStringValue(value);
        if (ret == null || !(ret instanceof Color) || !ret.equals(Color.black)) {
            return ret;
        }
        String v = attrs.getStringAttribute(id, attrName);
        if (v == null) {
            return null;
        }
        if (v.equals("0,0,0")) {
            return ret;
        }
        return null;
    }

    public boolean getNodeSizeLocked() {
        return this.nodeSizeLocked;
    }

    public void setNodeSizeLocked(boolean b) {
        this.nodeSizeLocked = b;
    }
}

