/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.view.cytopanels;

import cytoscape.logger.CyLogger;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;

public class CytoPanelUtil {
    static final String WINDOWS = "windows";
    private static final int INSET = 5;

    public static Point getLocationOfExternalFrame(Dimension screenDimension, Rectangle containerBounds, Dimension frameDimension, int compassDirection, boolean outputDiagnostics) {
        if (outputDiagnostics) {
            CytoPanelUtil.outputDiagnostics(screenDimension, containerBounds, frameDimension, compassDirection);
        }
        Point containerLocation = containerBounds.getLocation();
        int containerWidth = (int)containerBounds.getWidth();
        int containerHeight = (int)containerBounds.getHeight();
        int screenWidth = (int)screenDimension.getWidth();
        int screenHeight = (int)screenDimension.getHeight();
        Point p = new Point(containerLocation.x, containerLocation.y);
        if (compassDirection == 7) {
            p.x = containerLocation.x - 5 - (int)frameDimension.getWidth();
        } else if (compassDirection == 3) {
            p.x = containerLocation.x + 5 + containerWidth;
        } else if (compassDirection == 5) {
            p.y = containerLocation.y + 5 + containerHeight;
        }
        p.x = Math.max(0, p.x);
        p.y = Math.max(0, p.y);
        if ((double)p.x + frameDimension.getWidth() > (double)screenWidth) {
            p.x = screenWidth - (int)frameDimension.getWidth();
        }
        if ((double)p.y + frameDimension.getHeight() > (double)screenHeight) {
            p.y = screenHeight - (int)frameDimension.getHeight();
        }
        return p;
    }

    public boolean isWindows() {
        String os = System.getProperty("os.name");
        return os.regionMatches(true, 0, WINDOWS, 0, WINDOWS.length());
    }

    private static void outputDiagnostics(Dimension screenDimension, Rectangle containerBounds, Dimension preferredSizeOfPanel, int compassDirection) {
        CyLogger.getLogger().warn("Compass Direction:  " + compassDirection);
        CyLogger.getLogger().warn("Screen Dimension:  " + screenDimension);
        CyLogger.getLogger().warn("Container Bounds:  " + containerBounds.toString());
        CyLogger.getLogger().warn("Preferred Size of Panel:  " + preferredSizeOfPanel.toString());
    }
}

