/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.view;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.actions.CreateNetworkViewAction;
import cytoscape.util.CyNetworkNaming;
import cytoscape.view.NetworkPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;

class PopupActionListener
implements ActionListener {
    public static final String DESTROY_VIEW = "Destroy View";
    public static final String CREATE_VIEW = "Create View";
    public static final String DESTROY_NETWORK = "Destroy Network";
    public static final String EDIT_TITLE = "Edit Network Title";
    protected CyNetwork cyNetwork;

    PopupActionListener() {
    }

    public void actionPerformed(ActionEvent ae) {
        String label = ((JMenuItem)ae.getSource()).getText();
        if (label == DESTROY_VIEW) {
            Cytoscape.destroyNetworkView(this.cyNetwork);
        } else if (label == CREATE_VIEW) {
            CreateNetworkViewAction.createViewFromCurrentNetwork(this.cyNetwork);
        } else if (label == DESTROY_NETWORK) {
            Cytoscape.destroyNetwork(this.cyNetwork);
        } else if (label == EDIT_TITLE) {
            CyNetworkNaming.editNetworkTitle(this.cyNetwork);
            Cytoscape.getDesktop().getNetworkPanel().updateTitle(this.cyNetwork);
        } else {
            NetworkPanel.logger.warn("Unexpected network panel popup option");
        }
    }

    public void setActiveNetwork(CyNetwork cyNetwork) {
        this.cyNetwork = cyNetwork;
    }
}

