/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.view;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.CytoscapeVersion;
import cytoscape.data.webservice.ui.WebServiceContextMenuListener;
import cytoscape.util.CytoscapeToolBar;
import cytoscape.util.undo.CyUndo;
import cytoscape.view.BirdsEyeViewHandler;
import cytoscape.view.CyHelpBroker;
import cytoscape.view.CyMenus;
import cytoscape.view.CyNetworkView;
import cytoscape.view.GraphViewController;
import cytoscape.view.NetworkPanel;
import cytoscape.view.NetworkViewManager;
import cytoscape.view.cytopanels.BiModalJSplitPane;
import cytoscape.view.cytopanels.CytoPanel;
import cytoscape.view.cytopanels.CytoPanelImp;
import cytoscape.view.cytopanels.CytoPanelState;
import cytoscape.visual.VisualMappingManager;
import cytoscape.visual.VisualStyle;
import cytoscape.visual.ui.VizMapBypassNetworkListener;
import cytoscape.visual.ui.VizMapUI;
import cytoscape.visual.ui.VizMapperMainPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.List;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.undo.UndoableEdit;

public class CytoscapeDesktop
extends JFrame
implements PropertyChangeListener {
    protected long lastPluginRegistryUpdate;
    protected int returnVal;
    private static final Dimension DEF_DESKTOP_SIZE = new Dimension(950, 700);
    public static final String NETWORK_VIEWS_SELECTED = "NETWORK_VIEWS_SELECTED";
    public static final String NETWORK_VIEW_FOCUSED = "NETWORK_VIEW_FOCUSED";
    public static final String NETWORK_VIEW_FOCUS = "NETWORK_VIEW_FOCUS";
    public static final String NETWORK_VIEW_CREATED = "NETWORK_VIEW_CREATED";
    public static final String NETWORK_VIEW_DESTROYED = "NETWORK_VIEW_DESTROYED";
    public static final String VISUAL_STYLE = "VISUAL_STYLE";
    public static final String VIZMAP_ENABLED = "VIZMAP_ENABLED";
    public static final int TABBED_VIEW = 0;
    public static final int INTERNAL_VIEW = 1;
    public static final int EXTERNAL_VIEW = 2;
    private static final String SMALL_ICON = "images/c16.png";
    protected VisualStyle defaultVisualStyle;
    protected NetworkPanel networkPanel;
    protected CyMenus cyMenus;
    protected NetworkViewManager networkViewManager;
    protected SwingPropertyChangeSupport pcs = new SwingPropertyChangeSupport(this);
    protected GraphViewController graphViewController;
    protected VisualMappingManager vmm;
    @Deprecated
    protected VizMapUI vizMapUI;
    protected VizMapperMainPanel vizmapperUI;
    protected String currentNetworkID;
    protected String currentNetworkViewID;
    protected CytoPanelImp cytoPanelWest;
    protected CytoPanelImp cytoPanelEast;
    protected CytoPanelImp cytoPanelSouth;
    protected CytoPanelImp cytoPanelSouthWest = new CytoPanelImp(6, 1, CytoPanelState.HIDE);
    protected JLabel statusBar;
    protected HashMap vsAssociationMap;
    protected JPanel main_panel;
    protected int styleBoxIndex = -1;
    private BirdsEyeViewHandler bevh;

    public CytoscapeDesktop(int view_type) {
        this();
    }

    public CytoscapeDesktop() {
        super("Cytoscape Desktop (New Session)");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource(SMALL_ICON)));
        this.main_panel = new JPanel();
        this.main_panel.setLayout(new BorderLayout());
        this.networkViewManager = new NetworkViewManager(this);
        this.getBirdsEyeViewHandler();
        this.getSwingPropertyChangeSupport().addPropertyChangeListener(this.bevh);
        Cytoscape.getPropertyChangeSupport().addPropertyChangeListener(this.bevh);
        this.networkPanel = new NetworkPanel(this);
        this.networkPanel.setNavigator(this.bevh.getBirdsEyeView());
        this.cyMenus = new CyMenus();
        Cytoscape.getSwingPropertyChangeSupport().addPropertyChangeListener(this);
        this.getSwingPropertyChangeSupport().addPropertyChangeListener(this.networkViewManager);
        this.networkViewManager.getSwingPropertyChangeSupport().addPropertyChangeListener(this);
        this.getSwingPropertyChangeSupport().addPropertyChangeListener(this.networkPanel);
        this.networkPanel.getSwingPropertyChangeSupport().addPropertyChangeListener(this);
        Cytoscape.getSwingPropertyChangeSupport().addPropertyChangeListener(new VizMapBypassNetworkListener());
        Cytoscape.getSwingPropertyChangeSupport().addPropertyChangeListener(new WebServiceContextMenuListener());
        this.cyMenus.initializeMenus();
        BiModalJSplitPane masterPane = this.setupCytoPanels(this.networkPanel, this.networkViewManager);
        this.main_panel.add((Component)masterPane, "Center");
        this.main_panel.add((Component)this.cyMenus.getToolBar(), "North");
        this.initStatusBar(this.main_panel);
        this.setJMenuBar(this.cyMenus.getMenuBar());
        this.getVizMapperUI();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                Cytoscape.exit(CytoscapeDesktop.this.returnVal);
            }
        });
        this.setContentPane(this.main_panel);
        this.pack();
        this.setSize(DEF_DESKTOP_SIZE);
        this.setVisible(true);
        this.toFront();
    }

    private void initStatusBar(JPanel panel) {
        this.statusBar = new JLabel();
        this.statusBar.setBorder(new EmptyBorder(0, 7, 5, 7));
        this.statusBar.setForeground(new Color(75, 75, 75));
        panel.add((Component)this.statusBar, "South");
        this.setStatusBarMsg("Welcome to Cytoscape " + CytoscapeVersion.version + "              Right-click + drag  to  ZOOM             Middle-click + drag  to  PAN");
    }

    public void setStatusBarMsg(String msg) {
        this.statusBar.setText(msg);
    }

    public void clearStatusBar() {
        this.statusBar.setText("   ");
    }

    public NetworkPanel getNetworkPanel() {
        return this.networkPanel;
    }

    public HelpBroker getHelpBroker() {
        return CyHelpBroker.getHelpBroker();
    }

    public HelpSet getHelpSet() {
        return CyHelpBroker.getHelpSet();
    }

    public void addEdit(UndoableEdit edit) {
        CyUndo.getUndoableEditSupport().postEdit(edit);
    }

    public int getViewType() {
        return 1;
    }

    public CyMenus getCyMenus() {
        return this.cyMenus;
    }

    public void setNewNetwork(CyNetwork newNetwork) {
    }

    @Deprecated
    public VizMapUI getVizMapUI() {
        return this.vizMapUI;
    }

    public VizMapperMainPanel getVizMapperUI() {
        if (this.vizmapperUI == null) {
            this.vmm = Cytoscape.getVisualMappingManager();
            this.vizmapperUI = VizMapperMainPanel.getVizMapperUI();
            this.getCytoPanel(7).add("VizMapper\u2122", this.vizmapperUI);
            this.getSwingPropertyChangeSupport().addPropertyChangeListener(this.vizmapperUI);
        }
        return this.vizmapperUI;
    }

    @Deprecated
    public void setupVizMapper() {
        this.vmm = Cytoscape.getVisualMappingManager();
        this.vizMapUI = new VizMapUI(this.vmm, this);
        this.vizMapUI.setName("vizMapUI");
        this.vmm.addChangeListener(this.vizMapUI.getStyleSelector());
        JComboBox styleBox = this.vizMapUI.getStyleSelector().getToolbarComboBox();
        Dimension newSize = new Dimension(150, (int)styleBox.getPreferredSize().getHeight());
        styleBox.setMaximumSize(newSize);
        styleBox.setPreferredSize(newSize);
        CytoscapeToolBar toolBar = this.cyMenus.getToolBar();
        if (this.styleBoxIndex == -1) {
            toolBar.add(styleBox);
            this.styleBoxIndex = toolBar.getComponentCount() - 1;
            toolBar.addSeparator();
        } else {
            toolBar.remove(this.styleBoxIndex);
            toolBar.add((Component)styleBox, this.styleBoxIndex);
        }
    }

    public VisualStyle setVisualStyle(VisualStyle style) {
        this.vmm.setVisualStyle(style);
        return null;
    }

    protected void updateFocus(String network_id) {
        VisualStyle old_style = this.vmm.getVisualStyle();
        CyNetworkView old_view = Cytoscape.getCurrentNetworkView();
        if (old_view != null) {
            old_view.putClientData(VISUAL_STYLE, old_style);
            old_view.putClientData(VIZMAP_ENABLED, new Boolean(old_view.getVisualMapperEnabled()));
        }
        Cytoscape.setCurrentNetwork(network_id);
        if (Cytoscape.setCurrentNetworkView(network_id)) {
            CyNetworkView new_view = Cytoscape.getCurrentNetworkView();
            VisualStyle new_style = new_view.getVisualStyle();
            Boolean vizmap_enabled = (Boolean)new_view.getClientData(VIZMAP_ENABLED);
            if (new_style == null) {
                new_style = this.vmm.getCalculatorCatalog().getVisualStyle("default");
            }
            if (vizmap_enabled == null) {
                vizmap_enabled = true;
            }
            this.vmm.setNetworkView(new_view);
            if (!new_style.getName().equals(old_style.getName())) {
                this.vmm.setVisualStyle(new_style);
                Cytoscape.getCurrentNetworkView().redrawGraph(false, true);
            }
        }
    }

    public void setFocus(String network_id) {
        this.pcs.firePropertyChange(new PropertyChangeEvent(this, NETWORK_VIEW_FOCUSED, null, network_id));
        this.pcs.firePropertyChange(new PropertyChangeEvent(this, NETWORK_VIEW_FOCUS, null, network_id));
    }

    public GraphViewController getGraphViewController() {
        if (this.graphViewController == null) {
            this.graphViewController = new GraphViewController();
        }
        return this.graphViewController;
    }

    public SwingPropertyChangeSupport getSwingPropertyChangeSupport() {
        return this.pcs;
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName() == NETWORK_VIEW_CREATED) {
            this.getGraphViewController().addGraphView((CyNetworkView)e.getNewValue());
            this.pcs.firePropertyChange(e);
        } else if (e.getPropertyName() == NETWORK_VIEW_FOCUSED) {
            this.updateFocus(e.getNewValue().toString());
            this.pcs.firePropertyChange(e);
        } else if (e.getPropertyName() == NETWORK_VIEW_FOCUS) {
            this.updateFocus(e.getNewValue().toString());
            this.pcs.firePropertyChange(e);
        } else if (e.getPropertyName() == NETWORK_VIEWS_SELECTED) {
            Cytoscape.setSelectedNetworkViews((List)e.getNewValue());
            Cytoscape.setSelectedNetworks((List)e.getNewValue());
            this.pcs.firePropertyChange(e);
        } else if (e.getPropertyName() == Cytoscape.NETWORK_CREATED) {
            this.pcs.firePropertyChange(e);
        } else if (e.getPropertyName() == Cytoscape.NETWORK_DESTROYED) {
            String message;
            int result;
            this.pcs.firePropertyChange(e);
            if (Cytoscape.getNetworkSet().size() == 0 && Cytoscape.getSessionstate() != Cytoscape.SESSION_OPENED && (result = JOptionPane.showConfirmDialog(this, message = "Do you want to create a new session?.\n(All attributes will be lost!)", "Create New Session?", 0, 2, null)) == 0) {
                Cytoscape.createNewSession();
            }
        } else if (e.getPropertyName() == NETWORK_VIEW_DESTROYED) {
            this.getGraphViewController().removeGraphView((CyNetworkView)e.getNewValue());
            this.pcs.firePropertyChange(e);
        }
    }

    public CytoPanel getCytoPanel(int compassDirection) {
        switch (compassDirection) {
            case 5: {
                return this.cytoPanelSouth;
            }
            case 3: {
                return this.cytoPanelEast;
            }
            case 7: {
                return this.cytoPanelWest;
            }
            case 6: {
                return this.cytoPanelSouthWest;
            }
        }
        throw new IllegalArgumentException("Illegal Argument:  " + compassDirection + ".  Must be one of:  SwingConstants.{SOUTH,EAST,WEST,SOUTH_WEST}.");
    }

    protected BiModalJSplitPane setupCytoPanels(NetworkPanel networkPanel, NetworkViewManager networkViewManager) {
        BiModalJSplitPane topRightPane = this.createTopRightPane(networkViewManager);
        BiModalJSplitPane rightPane = this.createRightPane(topRightPane);
        BiModalJSplitPane masterPane = this.createMasterPane(networkPanel, rightPane);
        return masterPane;
    }

    protected BiModalJSplitPane createTopRightPane(NetworkViewManager networkViewManager) {
        this.cytoPanelEast = new CytoPanelImp(3, 1, CytoPanelState.HIDE);
        JDesktopPane networkViewComp = null;
        networkViewComp = networkViewManager.getDesktopPane();
        BiModalJSplitPane splitPane = new BiModalJSplitPane(this, 1, 2, networkViewComp, this.cytoPanelEast);
        this.cytoPanelEast.setCytoPanelContainer(splitPane);
        splitPane.setResizeWeight(1.0);
        return splitPane;
    }

    protected BiModalJSplitPane createRightPane(BiModalJSplitPane topRightPane) {
        this.cytoPanelSouth = new CytoPanelImp(5, 3, CytoPanelState.HIDE);
        BiModalJSplitPane splitPane = new BiModalJSplitPane(this, 0, 2, topRightPane, this.cytoPanelSouth);
        this.cytoPanelSouth.setCytoPanelContainer(splitPane);
        splitPane.setResizeWeight(1.0);
        return splitPane;
    }

    protected BiModalJSplitPane createMasterPane(NetworkPanel networkPanel, BiModalJSplitPane rightPane) {
        this.cytoPanelWest = new CytoPanelImp(7, 1, CytoPanelState.DOCK);
        String tab1Name = new String("Network");
        this.cytoPanelWest.add(tab1Name, new ImageIcon(this.getClass().getResource("images/class_hi.gif")), networkPanel, "Cytoscape Network List");
        BiModalJSplitPane splitPane = new BiModalJSplitPane(this, 1, 1, this.cytoPanelWest, rightPane);
        this.cytoPanelWest.setCytoPanelContainer(splitPane);
        return splitPane;
    }

    public NetworkViewManager getNetworkViewManager() {
        return this.networkViewManager;
    }

    public BirdsEyeViewHandler getBirdsEyeViewHandler() {
        if (this.bevh == null) {
            this.bevh = new BirdsEyeViewHandler(this.networkViewManager.getDesktopPane());
        }
        return this.bevh;
    }

    public static int parseViewType(String vt) {
        return 1;
    }
}

